<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2022 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\Emoji;

use s9e\TextFormatter\Configurator\Helpers\ConfigHelper;
use s9e\TextFormatter\Configurator\Helpers\RegexpBuilder;
use s9e\TextFormatter\Configurator\Items\Regexp;
use s9e\TextFormatter\Configurator\JavaScript\Dictionary;
use s9e\TextFormatter\Plugins\ConfiguratorBase;

class Configurator extends ConfiguratorBase
{
	/**
	* @var array Aliases and their UTF-8 equivalent
	*/
	public $aliases = [':-1:'=>"\u{1f44e}",':+1:'=>"\u{1f44d}",':1st_place_medal:'=>"\u{1f947}",':2nd_place_medal:'=>"\u{1f948}",':3rd_place_medal:'=>"\u{1f949}",':8ball:'=>"\u{1f3b1}",':a:'=>"\u{1f170}\u{fe0f}",':ab:'=>"\u{1f18e}",':abc:'=>"\u{1f524}",':abcd:'=>"\u{1f521}",':accept:'=>"\u{1f251}",':adult:'=>"\u{1f9d1}\u{1f3ff}",':adult_tone1:'=>"\u{1f9d1}\u{1f3fb}",':adult_tone2:'=>"\u{1f9d1}\u{1f3fc}",':adult_tone3:'=>"\u{1f9d1}\u{1f3fd}",':adult_tone4:'=>"\u{1f9d1}\u{1f3fe}",':adult_tone5:'=>"\u{1f9d1}\u{1f3ff}",':aerial_tramway:'=>"\u{1f6a1}",':afghanistan:'=>"\u{1f1e6}\u{1f1eb}",':airplane:'=>"\u{2708}\u{fe0f}",':airplane_arriving:'=>"\u{1f6ec}",':airplane_departure:'=>"\u{1f6eb}",':airplane_small:'=>"\u{1f6e9}\u{fe0f}",':aland_islands:'=>"\u{1f1e6}\u{1f1fd}",':alarm_clock:'=>"\u{23f0}",':albania:'=>"\u{1f1e6}\u{1f1f1}",':alembic:'=>"\u{2697}\u{fe0f}",':algeria:'=>"\u{1f1e9}\u{1f1ff}",':alien:'=>"\u{1f47d}",':ambulance:'=>"\u{1f691}",':american_samoa:'=>"\u{1f1e6}\u{1f1f8}",':amphora:'=>"\u{1f3fa}",':anchor:'=>"\u{2693}\u{fe0f}",':andorra:'=>"\u{1f1e6}\u{1f1e9}",':angel:'=>"\u{1f47c}",':angel_tone1:'=>"\u{1f47c}\u{1f3fb}",':angel_tone2:'=>"\u{1f47c}\u{1f3fc}",':angel_tone3:'=>"\u{1f47c}\u{1f3fd}",':angel_tone4:'=>"\u{1f47c}\u{1f3fe}",':angel_tone5:'=>"\u{1f47c}\u{1f3ff}",':anger:'=>"\u{1f4a2}",':anger_right:'=>"\u{1f5ef}\u{fe0f}",':angola:'=>"\u{1f1e6}\u{1f1f4}",':angry:'=>"\u{1f620}",':anguilla:'=>"\u{1f1e6}\u{1f1ee}",':anguished:'=>"\u{1f627}",':ant:'=>"\u{1f41c}",':antarctica:'=>"\u{1f1e6}\u{1f1f6}",':antigua_barbuda:'=>"\u{1f1e6}\u{1f1ec}",':apple:'=>"\u{1f34e}",':aquarius:'=>"\u{2652}\u{fe0f}",':argentina:'=>"\u{1f1e6}\u{1f1f7}",':aries:'=>"\u{2648}\u{fe0f}",':armenia:'=>"\u{1f1e6}\u{1f1f2}",':arrow_backward:'=>"\u{25c0}\u{fe0f}",':arrow_double_down:'=>"\u{23ec}",':arrow_double_up:'=>"\u{23eb}",':arrow_down:'=>"\u{2b07}\u{fe0f}",':arrow_down_small:'=>"\u{1f53d}",':arrow_forward:'=>"\u{25b6}\u{fe0f}",':arrow_heading_down:'=>"\u{2935}\u{fe0f}",':arrow_heading_up:'=>"\u{2934}\u{fe0f}",':arrow_left:'=>"\u{2b05}\u{fe0f}",':arrow_lower_left:'=>"\u{2199}\u{fe0f}",':arrow_lower_right:'=>"\u{2198}\u{fe0f}",':arrow_right:'=>"\u{27a1}\u{fe0f}",':arrow_right_hook:'=>"\u{21aa}\u{fe0f}",':arrow_up:'=>"\u{2b06}\u{fe0f}",':arrow_up_down:'=>"\u{2195}\u{fe0f}",':arrow_up_small:'=>"\u{1f53c}",':arrow_upper_left:'=>"\u{2196}\u{fe0f}",':arrow_upper_right:'=>"\u{2197}\u{fe0f}",':arrows_clockwise:'=>"\u{1f503}",':arrows_counterclockwise:'=>"\u{1f504}",':art:'=>"\u{1f3a8}",':articulated_lorry:'=>"\u{1f69b}",':artificial_satellite:'=>"\u{1f6f0}",':aruba:'=>"\u{1f1e6}\u{1f1fc}",':asterisk:'=>"*\u{20e3}",':asterisk_symbol:'=>"*",':astonished:'=>"\u{1f632}",':athletic_shoe:'=>"\u{1f45f}",':atm:'=>"\u{1f3e7}",':atom:'=>"\u{269b}\u{fe0f}",':atom_symbol:'=>"\u{269b}\u{fe0f}",':australia:'=>"\u{1f1e6}\u{1f1fa}",':austria:'=>"\u{1f1e6}\u{1f1f9}",':avocado:'=>"\u{1f951}",':azerbaijan:'=>"\u{1f1e6}\u{1f1ff}",':b:'=>"\u{1f171}\u{fe0f}",':baby:'=>"\u{1f476}",':baby_bottle:'=>"\u{1f37c}",':baby_chick:'=>"\u{1f424}",':baby_symbol:'=>"\u{1f6bc}",':baby_tone1:'=>"\u{1f476}\u{1f3fb}",':baby_tone2:'=>"\u{1f476}\u{1f3fc}",':baby_tone3:'=>"\u{1f476}\u{1f3fd}",':baby_tone4:'=>"\u{1f476}\u{1f3fe}",':baby_tone5:'=>"\u{1f476}\u{1f3ff}",':back:'=>"\u{1f519}",':bacon:'=>"\u{1f953}",':badminton:'=>"\u{1f3f8}",':baggage_claim:'=>"\u{1f6c4}",':baguette_bread:'=>"\u{1f956}",':bahamas:'=>"\u{1f1e7}\u{1f1f8}",':bahrain:'=>"\u{1f1e7}\u{1f1ed}",':balance_scale:'=>"\u{2696}\u{fe0f}",':balloon:'=>"\u{1f388}",':ballot_box:'=>"\u{1f5f3}",':ballot_box_with_check:'=>"\u{2611}\u{fe0f}",':bamboo:'=>"\u{1f38d}",':banana:'=>"\u{1f34c}",':bangbang:'=>"\u{203c}\u{fe0f}",':bangladesh:'=>"\u{1f1e7}\u{1f1e9}",':bank:'=>"\u{1f3e6}",':bar_chart:'=>"\u{1f4ca}",':barbados:'=>"\u{1f1e7}\u{1f1e7}",':barber:'=>"\u{1f488}",':baseball:'=>"\u{26be}\u{fe0f}",':basketball:'=>"\u{1f3c0}",':basketball_man:'=>"\u{26f9}",':basketball_woman:'=>"\u{26f9}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':bat:'=>"\u{1f987}",':bath:'=>"\u{1f6c0}",':bath_tone1:'=>"\u{1f6c0}\u{1f3fb}",':bath_tone2:'=>"\u{1f6c0}\u{1f3fc}",':bath_tone3:'=>"\u{1f6c0}\u{1f3fd}",':bath_tone4:'=>"\u{1f6c0}\u{1f3fe}",':bath_tone5:'=>"\u{1f6c0}\u{1f3ff}",':bathtub:'=>"\u{1f6c1}",':battery:'=>"\u{1f50b}",':beach:'=>"\u{1f3d6}\u{fe0f}",':beach_umbrella:'=>"\u{1f3d6}",':bear:'=>"\u{1f43b}",':bearded_person:'=>"\u{1f9d4}\u{1f3ff}",':bearded_person_tone1:'=>"\u{1f9d4}\u{1f3fb}",':bearded_person_tone2:'=>"\u{1f9d4}\u{1f3fc}",':bearded_person_tone3:'=>"\u{1f9d4}\u{1f3fd}",':bearded_person_tone4:'=>"\u{1f9d4}\u{1f3fe}",':bearded_person_tone5:'=>"\u{1f9d4}\u{1f3ff}",':bed:'=>"\u{1f6cf}",':bee:'=>"\u{1f41d}",':beer:'=>"\u{1f37a}",':beers:'=>"\u{1f37b}",':beetle:'=>"\u{1f41e}",':beginner:'=>"\u{1f530}",':belarus:'=>"\u{1f1e7}\u{1f1fe}",':belgium:'=>"\u{1f1e7}\u{1f1ea}",':belize:'=>"\u{1f1e7}\u{1f1ff}",':bell:'=>"\u{1f514}",':bellhop:'=>"\u{1f6ce}\u{fe0f}",':bellhop_bell:'=>"\u{1f6ce}",':benin:'=>"\u{1f1e7}\u{1f1ef}",':bento:'=>"\u{1f371}",':bermuda:'=>"\u{1f1e7}\u{1f1f2}",':bhutan:'=>"\u{1f1e7}\u{1f1f9}",':bicyclist:'=>"\u{1f6b4}",':bike:'=>"\u{1f6b2}",':biking_man:'=>"\u{1f6b4}",':biking_woman:'=>"\u{1f6b4}\u{200d}\u{2640}\u{fe0f}",':bikini:'=>"\u{1f459}",':billed_cap:'=>"\u{1f9e2}",':biohazard:'=>"\u{2623}\u{fe0f}",':bird:'=>"\u{1f426}",':birthday:'=>"\u{1f382}",':black_circle:'=>"\u{26ab}\u{fe0f}",':black_flag:'=>"\u{1f3f4}",':black_heart:'=>"\u{1f5a4}",':black_joker:'=>"\u{1f0cf}",':black_large_square:'=>"\u{2b1b}\u{fe0f}",':black_medium_small_square:'=>"\u{25fe}\u{fe0f}",':black_medium_square:'=>"\u{25fc}\u{fe0f}",':black_nib:'=>"\u{2712}\u{fe0f}",':black_small_square:'=>"\u{25aa}\u{fe0f}",':black_square_button:'=>"\u{1f532}",':blond-haired_man:'=>"\u{1f471}\u{200d}\u{2642}\u{fe0f}",':blond-haired_man_tone1:'=>"\u{1f471}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':blond-haired_man_tone2:'=>"\u{1f471}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':blond-haired_man_tone3:'=>"\u{1f471}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':blond-haired_man_tone4:'=>"\u{1f471}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':blond-haired_man_tone5:'=>"\u{1f471}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':blond-haired_woman:'=>"\u{1f471}\u{200d}\u{2640}\u{fe0f}",':blond-haired_woman_tone1:'=>"\u{1f471}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':blond-haired_woman_tone2:'=>"\u{1f471}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':blond-haired_woman_tone3:'=>"\u{1f471}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':blond-haired_woman_tone4:'=>"\u{1f471}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':blond-haired_woman_tone5:'=>"\u{1f471}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':blond_haired_person:'=>"\u{1f471}",':blond_haired_person_tone1:'=>"\u{1f471}\u{1f3fb}",':blond_haired_person_tone2:'=>"\u{1f471}\u{1f3fc}",':blond_haired_person_tone3:'=>"\u{1f471}\u{1f3fd}",':blond_haired_person_tone4:'=>"\u{1f471}\u{1f3fe}",':blond_haired_person_tone5:'=>"\u{1f471}\u{1f3ff}",':blonde_man:'=>"\u{1f471}",':blonde_woman:'=>"\u{1f471}\u{200d}\u{2640}\u{fe0f}",':blossom:'=>"\u{1f33c}",':blowfish:'=>"\u{1f421}",':blue_book:'=>"\u{1f4d8}",':blue_car:'=>"\u{1f699}",':blue_circle:'=>"\u{1f535}",':blue_heart:'=>"\u{1f499}",':blush:'=>"\u{1f60a}",':boar:'=>"\u{1f417}",':boat:'=>"\u{26f5}\u{fe0f}",':bolivia:'=>"\u{1f1e7}\u{1f1f4}",':bomb:'=>"\u{1f4a3}",':book:'=>"\u{1f4d6}",':bookmark:'=>"\u{1f516}",':bookmark_tabs:'=>"\u{1f4d1}",':books:'=>"\u{1f4da}",':boom:'=>"\u{1f4a5}",':boot:'=>"\u{1f462}",':bosnia_herzegovina:'=>"\u{1f1e7}\u{1f1e6}",':botswana:'=>"\u{1f1e7}\u{1f1fc}",':bouquet:'=>"\u{1f490}",':bow:'=>"\u{1f647}",':bow_and_arrow:'=>"\u{1f3f9}",':bowing_man:'=>"\u{1f647}",':bowing_woman:'=>"\u{1f647}\u{200d}\u{2640}\u{fe0f}",':bowl_with_spoon:'=>"\u{1f963}",':bowling:'=>"\u{1f3b3}",':boxing_glove:'=>"\u{1f94a}",':boy:'=>"\u{1f466}",':boy_tone1:'=>"\u{1f466}\u{1f3fb}",':boy_tone2:'=>"\u{1f466}\u{1f3fc}",':boy_tone3:'=>"\u{1f466}\u{1f3fd}",':boy_tone4:'=>"\u{1f466}\u{1f3fe}",':boy_tone5:'=>"\u{1f466}\u{1f3ff}",':brain:'=>"\u{1f9e0}",':brazil:'=>"\u{1f1e7}\u{1f1f7}",':bread:'=>"\u{1f35e}",':breast_feeding:'=>"\u{1f931}",':breast_feeding_tone1:'=>"\u{1f931}\u{1f3fb}",':breast_feeding_tone2:'=>"\u{1f931}\u{1f3fc}",':breast_feeding_tone3:'=>"\u{1f931}\u{1f3fd}",':breast_feeding_tone4:'=>"\u{1f931}\u{1f3fe}",':breast_feeding_tone5:'=>"\u{1f931}\u{1f3ff}",':bride_with_veil:'=>"\u{1f470}",':bride_with_veil_tone1:'=>"\u{1f470}\u{1f3fb}",':bride_with_veil_tone2:'=>"\u{1f470}\u{1f3fc}",':bride_with_veil_tone3:'=>"\u{1f470}\u{1f3fd}",':bride_with_veil_tone4:'=>"\u{1f470}\u{1f3fe}",':bride_with_veil_tone5:'=>"\u{1f470}\u{1f3ff}",':bridge_at_night:'=>"\u{1f309}",':briefcase:'=>"\u{1f4bc}",':british_indian_ocean_territory:'=>"\u{1f1ee}\u{1f1f4}",':british_virgin_islands:'=>"\u{1f1fb}\u{1f1ec}",':broccoli:'=>"\u{1f966}",':broken_heart:'=>"\u{1f494}",':brunei:'=>"\u{1f1e7}\u{1f1f3}",':bug:'=>"\u{1f41b}",':building_construction:'=>"\u{1f3d7}",':bulb:'=>"\u{1f4a1}",':bulgaria:'=>"\u{1f1e7}\u{1f1ec}",':bullettrain_front:'=>"\u{1f685}",':bullettrain_side:'=>"\u{1f684}",':burkina_faso:'=>"\u{1f1e7}\u{1f1eb}",':burrito:'=>"\u{1f32f}",':burundi:'=>"\u{1f1e7}\u{1f1ee}",':bus:'=>"\u{1f68c}",':business_suit_levitating:'=>"\u{1f574}",':busstop:'=>"\u{1f68f}",':bust_in_silhouette:'=>"\u{1f464}",':busts_in_silhouette:'=>"\u{1f465}",':butterfly:'=>"\u{1f98b}",':cactus:'=>"\u{1f335}",':cake:'=>"\u{1f370}",':calendar:'=>"\u{1f4c6}",':calendar_spiral:'=>"\u{1f5d3}\u{fe0f}",':call_me:'=>"\u{1f919}",':call_me_hand:'=>"\u{1f919}",':call_me_tone1:'=>"\u{1f919}\u{1f3fb}",':call_me_tone2:'=>"\u{1f919}\u{1f3fc}",':call_me_tone3:'=>"\u{1f919}\u{1f3fd}",':call_me_tone4:'=>"\u{1f919}\u{1f3fe}",':call_me_tone5:'=>"\u{1f919}\u{1f3ff}",':calling:'=>"\u{1f4f2}",':cambodia:'=>"\u{1f1f0}\u{1f1ed}",':camel:'=>"\u{1f42b}",':camera:'=>"\u{1f4f7}",':camera_flash:'=>"\u{1f4f8}",':camera_with_flash:'=>"\u{1f4f8}",':cameroon:'=>"\u{1f1e8}\u{1f1f2}",':camping:'=>"\u{1f3d5}",':canada:'=>"\u{1f1e8}\u{1f1e6}",':canary_islands:'=>"\u{1f1ee}\u{1f1e8}",':cancer:'=>"\u{264b}\u{fe0f}",':candle:'=>"\u{1f56f}",':candy:'=>"\u{1f36c}",':canned_food:'=>"\u{1f96b}",':canoe:'=>"\u{1f6f6}",':cape_verde:'=>"\u{1f1e8}\u{1f1fb}",':capital_abcd:'=>"\u{1f520}",':capricorn:'=>"\u{2651}\u{fe0f}",':car:'=>"\u{1f697}",':card_box:'=>"\u{1f5c3}\u{fe0f}",':card_file_box:'=>"\u{1f5c3}",':card_index:'=>"\u{1f4c7}",':card_index_dividers:'=>"\u{1f5c2}",':caribbean_netherlands:'=>"\u{1f1e7}\u{1f1f6}",':carousel_horse:'=>"\u{1f3a0}",':carrot:'=>"\u{1f955}",':cat:'=>"\u{1f431}",':cat2:'=>"\u{1f408}",':cayman_islands:'=>"\u{1f1f0}\u{1f1fe}",':cd:'=>"\u{1f4bf}",':central_african_republic:'=>"\u{1f1e8}\u{1f1eb}",':chad:'=>"\u{1f1f9}\u{1f1e9}",':chains:'=>"\u{26d3}",':champagne:'=>"\u{1f37e}",':champagne_glass:'=>"\u{1f942}",':chart:'=>"\u{1f4b9}",':chart_with_downwards_trend:'=>"\u{1f4c9}",':chart_with_upwards_trend:'=>"\u{1f4c8}",':checkered_flag:'=>"\u{1f3c1}",':cheese:'=>"\u{1f9c0}",':cherries:'=>"\u{1f352}",':cherry_blossom:'=>"\u{1f338}",':chestnut:'=>"\u{1f330}",':chicken:'=>"\u{1f414}",':child:'=>"\u{1f9d2}\u{1f3ff}",':child_tone1:'=>"\u{1f9d2}\u{1f3fb}",':child_tone2:'=>"\u{1f9d2}\u{1f3fc}",':child_tone3:'=>"\u{1f9d2}\u{1f3fd}",':child_tone4:'=>"\u{1f9d2}\u{1f3fe}",':child_tone5:'=>"\u{1f9d2}\u{1f3ff}",':children_crossing:'=>"\u{1f6b8}",':chile:'=>"\u{1f1e8}\u{1f1f1}",':chipmunk:'=>"\u{1f43f}",':chocolate_bar:'=>"\u{1f36b}",':chopsticks:'=>"\u{1f962}",':christmas_island:'=>"\u{1f1e8}\u{1f1fd}",':christmas_tree:'=>"\u{1f384}",':church:'=>"\u{26ea}\u{fe0f}",':cinema:'=>"\u{1f3a6}",':circus_tent:'=>"\u{1f3aa}",':city_dusk:'=>"\u{1f306}",':city_sunrise:'=>"\u{1f307}",':city_sunset:'=>"\u{1f306}",':cityscape:'=>"\u{1f3d9}",':cl:'=>"\u{1f191}",':clamp:'=>"\u{1f5dc}",':clap:'=>"\u{1f44f}",':clap_tone1:'=>"\u{1f44f}\u{1f3fb}",':clap_tone2:'=>"\u{1f44f}\u{1f3fc}",':clap_tone3:'=>"\u{1f44f}\u{1f3fd}",':clap_tone4:'=>"\u{1f44f}\u{1f3fe}",':clap_tone5:'=>"\u{1f44f}\u{1f3ff}",':clapper:'=>"\u{1f3ac}",':classical_building:'=>"\u{1f3db}",':clinking_glasses:'=>"\u{1f942}",':clipboard:'=>"\u{1f4cb}",':clock:'=>"\u{1f570}\u{fe0f}",':clock1:'=>"\u{1f550}",':clock10:'=>"\u{1f559}",':clock1030:'=>"\u{1f565}",':clock11:'=>"\u{1f55a}",':clock1130:'=>"\u{1f566}",':clock12:'=>"\u{1f55b}",':clock1230:'=>"\u{1f567}",':clock130:'=>"\u{1f55c}",':clock2:'=>"\u{1f551}",':clock230:'=>"\u{1f55d}",':clock3:'=>"\u{1f552}",':clock330:'=>"\u{1f55e}",':clock4:'=>"\u{1f553}",':clock430:'=>"\u{1f55f}",':clock5:'=>"\u{1f554}",':clock530:'=>"\u{1f560}",':clock6:'=>"\u{1f555}",':clock630:'=>"\u{1f561}",':clock7:'=>"\u{1f556}",':clock730:'=>"\u{1f562}",':clock8:'=>"\u{1f557}",':clock830:'=>"\u{1f563}",':clock9:'=>"\u{1f558}",':clock930:'=>"\u{1f564}",':closed_book:'=>"\u{1f4d5}",':closed_lock_with_key:'=>"\u{1f510}",':closed_umbrella:'=>"\u{1f302}",':cloud:'=>"\u{2601}\u{fe0f}",':cloud_lightning:'=>"\u{1f329}\u{fe0f}",':cloud_rain:'=>"\u{1f327}\u{fe0f}",':cloud_snow:'=>"\u{1f328}\u{fe0f}",':cloud_tornado:'=>"\u{1f32a}\u{fe0f}",':cloud_with_lightning:'=>"\u{1f329}",':cloud_with_lightning_and_rain:'=>"\u{26c8}",':cloud_with_rain:'=>"\u{1f327}",':cloud_with_snow:'=>"\u{1f328}",':clown:'=>"\u{1f921}",':clown_face:'=>"\u{1f921}",':clubs:'=>"\u{2663}\u{fe0f}",':cn:'=>"\u{1f1e8}\u{1f1f3}",':coat:'=>"\u{1f9e5}",':cocktail:'=>"\u{1f378}",':coconut:'=>"\u{1f965}",':cocos_islands:'=>"\u{1f1e8}\u{1f1e8}",':coffee:'=>"\u{2615}\u{fe0f}",':coffin:'=>"\u{26b0}\u{fe0f}",':cold_sweat:'=>"\u{1f630}",':collision:'=>"\u{1f4a5}",':colombia:'=>"\u{1f1e8}\u{1f1f4}",':comet:'=>"\u{2604}",':comoros:'=>"\u{1f1f0}\u{1f1f2}",':compression:'=>"\u{1f5dc}\u{fe0f}",':computer:'=>"\u{1f4bb}",':computer_mouse:'=>"\u{1f5b1}",':confetti_ball:'=>"\u{1f38a}",':confounded:'=>"\u{1f616}",':confused:'=>"\u{1f615}",':congo_brazzaville:'=>"\u{1f1e8}\u{1f1ec}",':congo_kinshasa:'=>"\u{1f1e8}\u{1f1e9}",':congratulations:'=>"\u{3297}\u{fe0f}",':construction:'=>"\u{1f6a7}",':construction_site:'=>"\u{1f3d7}\u{fe0f}",':construction_worker:'=>"\u{1f477}",':construction_worker_man:'=>"\u{1f477}",':construction_worker_tone1:'=>"\u{1f477}\u{1f3fb}",':construction_worker_tone2:'=>"\u{1f477}\u{1f3fc}",':construction_worker_tone3:'=>"\u{1f477}\u{1f3fd}",':construction_worker_tone4:'=>"\u{1f477}\u{1f3fe}",':construction_worker_tone5:'=>"\u{1f477}\u{1f3ff}",':construction_worker_woman:'=>"\u{1f477}\u{200d}\u{2640}\u{fe0f}",':control_knobs:'=>"\u{1f39b}",':convenience_store:'=>"\u{1f3ea}",':cook_islands:'=>"\u{1f1e8}\u{1f1f0}",':cookie:'=>"\u{1f36a}",':cooking:'=>"\u{1f373}",':cool:'=>"\u{1f192}",':cop:'=>"\u{1f46e}",':copyright:'=>"\u{a9}\u{fe0f}",':corn:'=>"\u{1f33d}",':costa_rica:'=>"\u{1f1e8}\u{1f1f7}",':cote_divoire:'=>"\u{1f1e8}\u{1f1ee}",':couch:'=>"\u{1f6cb}\u{fe0f}",':couch_and_lamp:'=>"\u{1f6cb}",':couple:'=>"\u{1f46b}",':couple_mm:'=>"\u{1f468}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f468}",':couple_with_heart:'=>"\u{1f491}",':couple_with_heart_man_man:'=>"\u{1f468}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f468}",':couple_with_heart_woman_man:'=>"\u{1f491}",':couple_with_heart_woman_woman:'=>"\u{1f469}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f469}",':couple_ww:'=>"\u{1f469}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f469}",':couplekiss:'=>"\u{1f48f}",':couplekiss_man_man:'=>"\u{1f468}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f48b}\u{200d}\u{1f468}",':couplekiss_man_woman:'=>"\u{1f48f}",':couplekiss_woman_woman:'=>"\u{1f469}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f48b}\u{200d}\u{1f469}",':cow:'=>"\u{1f42e}",':cow2:'=>"\u{1f404}",':cowboy:'=>"\u{1f920}",':cowboy_hat_face:'=>"\u{1f920}",':crab:'=>"\u{1f980}",':crayon:'=>"\u{1f58d}",':crazy_face:'=>"\u{1f92a}",':credit_card:'=>"\u{1f4b3}",':crescent_moon:'=>"\u{1f319}",':cricket:'=>"\u{1f3cf}",':cricket_game:'=>"\u{1f3cf}",':croatia:'=>"\u{1f1ed}\u{1f1f7}",':crocodile:'=>"\u{1f40a}",':croissant:'=>"\u{1f950}",':cross:'=>"\u{271d}\u{fe0f}",':crossed_fingers:'=>"\u{1f91e}",':crossed_flags:'=>"\u{1f38c}",':crossed_swords:'=>"\u{2694}\u{fe0f}",':crown:'=>"\u{1f451}",':cruise_ship:'=>"\u{1f6f3}\u{fe0f}",':cry:'=>"\u{1f622}",':crying_cat_face:'=>"\u{1f63f}",':crystal_ball:'=>"\u{1f52e}",':cuba:'=>"\u{1f1e8}\u{1f1fa}",':cucumber:'=>"\u{1f952}",':cup_with_straw:'=>"\u{1f964}",':cupid:'=>"\u{1f498}",':curacao:'=>"\u{1f1e8}\u{1f1fc}",':curling_stone:'=>"\u{1f94c}",':curly_loop:'=>"\u{27b0}",':currency_exchange:'=>"\u{1f4b1}",':curry:'=>"\u{1f35b}",':custard:'=>"\u{1f36e}",':customs:'=>"\u{1f6c3}",':cut_of_meat:'=>"\u{1f969}",':cyclone:'=>"\u{1f300}",':cyprus:'=>"\u{1f1e8}\u{1f1fe}",':czech_republic:'=>"\u{1f1e8}\u{1f1ff}",':dagger:'=>"\u{1f5e1}",':dancer:'=>"\u{1f483}",':dancer_tone1:'=>"\u{1f483}\u{1f3fb}",':dancer_tone2:'=>"\u{1f483}\u{1f3fc}",':dancer_tone3:'=>"\u{1f483}\u{1f3fd}",':dancer_tone4:'=>"\u{1f483}\u{1f3fe}",':dancer_tone5:'=>"\u{1f483}\u{1f3ff}",':dancers:'=>"\u{1f46f}",':dancing_men:'=>"\u{1f46f}\u{200d}\u{2642}\u{fe0f}",':dancing_women:'=>"\u{1f46f}",':dango:'=>"\u{1f361}",':dark_sunglasses:'=>"\u{1f576}",':dart:'=>"\u{1f3af}",':dash:'=>"\u{1f4a8}",':date:'=>"\u{1f4c5}",':de:'=>"\u{1f1e9}\u{1f1ea}",':deciduous_tree:'=>"\u{1f333}",':deer:'=>"\u{1f98c}",':denmark:'=>"\u{1f1e9}\u{1f1f0}",':department_store:'=>"\u{1f3ec}",':derelict_house:'=>"\u{1f3da}",':desert:'=>"\u{1f3dc}",':desert_island:'=>"\u{1f3dd}",':desktop:'=>"\u{1f5a5}\u{fe0f}",':desktop_computer:'=>"\u{1f5a5}",':detective:'=>"\u{1f575}",':detective_tone1:'=>"\u{1f575}\u{1f3fb}",':detective_tone2:'=>"\u{1f575}\u{1f3fc}",':detective_tone3:'=>"\u{1f575}\u{1f3fd}",':detective_tone4:'=>"\u{1f575}\u{1f3fe}",':detective_tone5:'=>"\u{1f575}\u{1f3ff}",':diamond_shape_with_a_dot_inside:'=>"\u{1f4a0}",':diamonds:'=>"\u{2666}\u{fe0f}",':digit_eight:'=>"8",':digit_five:'=>"5",':digit_four:'=>"4",':digit_nine:'=>"9",':digit_one:'=>"1",':digit_seven:'=>"7",':digit_six:'=>"6",':digit_three:'=>"3",':digit_two:'=>"2",':digit_zero:'=>"0",':disappointed:'=>"\u{1f61e}",':disappointed_relieved:'=>"\u{1f625}",':dividers:'=>"\u{1f5c2}\u{fe0f}",':dizzy:'=>"\u{1f4ab}",':dizzy_face:'=>"\u{1f635}",':djibouti:'=>"\u{1f1e9}\u{1f1ef}",':do_not_litter:'=>"\u{1f6af}",':dog:'=>"\u{1f436}",':dog2:'=>"\u{1f415}",':dollar:'=>"\u{1f4b5}",':dolls:'=>"\u{1f38e}",':dolphin:'=>"\u{1f42c}",':dominica:'=>"\u{1f1e9}\u{1f1f2}",':dominican_republic:'=>"\u{1f1e9}\u{1f1f4}",':door:'=>"\u{1f6aa}",':doughnut:'=>"\u{1f369}",':dove:'=>"\u{1f54a}",':dragon:'=>"\u{1f409}",':dragon_face:'=>"\u{1f432}",':dress:'=>"\u{1f457}",':dromedary_camel:'=>"\u{1f42a}",':drooling_face:'=>"\u{1f924}",':droplet:'=>"\u{1f4a7}",':drum:'=>"\u{1f941}",':duck:'=>"\u{1f986}",':dumpling:'=>"\u{1f95f}",':dvd:'=>"\u{1f4c0}",':e-mail:'=>"\u{1f4e7}",':eagle:'=>"\u{1f985}",':ear:'=>"\u{1f442}",':ear_of_rice:'=>"\u{1f33e}",':ear_tone1:'=>"\u{1f442}\u{1f3fb}",':ear_tone2:'=>"\u{1f442}\u{1f3fc}",':ear_tone3:'=>"\u{1f442}\u{1f3fd}",':ear_tone4:'=>"\u{1f442}\u{1f3fe}",':ear_tone5:'=>"\u{1f442}\u{1f3ff}",':earth_africa:'=>"\u{1f30d}",':earth_americas:'=>"\u{1f30e}",':earth_asia:'=>"\u{1f30f}",':ecuador:'=>"\u{1f1ea}\u{1f1e8}",':egg:'=>"\u{1f95a}",':eggplant:'=>"\u{1f346}",':egypt:'=>"\u{1f1ea}\u{1f1ec}",':eight:'=>"8\u{20e3}",':eight_pointed_black_star:'=>"\u{2734}\u{fe0f}",':eight_spoked_asterisk:'=>"\u{2733}\u{fe0f}",':eject:'=>"\u{23cf}\u{fe0f}",':el_salvador:'=>"\u{1f1f8}\u{1f1fb}",':electric_plug:'=>"\u{1f50c}",':elephant:'=>"\u{1f418}",':elf:'=>"\u{1f9dd}\u{1f3ff}",':elf_tone1:'=>"\u{1f9dd}\u{1f3fb}",':elf_tone2:'=>"\u{1f9dd}\u{1f3fc}",':elf_tone3:'=>"\u{1f9dd}\u{1f3fd}",':elf_tone4:'=>"\u{1f9dd}\u{1f3fe}",':elf_tone5:'=>"\u{1f9dd}\u{1f3ff}",':email:'=>"\u{2709}\u{fe0f}",':end:'=>"\u{1f51a}",':england:'=>"\u{1f3f4}\u{e0067}\u{e0062}\u{e0065}\u{e006e}\u{e0067}\u{e007f}",':envelope:'=>"\u{2709}\u{fe0f}",':envelope_with_arrow:'=>"\u{1f4e9}",':equatorial_guinea:'=>"\u{1f1ec}\u{1f1f6}",':eritrea:'=>"\u{1f1ea}\u{1f1f7}",':es:'=>"\u{1f1ea}\u{1f1f8}",':estonia:'=>"\u{1f1ea}\u{1f1ea}",':ethiopia:'=>"\u{1f1ea}\u{1f1f9}",':eu:'=>"\u{1f1ea}\u{1f1fa}",':euro:'=>"\u{1f4b6}",':european_castle:'=>"\u{1f3f0}",':european_post_office:'=>"\u{1f3e4}",':european_union:'=>"\u{1f1ea}\u{1f1fa}",':evergreen_tree:'=>"\u{1f332}",':exclamation:'=>"\u{2757}\u{fe0f}",':exploding_head:'=>"\u{1f92f}",':expressionless:'=>"\u{1f611}",':eye:'=>"\u{1f441}",':eye_in_speech_bubble:'=>"\u{1f441}\u{200d}\u{1f5e8}",':eye_speech_bubble:'=>"\u{1f441}\u{200d}\u{1f5e8}",':eyeglasses:'=>"\u{1f453}",':eyes:'=>"\u{1f440}",':face_vomiting:'=>"\u{1f92e}",':face_with_hand_over_mouth:'=>"\u{1f92d}",':face_with_head_bandage:'=>"\u{1f915}",':face_with_monocle:'=>"\u{1f9d0}",':face_with_raised_eyebrow:'=>"\u{1f928}",':face_with_symbols_over_mouth:'=>"\u{1f92c}",':face_with_thermometer:'=>"\u{1f912}",':facepunch:'=>"\u{1f44a}",':factory:'=>"\u{1f3ed}",':fairy:'=>"\u{1f9da}\u{1f3ff}",':fairy_tone1:'=>"\u{1f9da}\u{1f3fb}",':fairy_tone2:'=>"\u{1f9da}\u{1f3fc}",':fairy_tone3:'=>"\u{1f9da}\u{1f3fd}",':fairy_tone4:'=>"\u{1f9da}\u{1f3fe}",':fairy_tone5:'=>"\u{1f9da}\u{1f3ff}",':falkland_islands:'=>"\u{1f1eb}\u{1f1f0}",':fallen_leaf:'=>"\u{1f342}",':family:'=>"\u{1f46a}",':family_man_boy:'=>"\u{1f468}\u{200d}\u{1f466}",':family_man_boy_boy:'=>"\u{1f468}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_man_girl:'=>"\u{1f468}\u{200d}\u{1f467}",':family_man_girl_boy:'=>"\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_man_girl_girl:'=>"\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_man_man_boy:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f466}",':family_man_man_boy_boy:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_man_man_girl:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}",':family_man_man_girl_boy:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_man_man_girl_girl:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_man_woman_boy:'=>"\u{1f46a}",':family_man_woman_boy_boy:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_man_woman_girl:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}",':family_man_woman_girl_boy:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_man_woman_girl_girl:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_mmb:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f466}",':family_mmbb:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_mmg:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}",':family_mmgb:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_mmgg:'=>"\u{1f468}\u{200d}\u{1f468}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_mwbb:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_mwg:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}",':family_mwgb:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_mwgg:'=>"\u{1f468}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_woman_boy:'=>"\u{1f469}\u{200d}\u{1f466}",':family_woman_boy_boy:'=>"\u{1f469}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_woman_girl:'=>"\u{1f469}\u{200d}\u{1f467}",':family_woman_girl_boy:'=>"\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_woman_girl_girl:'=>"\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_woman_woman_boy:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f466}",':family_woman_woman_boy_boy:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_woman_woman_girl:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}",':family_woman_woman_girl_boy:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_woman_woman_girl_girl:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f467}",':family_wwb:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f466}",':family_wwbb:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f466}\u{200d}\u{1f466}",':family_wwg:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}",':family_wwgb:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f466}",':family_wwgg:'=>"\u{1f469}\u{200d}\u{1f469}\u{200d}\u{1f467}\u{200d}\u{1f467}",':faroe_islands:'=>"\u{1f1eb}\u{1f1f4}",':fast_forward:'=>"\u{23e9}",':fax:'=>"\u{1f4e0}",':fearful:'=>"\u{1f628}",':feet:'=>"\u{1f43e}",':female_detective:'=>"\u{1f575}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':female_sign:'=>"\u{2640}\u{fe0f}",':ferris_wheel:'=>"\u{1f3a1}",':ferry:'=>"\u{26f4}",':field_hockey:'=>"\u{1f3d1}",':fiji:'=>"\u{1f1eb}\u{1f1ef}",':file_cabinet:'=>"\u{1f5c4}",':file_folder:'=>"\u{1f4c1}",':film_frames:'=>"\u{1f39e}\u{fe0f}",':film_projector:'=>"\u{1f4fd}",':film_strip:'=>"\u{1f39e}",':fingers_crossed:'=>"\u{1f91e}",':fingers_crossed_tone1:'=>"\u{1f91e}\u{1f3fb}",':fingers_crossed_tone2:'=>"\u{1f91e}\u{1f3fc}",':fingers_crossed_tone3:'=>"\u{1f91e}\u{1f3fd}",':fingers_crossed_tone4:'=>"\u{1f91e}\u{1f3fe}",':fingers_crossed_tone5:'=>"\u{1f91e}\u{1f3ff}",':finland:'=>"\u{1f1eb}\u{1f1ee}",':fire:'=>"\u{1f525}",':fire_engine:'=>"\u{1f692}",':fireworks:'=>"\u{1f386}",':first_place:'=>"\u{1f947}",':first_quarter_moon:'=>"\u{1f313}",':first_quarter_moon_with_face:'=>"\u{1f31b}",':fish:'=>"\u{1f41f}",':fish_cake:'=>"\u{1f365}",':fishing_pole_and_fish:'=>"\u{1f3a3}",':fist:'=>"\u{270a}",':fist_left:'=>"\u{1f91b}",':fist_oncoming:'=>"\u{1f44a}",':fist_raised:'=>"\u{270a}",':fist_right:'=>"\u{1f91c}",':fist_tone1:'=>"\u{270a}\u{1f3fb}",':fist_tone2:'=>"\u{270a}\u{1f3fc}",':fist_tone3:'=>"\u{270a}\u{1f3fd}",':fist_tone4:'=>"\u{270a}\u{1f3fe}",':fist_tone5:'=>"\u{270a}\u{1f3ff}",':five:'=>"5\u{20e3}",':flag_ac:'=>"\u{1f1e6}\u{1f1e8}",':flag_ad:'=>"\u{1f1e6}\u{1f1e9}",':flag_ae:'=>"\u{1f1e6}\u{1f1ea}",':flag_af:'=>"\u{1f1e6}\u{1f1eb}",':flag_ag:'=>"\u{1f1e6}\u{1f1ec}",':flag_ai:'=>"\u{1f1e6}\u{1f1ee}",':flag_al:'=>"\u{1f1e6}\u{1f1f1}",':flag_am:'=>"\u{1f1e6}\u{1f1f2}",':flag_ao:'=>"\u{1f1e6}\u{1f1f4}",':flag_aq:'=>"\u{1f1e6}\u{1f1f6}",':flag_ar:'=>"\u{1f1e6}\u{1f1f7}",':flag_as:'=>"\u{1f1e6}\u{1f1f8}",':flag_at:'=>"\u{1f1e6}\u{1f1f9}",':flag_au:'=>"\u{1f1e6}\u{1f1fa}",':flag_aw:'=>"\u{1f1e6}\u{1f1fc}",':flag_ax:'=>"\u{1f1e6}\u{1f1fd}",':flag_az:'=>"\u{1f1e6}\u{1f1ff}",':flag_ba:'=>"\u{1f1e7}\u{1f1e6}",':flag_bb:'=>"\u{1f1e7}\u{1f1e7}",':flag_bd:'=>"\u{1f1e7}\u{1f1e9}",':flag_be:'=>"\u{1f1e7}\u{1f1ea}",':flag_bf:'=>"\u{1f1e7}\u{1f1eb}",':flag_bg:'=>"\u{1f1e7}\u{1f1ec}",':flag_bh:'=>"\u{1f1e7}\u{1f1ed}",':flag_bi:'=>"\u{1f1e7}\u{1f1ee}",':flag_bj:'=>"\u{1f1e7}\u{1f1ef}",':flag_bl:'=>"\u{1f1e7}\u{1f1f1}",':flag_black:'=>"\u{1f3f4}",':flag_bm:'=>"\u{1f1e7}\u{1f1f2}",':flag_bn:'=>"\u{1f1e7}\u{1f1f3}",':flag_bo:'=>"\u{1f1e7}\u{1f1f4}",':flag_bq:'=>"\u{1f1e7}\u{1f1f6}",':flag_br:'=>"\u{1f1e7}\u{1f1f7}",':flag_bs:'=>"\u{1f1e7}\u{1f1f8}",':flag_bt:'=>"\u{1f1e7}\u{1f1f9}",':flag_bv:'=>"\u{1f1e7}\u{1f1fb}",':flag_bw:'=>"\u{1f1e7}\u{1f1fc}",':flag_by:'=>"\u{1f1e7}\u{1f1fe}",':flag_bz:'=>"\u{1f1e7}\u{1f1ff}",':flag_ca:'=>"\u{1f1e8}\u{1f1e6}",':flag_cc:'=>"\u{1f1e8}\u{1f1e8}",':flag_cd:'=>"\u{1f1e8}\u{1f1e9}",':flag_cf:'=>"\u{1f1e8}\u{1f1eb}",':flag_cg:'=>"\u{1f1e8}\u{1f1ec}",':flag_ch:'=>"\u{1f1e8}\u{1f1ed}",':flag_ci:'=>"\u{1f1e8}\u{1f1ee}",':flag_ck:'=>"\u{1f1e8}\u{1f1f0}",':flag_cl:'=>"\u{1f1e8}\u{1f1f1}",':flag_cm:'=>"\u{1f1e8}\u{1f1f2}",':flag_cn:'=>"\u{1f1e8}\u{1f1f3}",':flag_co:'=>"\u{1f1e8}\u{1f1f4}",':flag_cp:'=>"\u{1f1e8}\u{1f1f5}",':flag_cr:'=>"\u{1f1e8}\u{1f1f7}",':flag_cu:'=>"\u{1f1e8}\u{1f1fa}",':flag_cv:'=>"\u{1f1e8}\u{1f1fb}",':flag_cw:'=>"\u{1f1e8}\u{1f1fc}",':flag_cx:'=>"\u{1f1e8}\u{1f1fd}",':flag_cy:'=>"\u{1f1e8}\u{1f1fe}",':flag_cz:'=>"\u{1f1e8}\u{1f1ff}",':flag_de:'=>"\u{1f1e9}\u{1f1ea}",':flag_dg:'=>"\u{1f1e9}\u{1f1ec}",':flag_dj:'=>"\u{1f1e9}\u{1f1ef}",':flag_dk:'=>"\u{1f1e9}\u{1f1f0}",':flag_dm:'=>"\u{1f1e9}\u{1f1f2}",':flag_do:'=>"\u{1f1e9}\u{1f1f4}",':flag_dz:'=>"\u{1f1e9}\u{1f1ff}",':flag_ea:'=>"\u{1f1ea}\u{1f1e6}",':flag_ec:'=>"\u{1f1ea}\u{1f1e8}",':flag_ee:'=>"\u{1f1ea}\u{1f1ea}",':flag_eg:'=>"\u{1f1ea}\u{1f1ec}",':flag_eh:'=>"\u{1f1ea}\u{1f1ed}",':flag_er:'=>"\u{1f1ea}\u{1f1f7}",':flag_es:'=>"\u{1f1ea}\u{1f1f8}",':flag_et:'=>"\u{1f1ea}\u{1f1f9}",':flag_eu:'=>"\u{1f1ea}\u{1f1fa}",':flag_fi:'=>"\u{1f1eb}\u{1f1ee}",':flag_fj:'=>"\u{1f1eb}\u{1f1ef}",':flag_fk:'=>"\u{1f1eb}\u{1f1f0}",':flag_fm:'=>"\u{1f1eb}\u{1f1f2}",':flag_fo:'=>"\u{1f1eb}\u{1f1f4}",':flag_fr:'=>"\u{1f1eb}\u{1f1f7}",':flag_ga:'=>"\u{1f1ec}\u{1f1e6}",':flag_gb:'=>"\u{1f1ec}\u{1f1e7}",':flag_gd:'=>"\u{1f1ec}\u{1f1e9}",':flag_ge:'=>"\u{1f1ec}\u{1f1ea}",':flag_gf:'=>"\u{1f1ec}\u{1f1eb}",':flag_gg:'=>"\u{1f1ec}\u{1f1ec}",':flag_gh:'=>"\u{1f1ec}\u{1f1ed}",':flag_gi:'=>"\u{1f1ec}\u{1f1ee}",':flag_gl:'=>"\u{1f1ec}\u{1f1f1}",':flag_gm:'=>"\u{1f1ec}\u{1f1f2}",':flag_gn:'=>"\u{1f1ec}\u{1f1f3}",':flag_gp:'=>"\u{1f1ec}\u{1f1f5}",':flag_gq:'=>"\u{1f1ec}\u{1f1f6}",':flag_gr:'=>"\u{1f1ec}\u{1f1f7}",':flag_gs:'=>"\u{1f1ec}\u{1f1f8}",':flag_gt:'=>"\u{1f1ec}\u{1f1f9}",':flag_gu:'=>"\u{1f1ec}\u{1f1fa}",':flag_gw:'=>"\u{1f1ec}\u{1f1fc}",':flag_gy:'=>"\u{1f1ec}\u{1f1fe}",':flag_hk:'=>"\u{1f1ed}\u{1f1f0}",':flag_hm:'=>"\u{1f1ed}\u{1f1f2}",':flag_hn:'=>"\u{1f1ed}\u{1f1f3}",':flag_hr:'=>"\u{1f1ed}\u{1f1f7}",':flag_ht:'=>"\u{1f1ed}\u{1f1f9}",':flag_hu:'=>"\u{1f1ed}\u{1f1fa}",':flag_ic:'=>"\u{1f1ee}\u{1f1e8}",':flag_id:'=>"\u{1f1ee}\u{1f1e9}",':flag_ie:'=>"\u{1f1ee}\u{1f1ea}",':flag_il:'=>"\u{1f1ee}\u{1f1f1}",':flag_im:'=>"\u{1f1ee}\u{1f1f2}",':flag_in:'=>"\u{1f1ee}\u{1f1f3}",':flag_io:'=>"\u{1f1ee}\u{1f1f4}",':flag_iq:'=>"\u{1f1ee}\u{1f1f6}",':flag_ir:'=>"\u{1f1ee}\u{1f1f7}",':flag_is:'=>"\u{1f1ee}\u{1f1f8}",':flag_it:'=>"\u{1f1ee}\u{1f1f9}",':flag_je:'=>"\u{1f1ef}\u{1f1ea}",':flag_jm:'=>"\u{1f1ef}\u{1f1f2}",':flag_jo:'=>"\u{1f1ef}\u{1f1f4}",':flag_jp:'=>"\u{1f1ef}\u{1f1f5}",':flag_ke:'=>"\u{1f1f0}\u{1f1ea}",':flag_kg:'=>"\u{1f1f0}\u{1f1ec}",':flag_kh:'=>"\u{1f1f0}\u{1f1ed}",':flag_ki:'=>"\u{1f1f0}\u{1f1ee}",':flag_km:'=>"\u{1f1f0}\u{1f1f2}",':flag_kn:'=>"\u{1f1f0}\u{1f1f3}",':flag_kp:'=>"\u{1f1f0}\u{1f1f5}",':flag_kr:'=>"\u{1f1f0}\u{1f1f7}",':flag_kw:'=>"\u{1f1f0}\u{1f1fc}",':flag_ky:'=>"\u{1f1f0}\u{1f1fe}",':flag_kz:'=>"\u{1f1f0}\u{1f1ff}",':flag_la:'=>"\u{1f1f1}\u{1f1e6}",':flag_lb:'=>"\u{1f1f1}\u{1f1e7}",':flag_lc:'=>"\u{1f1f1}\u{1f1e8}",':flag_li:'=>"\u{1f1f1}\u{1f1ee}",':flag_lk:'=>"\u{1f1f1}\u{1f1f0}",':flag_lr:'=>"\u{1f1f1}\u{1f1f7}",':flag_ls:'=>"\u{1f1f1}\u{1f1f8}",':flag_lt:'=>"\u{1f1f1}\u{1f1f9}",':flag_lu:'=>"\u{1f1f1}\u{1f1fa}",':flag_lv:'=>"\u{1f1f1}\u{1f1fb}",':flag_ly:'=>"\u{1f1f1}\u{1f1fe}",':flag_ma:'=>"\u{1f1f2}\u{1f1e6}",':flag_mc:'=>"\u{1f1f2}\u{1f1e8}",':flag_md:'=>"\u{1f1f2}\u{1f1e9}",':flag_me:'=>"\u{1f1f2}\u{1f1ea}",':flag_mf:'=>"\u{1f1f2}\u{1f1eb}",':flag_mg:'=>"\u{1f1f2}\u{1f1ec}",':flag_mh:'=>"\u{1f1f2}\u{1f1ed}",':flag_mk:'=>"\u{1f1f2}\u{1f1f0}",':flag_ml:'=>"\u{1f1f2}\u{1f1f1}",':flag_mm:'=>"\u{1f1f2}\u{1f1f2}",':flag_mn:'=>"\u{1f1f2}\u{1f1f3}",':flag_mo:'=>"\u{1f1f2}\u{1f1f4}",':flag_mp:'=>"\u{1f1f2}\u{1f1f5}",':flag_mq:'=>"\u{1f1f2}\u{1f1f6}",':flag_mr:'=>"\u{1f1f2}\u{1f1f7}",':flag_ms:'=>"\u{1f1f2}\u{1f1f8}",':flag_mt:'=>"\u{1f1f2}\u{1f1f9}",':flag_mu:'=>"\u{1f1f2}\u{1f1fa}",':flag_mv:'=>"\u{1f1f2}\u{1f1fb}",':flag_mw:'=>"\u{1f1f2}\u{1f1fc}",':flag_mx:'=>"\u{1f1f2}\u{1f1fd}",':flag_my:'=>"\u{1f1f2}\u{1f1fe}",':flag_mz:'=>"\u{1f1f2}\u{1f1ff}",':flag_na:'=>"\u{1f1f3}\u{1f1e6}",':flag_nc:'=>"\u{1f1f3}\u{1f1e8}",':flag_ne:'=>"\u{1f1f3}\u{1f1ea}",':flag_nf:'=>"\u{1f1f3}\u{1f1eb}",':flag_ng:'=>"\u{1f1f3}\u{1f1ec}",':flag_ni:'=>"\u{1f1f3}\u{1f1ee}",':flag_nl:'=>"\u{1f1f3}\u{1f1f1}",':flag_no:'=>"\u{1f1f3}\u{1f1f4}",':flag_np:'=>"\u{1f1f3}\u{1f1f5}",':flag_nr:'=>"\u{1f1f3}\u{1f1f7}",':flag_nu:'=>"\u{1f1f3}\u{1f1fa}",':flag_nz:'=>"\u{1f1f3}\u{1f1ff}",':flag_om:'=>"\u{1f1f4}\u{1f1f2}",':flag_pa:'=>"\u{1f1f5}\u{1f1e6}",':flag_pe:'=>"\u{1f1f5}\u{1f1ea}",':flag_pf:'=>"\u{1f1f5}\u{1f1eb}",':flag_pg:'=>"\u{1f1f5}\u{1f1ec}",':flag_ph:'=>"\u{1f1f5}\u{1f1ed}",':flag_pk:'=>"\u{1f1f5}\u{1f1f0}",':flag_pl:'=>"\u{1f1f5}\u{1f1f1}",':flag_pm:'=>"\u{1f1f5}\u{1f1f2}",':flag_pn:'=>"\u{1f1f5}\u{1f1f3}",':flag_pr:'=>"\u{1f1f5}\u{1f1f7}",':flag_ps:'=>"\u{1f1f5}\u{1f1f8}",':flag_pt:'=>"\u{1f1f5}\u{1f1f9}",':flag_pw:'=>"\u{1f1f5}\u{1f1fc}",':flag_py:'=>"\u{1f1f5}\u{1f1fe}",':flag_qa:'=>"\u{1f1f6}\u{1f1e6}",':flag_re:'=>"\u{1f1f7}\u{1f1ea}",':flag_ro:'=>"\u{1f1f7}\u{1f1f4}",':flag_rs:'=>"\u{1f1f7}\u{1f1f8}",':flag_ru:'=>"\u{1f1f7}\u{1f1fa}",':flag_rw:'=>"\u{1f1f7}\u{1f1fc}",':flag_sa:'=>"\u{1f1f8}\u{1f1e6}",':flag_sb:'=>"\u{1f1f8}\u{1f1e7}",':flag_sc:'=>"\u{1f1f8}\u{1f1e8}",':flag_sd:'=>"\u{1f1f8}\u{1f1e9}",':flag_se:'=>"\u{1f1f8}\u{1f1ea}",':flag_sg:'=>"\u{1f1f8}\u{1f1ec}",':flag_sh:'=>"\u{1f1f8}\u{1f1ed}",':flag_si:'=>"\u{1f1f8}\u{1f1ee}",':flag_sj:'=>"\u{1f1f8}\u{1f1ef}",':flag_sk:'=>"\u{1f1f8}\u{1f1f0}",':flag_sl:'=>"\u{1f1f8}\u{1f1f1}",':flag_sm:'=>"\u{1f1f8}\u{1f1f2}",':flag_sn:'=>"\u{1f1f8}\u{1f1f3}",':flag_so:'=>"\u{1f1f8}\u{1f1f4}",':flag_sr:'=>"\u{1f1f8}\u{1f1f7}",':flag_ss:'=>"\u{1f1f8}\u{1f1f8}",':flag_st:'=>"\u{1f1f8}\u{1f1f9}",':flag_sv:'=>"\u{1f1f8}\u{1f1fb}",':flag_sx:'=>"\u{1f1f8}\u{1f1fd}",':flag_sy:'=>"\u{1f1f8}\u{1f1fe}",':flag_sz:'=>"\u{1f1f8}\u{1f1ff}",':flag_ta:'=>"\u{1f1f9}\u{1f1e6}",':flag_tc:'=>"\u{1f1f9}\u{1f1e8}",':flag_td:'=>"\u{1f1f9}\u{1f1e9}",':flag_tf:'=>"\u{1f1f9}\u{1f1eb}",':flag_tg:'=>"\u{1f1f9}\u{1f1ec}",':flag_th:'=>"\u{1f1f9}\u{1f1ed}",':flag_tj:'=>"\u{1f1f9}\u{1f1ef}",':flag_tk:'=>"\u{1f1f9}\u{1f1f0}",':flag_tl:'=>"\u{1f1f9}\u{1f1f1}",':flag_tm:'=>"\u{1f1f9}\u{1f1f2}",':flag_tn:'=>"\u{1f1f9}\u{1f1f3}",':flag_to:'=>"\u{1f1f9}\u{1f1f4}",':flag_tr:'=>"\u{1f1f9}\u{1f1f7}",':flag_tt:'=>"\u{1f1f9}\u{1f1f9}",':flag_tv:'=>"\u{1f1f9}\u{1f1fb}",':flag_tw:'=>"\u{1f1f9}\u{1f1fc}",':flag_tz:'=>"\u{1f1f9}\u{1f1ff}",':flag_ua:'=>"\u{1f1fa}\u{1f1e6}",':flag_ug:'=>"\u{1f1fa}\u{1f1ec}",':flag_um:'=>"\u{1f1fa}\u{1f1f2}",':flag_us:'=>"\u{1f1fa}\u{1f1f8}",':flag_uy:'=>"\u{1f1fa}\u{1f1fe}",':flag_uz:'=>"\u{1f1fa}\u{1f1ff}",':flag_va:'=>"\u{1f1fb}\u{1f1e6}",':flag_vc:'=>"\u{1f1fb}\u{1f1e8}",':flag_ve:'=>"\u{1f1fb}\u{1f1ea}",':flag_vg:'=>"\u{1f1fb}\u{1f1ec}",':flag_vi:'=>"\u{1f1fb}\u{1f1ee}",':flag_vn:'=>"\u{1f1fb}\u{1f1f3}",':flag_vu:'=>"\u{1f1fb}\u{1f1fa}",':flag_wf:'=>"\u{1f1fc}\u{1f1eb}",':flag_white:'=>"\u{1f3f3}\u{fe0f}",':flag_ws:'=>"\u{1f1fc}\u{1f1f8}",':flag_xk:'=>"\u{1f1fd}\u{1f1f0}",':flag_ye:'=>"\u{1f1fe}\u{1f1ea}",':flag_yt:'=>"\u{1f1fe}\u{1f1f9}",':flag_za:'=>"\u{1f1ff}\u{1f1e6}",':flag_zm:'=>"\u{1f1ff}\u{1f1f2}",':flag_zw:'=>"\u{1f1ff}\u{1f1fc}",':flags:'=>"\u{1f38f}",':flashlight:'=>"\u{1f526}",':fleur-de-lis:'=>"\u{269c}\u{fe0f}",':fleur_de_lis:'=>"\u{269c}\u{fe0f}",':flight_arrival:'=>"\u{1f6ec}",':flight_departure:'=>"\u{1f6eb}",':flipper:'=>"\u{1f42c}",':floppy_disk:'=>"\u{1f4be}",':flower_playing_cards:'=>"\u{1f3b4}",':flushed:'=>"\u{1f633}",':flying_saucer:'=>"\u{1f6f8}",':fog:'=>"\u{1f32b}",':foggy:'=>"\u{1f301}",':football:'=>"\u{1f3c8}",':footprints:'=>"\u{1f463}",':fork_and_knife:'=>"\u{1f374}",':fork_knife_plate:'=>"\u{1f37d}\u{fe0f}",':fortune_cookie:'=>"\u{1f960}",':fountain:'=>"\u{26f2}\u{fe0f}",':fountain_pen:'=>"\u{1f58b}",':four:'=>"4\u{20e3}",':four_leaf_clover:'=>"\u{1f340}",':fox:'=>"\u{1f98a}",':fox_face:'=>"\u{1f98a}",':fr:'=>"\u{1f1eb}\u{1f1f7}",':frame_photo:'=>"\u{1f5bc}\u{fe0f}",':framed_picture:'=>"\u{1f5bc}",':free:'=>"\u{1f193}",':french_bread:'=>"\u{1f956}",':french_guiana:'=>"\u{1f1ec}\u{1f1eb}",':french_polynesia:'=>"\u{1f1f5}\u{1f1eb}",':french_southern_territories:'=>"\u{1f1f9}\u{1f1eb}",':fried_egg:'=>"\u{1f373}",':fried_shrimp:'=>"\u{1f364}",':fries:'=>"\u{1f35f}",':frog:'=>"\u{1f438}",':frowning:'=>"\u{1f626}",':frowning2:'=>"\u{2639}\u{fe0f}",':frowning_face:'=>"\u{2639}\u{fe0f}",':frowning_man:'=>"\u{1f64d}\u{200d}\u{2642}\u{fe0f}",':frowning_woman:'=>"\u{1f64d}",':fu:'=>"\u{1f595}",':fuelpump:'=>"\u{26fd}\u{fe0f}",':full_moon:'=>"\u{1f315}",':full_moon_with_face:'=>"\u{1f31d}",':funeral_urn:'=>"\u{26b1}\u{fe0f}",':gabon:'=>"\u{1f1ec}\u{1f1e6}",':gambia:'=>"\u{1f1ec}\u{1f1f2}",':game_die:'=>"\u{1f3b2}",':gb:'=>"\u{1f1ec}\u{1f1e7}",':gear:'=>"\u{2699}\u{fe0f}",':gem:'=>"\u{1f48e}",':gemini:'=>"\u{264a}\u{fe0f}",':genie:'=>"\u{1f9de}",':georgia:'=>"\u{1f1ec}\u{1f1ea}",':ghana:'=>"\u{1f1ec}\u{1f1ed}",':ghost:'=>"\u{1f47b}",':gibraltar:'=>"\u{1f1ec}\u{1f1ee}",':gift:'=>"\u{1f381}",':gift_heart:'=>"\u{1f49d}",':giraffe:'=>"\u{1f992}",':girl:'=>"\u{1f467}",':girl_tone1:'=>"\u{1f467}\u{1f3fb}",':girl_tone2:'=>"\u{1f467}\u{1f3fc}",':girl_tone3:'=>"\u{1f467}\u{1f3fd}",':girl_tone4:'=>"\u{1f467}\u{1f3fe}",':girl_tone5:'=>"\u{1f467}\u{1f3ff}",':globe_with_meridians:'=>"\u{1f310}",':gloves:'=>"\u{1f9e4}",':goal:'=>"\u{1f945}",':goal_net:'=>"\u{1f945}",':goat:'=>"\u{1f410}",':golf:'=>"\u{26f3}\u{fe0f}",':golfing_man:'=>"\u{1f3cc}",':golfing_woman:'=>"\u{1f3cc}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':gorilla:'=>"\u{1f98d}",':grapes:'=>"\u{1f347}",':greece:'=>"\u{1f1ec}\u{1f1f7}",':green_apple:'=>"\u{1f34f}",':green_book:'=>"\u{1f4d7}",':green_heart:'=>"\u{1f49a}",':green_salad:'=>"\u{1f957}",':greenland:'=>"\u{1f1ec}\u{1f1f1}",':grenada:'=>"\u{1f1ec}\u{1f1e9}",':grey_exclamation:'=>"\u{2755}",':grey_question:'=>"\u{2754}",':grimacing:'=>"\u{1f62c}",':grin:'=>"\u{1f601}",':grinning:'=>"\u{1f600}",':guadeloupe:'=>"\u{1f1ec}\u{1f1f5}",':guam:'=>"\u{1f1ec}\u{1f1fa}",':guard:'=>"\u{1f482}\u{1f3ff}",':guard_tone1:'=>"\u{1f482}\u{1f3fb}",':guard_tone2:'=>"\u{1f482}\u{1f3fc}",':guard_tone3:'=>"\u{1f482}\u{1f3fd}",':guard_tone4:'=>"\u{1f482}\u{1f3fe}",':guard_tone5:'=>"\u{1f482}\u{1f3ff}",':guardsman:'=>"\u{1f482}",':guardswoman:'=>"\u{1f482}\u{200d}\u{2640}\u{fe0f}",':guatemala:'=>"\u{1f1ec}\u{1f1f9}",':guernsey:'=>"\u{1f1ec}\u{1f1ec}",':guinea:'=>"\u{1f1ec}\u{1f1f3}",':guinea_bissau:'=>"\u{1f1ec}\u{1f1fc}",':guitar:'=>"\u{1f3b8}",':gun:'=>"\u{1f52b}",':guyana:'=>"\u{1f1ec}\u{1f1fe}",':haircut:'=>"\u{1f487}",':haircut_man:'=>"\u{1f487}\u{200d}\u{2642}\u{fe0f}",':haircut_woman:'=>"\u{1f487}",':haiti:'=>"\u{1f1ed}\u{1f1f9}",':hamburger:'=>"\u{1f354}",':hammer:'=>"\u{1f528}",':hammer_and_pick:'=>"\u{2692}",':hammer_and_wrench:'=>"\u{1f6e0}",':hammer_pick:'=>"\u{2692}\u{fe0f}",':hamster:'=>"\u{1f439}",':hand:'=>"\u{270b}",':hand_splayed:'=>"\u{1f590}\u{fe0f}",':hand_splayed_tone1:'=>"\u{1f590}\u{1f3fb}",':hand_splayed_tone2:'=>"\u{1f590}\u{1f3fc}",':hand_splayed_tone3:'=>"\u{1f590}\u{1f3fd}",':hand_splayed_tone4:'=>"\u{1f590}\u{1f3fe}",':hand_splayed_tone5:'=>"\u{1f590}\u{1f3ff}",':handbag:'=>"\u{1f45c}",':handshake:'=>"\u{1f91d}",':hankey:'=>"\u{1f4a9}",':hash:'=>"#\u{20e3}",':hatched_chick:'=>"\u{1f425}",':hatching_chick:'=>"\u{1f423}",':head_bandage:'=>"\u{1f915}",':headphones:'=>"\u{1f3a7}",':hear_no_evil:'=>"\u{1f649}",':heart:'=>"\u{2764}\u{fe0f}",':heart_decoration:'=>"\u{1f49f}",':heart_exclamation:'=>"\u{2763}\u{fe0f}",':heart_eyes:'=>"\u{1f60d}",':heart_eyes_cat:'=>"\u{1f63b}",':heartbeat:'=>"\u{1f493}",':heartpulse:'=>"\u{1f497}",':hearts:'=>"\u{2665}\u{fe0f}",':heavy_check_mark:'=>"\u{2714}\u{fe0f}",':heavy_division_sign:'=>"\u{2797}",':heavy_dollar_sign:'=>"\u{1f4b2}",':heavy_exclamation_mark:'=>"\u{2757}\u{fe0f}",':heavy_heart_exclamation:'=>"\u{2763}\u{fe0f}",':heavy_minus_sign:'=>"\u{2796}",':heavy_multiplication_x:'=>"\u{2716}\u{fe0f}",':heavy_plus_sign:'=>"\u{2795}",':hedgehog:'=>"\u{1f994}",':helicopter:'=>"\u{1f681}",':helmet_with_cross:'=>"\u{26d1}\u{fe0f}",':herb:'=>"\u{1f33f}",':hibiscus:'=>"\u{1f33a}",':high_brightness:'=>"\u{1f506}",':high_heel:'=>"\u{1f460}",':hocho:'=>"\u{1f52a}",':hockey:'=>"\u{1f3d2}",':hole:'=>"\u{1f573}",':homes:'=>"\u{1f3d8}\u{fe0f}",':honduras:'=>"\u{1f1ed}\u{1f1f3}",':honey_pot:'=>"\u{1f36f}",':honeybee:'=>"\u{1f41d}",':hong_kong:'=>"\u{1f1ed}\u{1f1f0}",':horse:'=>"\u{1f434}",':horse_racing:'=>"\u{1f3c7}",':horse_racing_tone1:'=>"\u{1f3c7}\u{1f3fb}",':horse_racing_tone2:'=>"\u{1f3c7}\u{1f3fc}",':horse_racing_tone3:'=>"\u{1f3c7}\u{1f3fd}",':horse_racing_tone4:'=>"\u{1f3c7}\u{1f3fe}",':horse_racing_tone5:'=>"\u{1f3c7}\u{1f3ff}",':hospital:'=>"\u{1f3e5}",':hot_pepper:'=>"\u{1f336}",':hotdog:'=>"\u{1f32d}",':hotel:'=>"\u{1f3e8}",':hotsprings:'=>"\u{2668}\u{fe0f}",':hourglass:'=>"\u{231b}\u{fe0f}",':hourglass_flowing_sand:'=>"\u{23f3}",':house:'=>"\u{1f3e0}",':house_abandoned:'=>"\u{1f3da}\u{fe0f}",':house_with_garden:'=>"\u{1f3e1}",':houses:'=>"\u{1f3d8}",':hugging:'=>"\u{1f917}",':hugs:'=>"\u{1f917}",':hungary:'=>"\u{1f1ed}\u{1f1fa}",':hushed:'=>"\u{1f62f}",':ice_cream:'=>"\u{1f368}",':ice_hockey:'=>"\u{1f3d2}",':ice_skate:'=>"\u{26f8}",':icecream:'=>"\u{1f366}",':iceland:'=>"\u{1f1ee}\u{1f1f8}",':id:'=>"\u{1f194}",':ideograph_advantage:'=>"\u{1f250}",':imp:'=>"\u{1f47f}",':inbox_tray:'=>"\u{1f4e5}",':incoming_envelope:'=>"\u{1f4e8}",':india:'=>"\u{1f1ee}\u{1f1f3}",':indonesia:'=>"\u{1f1ee}\u{1f1e9}",':information_desk_person:'=>"\u{1f481}",':information_source:'=>"\u{2139}\u{fe0f}",':innocent:'=>"\u{1f607}",':interrobang:'=>"\u{2049}\u{fe0f}",':iphone:'=>"\u{1f4f1}",':iran:'=>"\u{1f1ee}\u{1f1f7}",':iraq:'=>"\u{1f1ee}\u{1f1f6}",':ireland:'=>"\u{1f1ee}\u{1f1ea}",':island:'=>"\u{1f3dd}\u{fe0f}",':isle_of_man:'=>"\u{1f1ee}\u{1f1f2}",':israel:'=>"\u{1f1ee}\u{1f1f1}",':it:'=>"\u{1f1ee}\u{1f1f9}",':izakaya_lantern:'=>"\u{1f3ee}",':jack_o_lantern:'=>"\u{1f383}",':jamaica:'=>"\u{1f1ef}\u{1f1f2}",':japan:'=>"\u{1f5fe}",':japanese_castle:'=>"\u{1f3ef}",':japanese_goblin:'=>"\u{1f47a}",':japanese_ogre:'=>"\u{1f479}",':jeans:'=>"\u{1f456}",':jersey:'=>"\u{1f1ef}\u{1f1ea}",':jordan:'=>"\u{1f1ef}\u{1f1f4}",':joy:'=>"\u{1f602}",':joy_cat:'=>"\u{1f639}",':joystick:'=>"\u{1f579}",':jp:'=>"\u{1f1ef}\u{1f1f5}",':kaaba:'=>"\u{1f54b}",':kazakhstan:'=>"\u{1f1f0}\u{1f1ff}",':kenya:'=>"\u{1f1f0}\u{1f1ea}",':key:'=>"\u{1f511}",':key2:'=>"\u{1f5dd}\u{fe0f}",':keyboard:'=>"\u{2328}\u{fe0f}",':keycap_ten:'=>"\u{1f51f}",':kick_scooter:'=>"\u{1f6f4}",':kimono:'=>"\u{1f458}",':kiribati:'=>"\u{1f1f0}\u{1f1ee}",':kiss:'=>"\u{1f48b}",':kiss_mm:'=>"\u{1f468}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f48b}\u{200d}\u{1f468}",':kiss_woman_man:'=>"\u{1f469}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f48b}\u{200d}\u{1f468}",':kiss_ww:'=>"\u{1f469}\u{200d}\u{2764}\u{fe0f}\u{200d}\u{1f48b}\u{200d}\u{1f469}",':kissing:'=>"\u{1f617}",':kissing_cat:'=>"\u{1f63d}",':kissing_closed_eyes:'=>"\u{1f61a}",':kissing_heart:'=>"\u{1f618}",':kissing_smiling_eyes:'=>"\u{1f619}",':kiwi:'=>"\u{1f95d}",':kiwi_fruit:'=>"\u{1f95d}",':knife:'=>"\u{1f52a}",':koala:'=>"\u{1f428}",':koko:'=>"\u{1f201}",':kosovo:'=>"\u{1f1fd}\u{1f1f0}",':kr:'=>"\u{1f1f0}\u{1f1f7}",':kuwait:'=>"\u{1f1f0}\u{1f1fc}",':kyrgyzstan:'=>"\u{1f1f0}\u{1f1ec}",':label:'=>"\u{1f3f7}",':lantern:'=>"\u{1f3ee}",':laos:'=>"\u{1f1f1}\u{1f1e6}",':large_blue_circle:'=>"\u{1f535}",':large_blue_diamond:'=>"\u{1f537}",':large_orange_diamond:'=>"\u{1f536}",':last_quarter_moon:'=>"\u{1f317}",':last_quarter_moon_with_face:'=>"\u{1f31c}",':latin_cross:'=>"\u{271d}\u{fe0f}",':latvia:'=>"\u{1f1f1}\u{1f1fb}",':laughing:'=>"\u{1f606}",':leaves:'=>"\u{1f343}",':lebanon:'=>"\u{1f1f1}\u{1f1e7}",':ledger:'=>"\u{1f4d2}",':left_facing_fist:'=>"\u{1f91b}",':left_facing_fist_tone1:'=>"\u{1f91b}\u{1f3fb}",':left_facing_fist_tone2:'=>"\u{1f91b}\u{1f3fc}",':left_facing_fist_tone3:'=>"\u{1f91b}\u{1f3fd}",':left_facing_fist_tone4:'=>"\u{1f91b}\u{1f3fe}",':left_facing_fist_tone5:'=>"\u{1f91b}\u{1f3ff}",':left_luggage:'=>"\u{1f6c5}",':left_right_arrow:'=>"\u{2194}\u{fe0f}",':leftwards_arrow_with_hook:'=>"\u{21a9}\u{fe0f}",':lemon:'=>"\u{1f34b}",':leo:'=>"\u{264c}\u{fe0f}",':leopard:'=>"\u{1f406}",':lesotho:'=>"\u{1f1f1}\u{1f1f8}",':level_slider:'=>"\u{1f39a}",':levitate:'=>"\u{1f574}",':liberia:'=>"\u{1f1f1}\u{1f1f7}",':libra:'=>"\u{264e}\u{fe0f}",':libya:'=>"\u{1f1f1}\u{1f1fe}",':liechtenstein:'=>"\u{1f1f1}\u{1f1ee}",':light_rail:'=>"\u{1f688}",':link:'=>"\u{1f517}",':lion:'=>"\u{1f981}",':lion_face:'=>"\u{1f981}",':lips:'=>"\u{1f444}",':lipstick:'=>"\u{1f484}",':lithuania:'=>"\u{1f1f1}\u{1f1f9}",':lizard:'=>"\u{1f98e}",':lock:'=>"\u{1f512}",':lock_with_ink_pen:'=>"\u{1f50f}",':lollipop:'=>"\u{1f36d}",':loop:'=>"\u{27bf}",':loud_sound:'=>"\u{1f50a}",':loudspeaker:'=>"\u{1f4e2}",':love_hotel:'=>"\u{1f3e9}",':love_letter:'=>"\u{1f48c}",':love_you_gesture:'=>"\u{1f91f}",':love_you_gesture_tone1:'=>"\u{1f91f}\u{1f3fb}",':love_you_gesture_tone2:'=>"\u{1f91f}\u{1f3fc}",':love_you_gesture_tone3:'=>"\u{1f91f}\u{1f3fd}",':love_you_gesture_tone4:'=>"\u{1f91f}\u{1f3fe}",':love_you_gesture_tone5:'=>"\u{1f91f}\u{1f3ff}",':low_brightness:'=>"\u{1f505}",':luxembourg:'=>"\u{1f1f1}\u{1f1fa}",':lying_face:'=>"\u{1f925}",':m:'=>"\u{24c2}\u{fe0f}",':macau:'=>"\u{1f1f2}\u{1f1f4}",':macedonia:'=>"\u{1f1f2}\u{1f1f0}",':madagascar:'=>"\u{1f1f2}\u{1f1ec}",':mag:'=>"\u{1f50d}",':mag_right:'=>"\u{1f50e}",':mage:'=>"\u{1f9d9}\u{1f3ff}",':mage_tone1:'=>"\u{1f9d9}\u{1f3fb}",':mage_tone2:'=>"\u{1f9d9}\u{1f3fc}",':mage_tone3:'=>"\u{1f9d9}\u{1f3fd}",':mage_tone4:'=>"\u{1f9d9}\u{1f3fe}",':mage_tone5:'=>"\u{1f9d9}\u{1f3ff}",':mahjong:'=>"\u{1f004}\u{fe0f}",':mailbox:'=>"\u{1f4eb}",':mailbox_closed:'=>"\u{1f4ea}",':mailbox_with_mail:'=>"\u{1f4ec}",':mailbox_with_no_mail:'=>"\u{1f4ed}",':malawi:'=>"\u{1f1f2}\u{1f1fc}",':malaysia:'=>"\u{1f1f2}\u{1f1fe}",':maldives:'=>"\u{1f1f2}\u{1f1fb}",':male_detective:'=>"\u{1f575}",':male_sign:'=>"\u{2642}\u{fe0f}",':mali:'=>"\u{1f1f2}\u{1f1f1}",':malta:'=>"\u{1f1f2}\u{1f1f9}",':man:'=>"\u{1f468}",':man_artist:'=>"\u{1f468}\u{200d}\u{1f3a8}",':man_artist_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f3a8}",':man_artist_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f3a8}",':man_artist_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f3a8}",':man_artist_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f3a8}",':man_artist_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f3a8}",':man_astronaut:'=>"\u{1f468}\u{200d}\u{1f680}",':man_astronaut_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f680}",':man_astronaut_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f680}",':man_astronaut_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f680}",':man_astronaut_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f680}",':man_astronaut_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f680}",':man_biking:'=>"\u{1f6b4}\u{200d}\u{2642}\u{fe0f}",':man_biking_tone1:'=>"\u{1f6b4}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_biking_tone2:'=>"\u{1f6b4}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_biking_tone3:'=>"\u{1f6b4}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_biking_tone4:'=>"\u{1f6b4}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_biking_tone5:'=>"\u{1f6b4}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball:'=>"\u{26f9}\u{fe0f}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball_tone1:'=>"\u{26f9}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball_tone2:'=>"\u{26f9}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball_tone3:'=>"\u{26f9}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball_tone4:'=>"\u{26f9}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_bouncing_ball_tone5:'=>"\u{26f9}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_bowing:'=>"\u{1f647}\u{200d}\u{2642}\u{fe0f}",':man_bowing_tone1:'=>"\u{1f647}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_bowing_tone2:'=>"\u{1f647}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_bowing_tone3:'=>"\u{1f647}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_bowing_tone4:'=>"\u{1f647}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_bowing_tone5:'=>"\u{1f647}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling:'=>"\u{1f938}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling_tone1:'=>"\u{1f938}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling_tone2:'=>"\u{1f938}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling_tone3:'=>"\u{1f938}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling_tone4:'=>"\u{1f938}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_cartwheeling_tone5:'=>"\u{1f938}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_climbing:'=>"\u{1f9d7}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_climbing_tone1:'=>"\u{1f9d7}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_climbing_tone2:'=>"\u{1f9d7}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_climbing_tone3:'=>"\u{1f9d7}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_climbing_tone4:'=>"\u{1f9d7}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_climbing_tone5:'=>"\u{1f9d7}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker:'=>"\u{1f477}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker_tone1:'=>"\u{1f477}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker_tone2:'=>"\u{1f477}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker_tone3:'=>"\u{1f477}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker_tone4:'=>"\u{1f477}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_construction_worker_tone5:'=>"\u{1f477}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_cook:'=>"\u{1f468}\u{200d}\u{1f373}",':man_cook_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f373}",':man_cook_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f373}",':man_cook_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f373}",':man_cook_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f373}",':man_cook_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f373}",':man_dancing:'=>"\u{1f57a}",':man_dancing_tone1:'=>"\u{1f57a}\u{1f3fb}",':man_dancing_tone2:'=>"\u{1f57a}\u{1f3fc}",':man_dancing_tone3:'=>"\u{1f57a}\u{1f3fd}",':man_dancing_tone4:'=>"\u{1f57a}\u{1f3fe}",':man_dancing_tone5:'=>"\u{1f57a}\u{1f3ff}",':man_detective:'=>"\u{1f575}\u{fe0f}\u{200d}\u{2642}\u{fe0f}",':man_detective_tone1:'=>"\u{1f575}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_detective_tone2:'=>"\u{1f575}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_detective_tone3:'=>"\u{1f575}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_detective_tone4:'=>"\u{1f575}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_detective_tone5:'=>"\u{1f575}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_elf:'=>"\u{1f9dd}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_elf_tone1:'=>"\u{1f9dd}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_elf_tone2:'=>"\u{1f9dd}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_elf_tone3:'=>"\u{1f9dd}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_elf_tone4:'=>"\u{1f9dd}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_elf_tone5:'=>"\u{1f9dd}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_facepalming:'=>"\u{1f926}\u{200d}\u{2642}\u{fe0f}",':man_facepalming_tone1:'=>"\u{1f926}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_facepalming_tone2:'=>"\u{1f926}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_facepalming_tone3:'=>"\u{1f926}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_facepalming_tone4:'=>"\u{1f926}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_facepalming_tone5:'=>"\u{1f926}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_factory_worker:'=>"\u{1f468}\u{200d}\u{1f3ed}",':man_factory_worker_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f3ed}",':man_factory_worker_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f3ed}",':man_factory_worker_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f3ed}",':man_factory_worker_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f3ed}",':man_factory_worker_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f3ed}",':man_fairy:'=>"\u{1f9da}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_fairy_tone1:'=>"\u{1f9da}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_fairy_tone2:'=>"\u{1f9da}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_fairy_tone3:'=>"\u{1f9da}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_fairy_tone4:'=>"\u{1f9da}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_fairy_tone5:'=>"\u{1f9da}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_farmer:'=>"\u{1f468}\u{200d}\u{1f33e}",':man_farmer_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f33e}",':man_farmer_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f33e}",':man_farmer_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f33e}",':man_farmer_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f33e}",':man_farmer_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f33e}",':man_firefighter:'=>"\u{1f468}\u{200d}\u{1f692}",':man_firefighter_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f692}",':man_firefighter_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f692}",':man_firefighter_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f692}",':man_firefighter_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f692}",':man_firefighter_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f692}",':man_frowning:'=>"\u{1f64d}\u{200d}\u{2642}\u{fe0f}",':man_frowning_tone1:'=>"\u{1f64d}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_frowning_tone2:'=>"\u{1f64d}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_frowning_tone3:'=>"\u{1f64d}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_frowning_tone4:'=>"\u{1f64d}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_frowning_tone5:'=>"\u{1f64d}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_genie:'=>"\u{1f9de}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no:'=>"\u{1f645}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no_tone1:'=>"\u{1f645}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no_tone2:'=>"\u{1f645}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no_tone3:'=>"\u{1f645}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no_tone4:'=>"\u{1f645}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_no_tone5:'=>"\u{1f645}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok:'=>"\u{1f646}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok_tone1:'=>"\u{1f646}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok_tone2:'=>"\u{1f646}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok_tone3:'=>"\u{1f646}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok_tone4:'=>"\u{1f646}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_gesturing_ok_tone5:'=>"\u{1f646}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage:'=>"\u{1f486}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage_tone1:'=>"\u{1f486}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage_tone2:'=>"\u{1f486}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage_tone3:'=>"\u{1f486}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage_tone4:'=>"\u{1f486}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_getting_face_massage_tone5:'=>"\u{1f486}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut:'=>"\u{1f487}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut_tone1:'=>"\u{1f487}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut_tone2:'=>"\u{1f487}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut_tone3:'=>"\u{1f487}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut_tone4:'=>"\u{1f487}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_getting_haircut_tone5:'=>"\u{1f487}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_golfing:'=>"\u{1f3cc}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_golfing_tone1:'=>"\u{1f3cc}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_golfing_tone2:'=>"\u{1f3cc}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_golfing_tone3:'=>"\u{1f3cc}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_golfing_tone4:'=>"\u{1f3cc}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_golfing_tone5:'=>"\u{1f3cc}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_guard:'=>"\u{1f482}\u{200d}\u{2642}\u{fe0f}",':man_guard_tone1:'=>"\u{1f482}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_guard_tone2:'=>"\u{1f482}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_guard_tone3:'=>"\u{1f482}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_guard_tone4:'=>"\u{1f482}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_guard_tone5:'=>"\u{1f482}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_health_worker:'=>"\u{1f468}\u{200d}\u{2695}\u{fe0f}",':man_health_worker_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{2695}\u{fe0f}",':man_health_worker_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{2695}\u{fe0f}",':man_health_worker_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{2695}\u{fe0f}",':man_health_worker_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{2695}\u{fe0f}",':man_health_worker_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{2695}\u{fe0f}",':man_in_business_suit_levitating_tone1:'=>"\u{1f574}\u{1f3fb}",':man_in_business_suit_levitating_tone2:'=>"\u{1f574}\u{1f3fc}",':man_in_business_suit_levitating_tone3:'=>"\u{1f574}\u{1f3fd}",':man_in_business_suit_levitating_tone4:'=>"\u{1f574}\u{1f3fe}",':man_in_business_suit_levitating_tone5:'=>"\u{1f574}\u{1f3ff}",':man_in_lotus_position:'=>"\u{1f9d8}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_in_lotus_position_tone1:'=>"\u{1f9d8}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_in_lotus_position_tone2:'=>"\u{1f9d8}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_in_lotus_position_tone3:'=>"\u{1f9d8}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_in_lotus_position_tone4:'=>"\u{1f9d8}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_in_lotus_position_tone5:'=>"\u{1f9d8}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room:'=>"\u{1f9d6}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room_tone1:'=>"\u{1f9d6}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room_tone2:'=>"\u{1f9d6}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room_tone3:'=>"\u{1f9d6}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room_tone4:'=>"\u{1f9d6}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_in_steamy_room_tone5:'=>"\u{1f9d6}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_in_tuxedo:'=>"\u{1f935}",':man_in_tuxedo_tone1:'=>"\u{1f935}\u{1f3fb}",':man_in_tuxedo_tone2:'=>"\u{1f935}\u{1f3fc}",':man_in_tuxedo_tone3:'=>"\u{1f935}\u{1f3fd}",':man_in_tuxedo_tone4:'=>"\u{1f935}\u{1f3fe}",':man_in_tuxedo_tone5:'=>"\u{1f935}\u{1f3ff}",':man_judge:'=>"\u{1f468}\u{200d}\u{2696}\u{fe0f}",':man_judge_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{2696}\u{fe0f}",':man_judge_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{2696}\u{fe0f}",':man_judge_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{2696}\u{fe0f}",':man_judge_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{2696}\u{fe0f}",':man_judge_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{2696}\u{fe0f}",':man_juggling:'=>"\u{1f939}\u{200d}\u{2642}\u{fe0f}",':man_juggling_tone1:'=>"\u{1f939}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_juggling_tone2:'=>"\u{1f939}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_juggling_tone3:'=>"\u{1f939}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_juggling_tone4:'=>"\u{1f939}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_juggling_tone5:'=>"\u{1f939}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights:'=>"\u{1f3cb}\u{fe0f}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights_tone1:'=>"\u{1f3cb}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights_tone2:'=>"\u{1f3cb}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights_tone3:'=>"\u{1f3cb}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights_tone4:'=>"\u{1f3cb}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_lifting_weights_tone5:'=>"\u{1f3cb}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_mage:'=>"\u{1f9d9}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_mage_tone1:'=>"\u{1f9d9}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_mage_tone2:'=>"\u{1f9d9}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_mage_tone3:'=>"\u{1f9d9}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_mage_tone4:'=>"\u{1f9d9}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_mage_tone5:'=>"\u{1f9d9}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_mechanic:'=>"\u{1f468}\u{200d}\u{1f527}",':man_mechanic_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f527}",':man_mechanic_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f527}",':man_mechanic_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f527}",':man_mechanic_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f527}",':man_mechanic_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f527}",':man_mountain_biking:'=>"\u{1f6b5}\u{200d}\u{2642}\u{fe0f}",':man_mountain_biking_tone1:'=>"\u{1f6b5}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_mountain_biking_tone2:'=>"\u{1f6b5}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_mountain_biking_tone3:'=>"\u{1f6b5}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_mountain_biking_tone4:'=>"\u{1f6b5}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_mountain_biking_tone5:'=>"\u{1f6b5}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_office_worker:'=>"\u{1f468}\u{200d}\u{1f4bc}",':man_office_worker_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f4bc}",':man_office_worker_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f4bc}",':man_office_worker_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f4bc}",':man_office_worker_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f4bc}",':man_office_worker_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f4bc}",':man_pilot:'=>"\u{1f468}\u{200d}\u{2708}\u{fe0f}",':man_pilot_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{2708}\u{fe0f}",':man_pilot_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{2708}\u{fe0f}",':man_pilot_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{2708}\u{fe0f}",':man_pilot_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{2708}\u{fe0f}",':man_pilot_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{2708}\u{fe0f}",':man_playing_handball:'=>"\u{1f93e}\u{200d}\u{2642}\u{fe0f}",':man_playing_handball_tone1:'=>"\u{1f93e}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_playing_handball_tone2:'=>"\u{1f93e}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_playing_handball_tone3:'=>"\u{1f93e}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_playing_handball_tone4:'=>"\u{1f93e}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_playing_handball_tone5:'=>"\u{1f93e}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo:'=>"\u{1f93d}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo_tone1:'=>"\u{1f93d}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo_tone2:'=>"\u{1f93d}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo_tone3:'=>"\u{1f93d}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo_tone4:'=>"\u{1f93d}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_playing_water_polo_tone5:'=>"\u{1f93d}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_police_officer:'=>"\u{1f46e}\u{200d}\u{2642}\u{fe0f}",':man_police_officer_tone1:'=>"\u{1f46e}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_police_officer_tone2:'=>"\u{1f46e}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_police_officer_tone3:'=>"\u{1f46e}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_police_officer_tone4:'=>"\u{1f46e}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_police_officer_tone5:'=>"\u{1f46e}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_pouting:'=>"\u{1f64e}\u{200d}\u{2642}\u{fe0f}",':man_pouting_tone1:'=>"\u{1f64e}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_pouting_tone2:'=>"\u{1f64e}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_pouting_tone3:'=>"\u{1f64e}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_pouting_tone4:'=>"\u{1f64e}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_pouting_tone5:'=>"\u{1f64e}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand:'=>"\u{1f64b}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand_tone1:'=>"\u{1f64b}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand_tone2:'=>"\u{1f64b}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand_tone3:'=>"\u{1f64b}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand_tone4:'=>"\u{1f64b}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_raising_hand_tone5:'=>"\u{1f64b}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat:'=>"\u{1f6a3}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat_tone1:'=>"\u{1f6a3}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat_tone2:'=>"\u{1f6a3}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat_tone3:'=>"\u{1f6a3}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat_tone4:'=>"\u{1f6a3}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_rowing_boat_tone5:'=>"\u{1f6a3}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_running:'=>"\u{1f3c3}\u{200d}\u{2642}\u{fe0f}",':man_running_tone1:'=>"\u{1f3c3}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_running_tone2:'=>"\u{1f3c3}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_running_tone3:'=>"\u{1f3c3}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_running_tone4:'=>"\u{1f3c3}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_running_tone5:'=>"\u{1f3c3}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_scientist:'=>"\u{1f468}\u{200d}\u{1f52c}",':man_scientist_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f52c}",':man_scientist_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f52c}",':man_scientist_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f52c}",':man_scientist_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f52c}",':man_scientist_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f52c}",':man_shrugging:'=>"\u{1f937}\u{200d}\u{2642}\u{fe0f}",':man_shrugging_tone1:'=>"\u{1f937}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_shrugging_tone2:'=>"\u{1f937}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_shrugging_tone3:'=>"\u{1f937}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_shrugging_tone4:'=>"\u{1f937}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_shrugging_tone5:'=>"\u{1f937}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_singer:'=>"\u{1f468}\u{200d}\u{1f3a4}",':man_singer_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f3a4}",':man_singer_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f3a4}",':man_singer_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f3a4}",':man_singer_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f3a4}",':man_singer_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f3a4}",':man_student:'=>"\u{1f468}\u{200d}\u{1f393}",':man_student_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f393}",':man_student_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f393}",':man_student_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f393}",':man_student_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f393}",':man_student_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f393}",':man_surfing:'=>"\u{1f3c4}\u{200d}\u{2642}\u{fe0f}",':man_surfing_tone1:'=>"\u{1f3c4}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_surfing_tone2:'=>"\u{1f3c4}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_surfing_tone3:'=>"\u{1f3c4}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_surfing_tone4:'=>"\u{1f3c4}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_surfing_tone5:'=>"\u{1f3c4}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_swimming:'=>"\u{1f3ca}\u{200d}\u{2642}\u{fe0f}",':man_swimming_tone1:'=>"\u{1f3ca}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_swimming_tone2:'=>"\u{1f3ca}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_swimming_tone3:'=>"\u{1f3ca}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_swimming_tone4:'=>"\u{1f3ca}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_swimming_tone5:'=>"\u{1f3ca}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_teacher:'=>"\u{1f468}\u{200d}\u{1f3eb}",':man_teacher_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f3eb}",':man_teacher_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f3eb}",':man_teacher_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f3eb}",':man_teacher_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f3eb}",':man_teacher_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f3eb}",':man_technologist:'=>"\u{1f468}\u{200d}\u{1f4bb}",':man_technologist_tone1:'=>"\u{1f468}\u{1f3fb}\u{200d}\u{1f4bb}",':man_technologist_tone2:'=>"\u{1f468}\u{1f3fc}\u{200d}\u{1f4bb}",':man_technologist_tone3:'=>"\u{1f468}\u{1f3fd}\u{200d}\u{1f4bb}",':man_technologist_tone4:'=>"\u{1f468}\u{1f3fe}\u{200d}\u{1f4bb}",':man_technologist_tone5:'=>"\u{1f468}\u{1f3ff}\u{200d}\u{1f4bb}",':man_tipping_hand:'=>"\u{1f481}\u{200d}\u{2642}\u{fe0f}",':man_tipping_hand_tone1:'=>"\u{1f481}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_tipping_hand_tone2:'=>"\u{1f481}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_tipping_hand_tone3:'=>"\u{1f481}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_tipping_hand_tone4:'=>"\u{1f481}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_tipping_hand_tone5:'=>"\u{1f481}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_tone1:'=>"\u{1f468}\u{1f3fb}",':man_tone2:'=>"\u{1f468}\u{1f3fc}",':man_tone3:'=>"\u{1f468}\u{1f3fd}",':man_tone4:'=>"\u{1f468}\u{1f3fe}",':man_tone5:'=>"\u{1f468}\u{1f3ff}",':man_vampire:'=>"\u{1f9db}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_vampire_tone1:'=>"\u{1f9db}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_vampire_tone2:'=>"\u{1f9db}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_vampire_tone3:'=>"\u{1f9db}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_vampire_tone4:'=>"\u{1f9db}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_vampire_tone5:'=>"\u{1f9db}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_walking:'=>"\u{1f6b6}\u{200d}\u{2642}\u{fe0f}",':man_walking_tone1:'=>"\u{1f6b6}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_walking_tone2:'=>"\u{1f6b6}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_walking_tone3:'=>"\u{1f6b6}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_walking_tone4:'=>"\u{1f6b6}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_walking_tone5:'=>"\u{1f6b6}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban:'=>"\u{1f473}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban_tone1:'=>"\u{1f473}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban_tone2:'=>"\u{1f473}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban_tone3:'=>"\u{1f473}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban_tone4:'=>"\u{1f473}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':man_wearing_turban_tone5:'=>"\u{1f473}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':man_with_chinese_cap:'=>"\u{1f472}",':man_with_chinese_cap_tone1:'=>"\u{1f472}\u{1f3fb}",':man_with_chinese_cap_tone2:'=>"\u{1f472}\u{1f3fc}",':man_with_chinese_cap_tone3:'=>"\u{1f472}\u{1f3fd}",':man_with_chinese_cap_tone4:'=>"\u{1f472}\u{1f3fe}",':man_with_chinese_cap_tone5:'=>"\u{1f472}\u{1f3ff}",':man_with_gua_pi_mao:'=>"\u{1f472}",':man_with_turban:'=>"\u{1f473}",':man_zombie:'=>"\u{1f9df}\u{200d}\u{2642}\u{fe0f}",':mandarin:'=>"\u{1f34a}",':mans_shoe:'=>"\u{1f45e}",':mantelpiece_clock:'=>"\u{1f570}",':map:'=>"\u{1f5fa}\u{fe0f}",':maple_leaf:'=>"\u{1f341}",':marshall_islands:'=>"\u{1f1f2}\u{1f1ed}",':martial_arts_uniform:'=>"\u{1f94b}",':martinique:'=>"\u{1f1f2}\u{1f1f6}",':mask:'=>"\u{1f637}",':massage:'=>"\u{1f486}",':massage_man:'=>"\u{1f486}\u{200d}\u{2642}\u{fe0f}",':massage_woman:'=>"\u{1f486}",':mauritania:'=>"\u{1f1f2}\u{1f1f7}",':mauritius:'=>"\u{1f1f2}\u{1f1fa}",':mayotte:'=>"\u{1f1fe}\u{1f1f9}",':meat_on_bone:'=>"\u{1f356}",':medal:'=>"\u{1f3c5}",':medal_military:'=>"\u{1f396}",':medal_sports:'=>"\u{1f3c5}",':medical_symbol:'=>"\u{2695}\u{fe0f}",':mega:'=>"\u{1f4e3}",':melon:'=>"\u{1f348}",':memo:'=>"\u{1f4dd}",':men_with_bunny_ears_partying:'=>"\u{1f46f}\u{200d}\u{2642}\u{fe0f}",':men_wrestling:'=>"\u{1f93c}\u{200d}\u{2642}\u{fe0f}",':menorah:'=>"\u{1f54e}",':mens:'=>"\u{1f6b9}",':mermaid:'=>"\u{1f9dc}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':mermaid_tone1:'=>"\u{1f9dc}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':mermaid_tone2:'=>"\u{1f9dc}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':mermaid_tone3:'=>"\u{1f9dc}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':mermaid_tone4:'=>"\u{1f9dc}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':mermaid_tone5:'=>"\u{1f9dc}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':merman:'=>"\u{1f9dc}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':merman_tone1:'=>"\u{1f9dc}\u{1f3fb}\u{200d}\u{2642}\u{fe0f}",':merman_tone2:'=>"\u{1f9dc}\u{1f3fc}\u{200d}\u{2642}\u{fe0f}",':merman_tone3:'=>"\u{1f9dc}\u{1f3fd}\u{200d}\u{2642}\u{fe0f}",':merman_tone4:'=>"\u{1f9dc}\u{1f3fe}\u{200d}\u{2642}\u{fe0f}",':merman_tone5:'=>"\u{1f9dc}\u{1f3ff}\u{200d}\u{2642}\u{fe0f}",':merperson:'=>"\u{1f9dc}\u{1f3ff}",':merperson_tone1:'=>"\u{1f9dc}\u{1f3fb}",':merperson_tone2:'=>"\u{1f9dc}\u{1f3fc}",':merperson_tone3:'=>"\u{1f9dc}\u{1f3fd}",':merperson_tone4:'=>"\u{1f9dc}\u{1f3fe}",':merperson_tone5:'=>"\u{1f9dc}\u{1f3ff}",':metal:'=>"\u{1f918}",':metal_tone1:'=>"\u{1f918}\u{1f3fb}",':metal_tone2:'=>"\u{1f918}\u{1f3fc}",':metal_tone3:'=>"\u{1f918}\u{1f3fd}",':metal_tone4:'=>"\u{1f918}\u{1f3fe}",':metal_tone5:'=>"\u{1f918}\u{1f3ff}",':metro:'=>"\u{1f687}",':mexico:'=>"\u{1f1f2}\u{1f1fd}",':micronesia:'=>"\u{1f1eb}\u{1f1f2}",':microphone:'=>"\u{1f3a4}",':microphone2:'=>"\u{1f399}\u{fe0f}",':microscope:'=>"\u{1f52c}",':middle_finger:'=>"\u{1f595}",':middle_finger_tone1:'=>"\u{1f595}\u{1f3fb}",':middle_finger_tone2:'=>"\u{1f595}\u{1f3fc}",':middle_finger_tone3:'=>"\u{1f595}\u{1f3fd}",':middle_finger_tone4:'=>"\u{1f595}\u{1f3fe}",':middle_finger_tone5:'=>"\u{1f595}\u{1f3ff}",':military_medal:'=>"\u{1f396}\u{fe0f}",':milk:'=>"\u{1f95b}",':milk_glass:'=>"\u{1f95b}",':milky_way:'=>"\u{1f30c}",':minibus:'=>"\u{1f690}",':minidisc:'=>"\u{1f4bd}",':mobile_phone_off:'=>"\u{1f4f4}",':moldova:'=>"\u{1f1f2}\u{1f1e9}",':monaco:'=>"\u{1f1f2}\u{1f1e8}",':money_mouth:'=>"\u{1f911}",':money_mouth_face:'=>"\u{1f911}",':money_with_wings:'=>"\u{1f4b8}",':moneybag:'=>"\u{1f4b0}",':mongolia:'=>"\u{1f1f2}\u{1f1f3}",':monkey:'=>"\u{1f412}",':monkey_face:'=>"\u{1f435}",':monorail:'=>"\u{1f69d}",':montenegro:'=>"\u{1f1f2}\u{1f1ea}",':montserrat:'=>"\u{1f1f2}\u{1f1f8}",':moon:'=>"\u{1f314}",':morocco:'=>"\u{1f1f2}\u{1f1e6}",':mortar_board:'=>"\u{1f393}",':mosque:'=>"\u{1f54c}",':motor_boat:'=>"\u{1f6e5}",':motor_scooter:'=>"\u{1f6f5}",':motorboat:'=>"\u{1f6e5}\u{fe0f}",':motorcycle:'=>"\u{1f3cd}",':motorway:'=>"\u{1f6e3}",':mount_fuji:'=>"\u{1f5fb}",':mountain:'=>"\u{26f0}",':mountain_bicyclist:'=>"\u{1f6b5}",':mountain_biking_man:'=>"\u{1f6b5}",':mountain_biking_woman:'=>"\u{1f6b5}\u{200d}\u{2640}\u{fe0f}",':mountain_cableway:'=>"\u{1f6a0}",':mountain_railway:'=>"\u{1f69e}",':mountain_snow:'=>"\u{1f3d4}",':mouse:'=>"\u{1f42d}",':mouse2:'=>"\u{1f401}",':mouse_three_button:'=>"\u{1f5b1}\u{fe0f}",':movie_camera:'=>"\u{1f3a5}",':moyai:'=>"\u{1f5ff}",':mozambique:'=>"\u{1f1f2}\u{1f1ff}",':mrs_claus:'=>"\u{1f936}",':mrs_claus_tone1:'=>"\u{1f936}\u{1f3fb}",':mrs_claus_tone2:'=>"\u{1f936}\u{1f3fc}",':mrs_claus_tone3:'=>"\u{1f936}\u{1f3fd}",':mrs_claus_tone4:'=>"\u{1f936}\u{1f3fe}",':mrs_claus_tone5:'=>"\u{1f936}\u{1f3ff}",':muscle:'=>"\u{1f4aa}",':muscle_tone1:'=>"\u{1f4aa}\u{1f3fb}",':muscle_tone2:'=>"\u{1f4aa}\u{1f3fc}",':muscle_tone3:'=>"\u{1f4aa}\u{1f3fd}",':muscle_tone4:'=>"\u{1f4aa}\u{1f3fe}",':muscle_tone5:'=>"\u{1f4aa}\u{1f3ff}",':mushroom:'=>"\u{1f344}",':musical_keyboard:'=>"\u{1f3b9}",':musical_note:'=>"\u{1f3b5}",':musical_score:'=>"\u{1f3bc}",':mute:'=>"\u{1f507}",':myanmar:'=>"\u{1f1f2}\u{1f1f2}",':nail_care:'=>"\u{1f485}",':nail_care_tone1:'=>"\u{1f485}\u{1f3fb}",':nail_care_tone2:'=>"\u{1f485}\u{1f3fc}",':nail_care_tone3:'=>"\u{1f485}\u{1f3fd}",':nail_care_tone4:'=>"\u{1f485}\u{1f3fe}",':nail_care_tone5:'=>"\u{1f485}\u{1f3ff}",':name_badge:'=>"\u{1f4db}",':namibia:'=>"\u{1f1f3}\u{1f1e6}",':national_park:'=>"\u{1f3de}",':nauru:'=>"\u{1f1f3}\u{1f1f7}",':nauseated_face:'=>"\u{1f922}",':necktie:'=>"\u{1f454}",':negative_squared_cross_mark:'=>"\u{274e}",':nepal:'=>"\u{1f1f3}\u{1f1f5}",':nerd:'=>"\u{1f913}",':nerd_face:'=>"\u{1f913}",':netherlands:'=>"\u{1f1f3}\u{1f1f1}",':neutral_face:'=>"\u{1f610}",':new:'=>"\u{1f195}",':new_caledonia:'=>"\u{1f1f3}\u{1f1e8}",':new_moon:'=>"\u{1f311}",':new_moon_with_face:'=>"\u{1f31a}",':new_zealand:'=>"\u{1f1f3}\u{1f1ff}",':newspaper:'=>"\u{1f4f0}",':newspaper2:'=>"\u{1f5de}\u{fe0f}",':newspaper_roll:'=>"\u{1f5de}",':next_track_button:'=>"\u{23ed}",':ng:'=>"\u{1f196}",':ng_man:'=>"\u{1f645}\u{200d}\u{2642}\u{fe0f}",':ng_woman:'=>"\u{1f645}",':nicaragua:'=>"\u{1f1f3}\u{1f1ee}",':niger:'=>"\u{1f1f3}\u{1f1ea}",':nigeria:'=>"\u{1f1f3}\u{1f1ec}",':night_with_stars:'=>"\u{1f303}",':nine:'=>"9\u{20e3}",':niue:'=>"\u{1f1f3}\u{1f1fa}",':no_bell:'=>"\u{1f515}",':no_bicycles:'=>"\u{1f6b3}",':no_entry:'=>"\u{26d4}\u{fe0f}",':no_entry_sign:'=>"\u{1f6ab}",':no_good:'=>"\u{1f645}",':no_good_man:'=>"\u{1f645}\u{200d}\u{2642}\u{fe0f}",':no_good_woman:'=>"\u{1f645}",':no_mobile_phones:'=>"\u{1f4f5}",':no_mouth:'=>"\u{1f636}",':no_pedestrians:'=>"\u{1f6b7}",':no_smoking:'=>"\u{1f6ad}",':non-potable_water:'=>"\u{1f6b1}",':norfolk_island:'=>"\u{1f1f3}\u{1f1eb}",':north_korea:'=>"\u{1f1f0}\u{1f1f5}",':northern_mariana_islands:'=>"\u{1f1f2}\u{1f1f5}",':norway:'=>"\u{1f1f3}\u{1f1f4}",':nose:'=>"\u{1f443}",':nose_tone1:'=>"\u{1f443}\u{1f3fb}",':nose_tone2:'=>"\u{1f443}\u{1f3fc}",':nose_tone3:'=>"\u{1f443}\u{1f3fd}",':nose_tone4:'=>"\u{1f443}\u{1f3fe}",':nose_tone5:'=>"\u{1f443}\u{1f3ff}",':notebook:'=>"\u{1f4d3}",':notebook_with_decorative_cover:'=>"\u{1f4d4}",':notepad_spiral:'=>"\u{1f5d2}\u{fe0f}",':notes:'=>"\u{1f3b6}",':nut_and_bolt:'=>"\u{1f529}",':o:'=>"\u{2b55}\u{fe0f}",':o2:'=>"\u{1f17e}\u{fe0f}",':ocean:'=>"\u{1f30a}",':octagonal_sign:'=>"\u{1f6d1}",':octopus:'=>"\u{1f419}",':oden:'=>"\u{1f362}",':office:'=>"\u{1f3e2}",':oil:'=>"\u{1f6e2}\u{fe0f}",':oil_drum:'=>"\u{1f6e2}",':ok:'=>"\u{1f197}",':ok_hand:'=>"\u{1f44c}",':ok_hand_tone1:'=>"\u{1f44c}\u{1f3fb}",':ok_hand_tone2:'=>"\u{1f44c}\u{1f3fc}",':ok_hand_tone3:'=>"\u{1f44c}\u{1f3fd}",':ok_hand_tone4:'=>"\u{1f44c}\u{1f3fe}",':ok_hand_tone5:'=>"\u{1f44c}\u{1f3ff}",':ok_man:'=>"\u{1f646}\u{200d}\u{2642}\u{fe0f}",':ok_woman:'=>"\u{1f646}",':old_key:'=>"\u{1f5dd}",':older_adult:'=>"\u{1f9d3}\u{1f3ff}",':older_adult_tone1:'=>"\u{1f9d3}\u{1f3fb}",':older_adult_tone2:'=>"\u{1f9d3}\u{1f3fc}",':older_adult_tone3:'=>"\u{1f9d3}\u{1f3fd}",':older_adult_tone4:'=>"\u{1f9d3}\u{1f3fe}",':older_adult_tone5:'=>"\u{1f9d3}\u{1f3ff}",':older_man:'=>"\u{1f474}",':older_man_tone1:'=>"\u{1f474}\u{1f3fb}",':older_man_tone2:'=>"\u{1f474}\u{1f3fc}",':older_man_tone3:'=>"\u{1f474}\u{1f3fd}",':older_man_tone4:'=>"\u{1f474}\u{1f3fe}",':older_man_tone5:'=>"\u{1f474}\u{1f3ff}",':older_woman:'=>"\u{1f475}",':older_woman_tone1:'=>"\u{1f475}\u{1f3fb}",':older_woman_tone2:'=>"\u{1f475}\u{1f3fc}",':older_woman_tone3:'=>"\u{1f475}\u{1f3fd}",':older_woman_tone4:'=>"\u{1f475}\u{1f3fe}",':older_woman_tone5:'=>"\u{1f475}\u{1f3ff}",':om:'=>"\u{1f549}",':om_symbol:'=>"\u{1f549}\u{fe0f}",':oman:'=>"\u{1f1f4}\u{1f1f2}",':on:'=>"\u{1f51b}",':oncoming_automobile:'=>"\u{1f698}",':oncoming_bus:'=>"\u{1f68d}",':oncoming_police_car:'=>"\u{1f694}",':oncoming_taxi:'=>"\u{1f696}",':one:'=>"1\u{20e3}",':open_book:'=>"\u{1f4d6}",':open_file_folder:'=>"\u{1f4c2}",':open_hands:'=>"\u{1f450}",':open_hands_tone1:'=>"\u{1f450}\u{1f3fb}",':open_hands_tone2:'=>"\u{1f450}\u{1f3fc}",':open_hands_tone3:'=>"\u{1f450}\u{1f3fd}",':open_hands_tone4:'=>"\u{1f450}\u{1f3fe}",':open_hands_tone5:'=>"\u{1f450}\u{1f3ff}",':open_mouth:'=>"\u{1f62e}",':open_umbrella:'=>"\u{2602}\u{fe0f}",':ophiuchus:'=>"\u{26ce}",':orange:'=>"\u{1f34a}",':orange_book:'=>"\u{1f4d9}",':orange_heart:'=>"\u{1f9e1}",':orthodox_cross:'=>"\u{2626}\u{fe0f}",':outbox_tray:'=>"\u{1f4e4}",':owl:'=>"\u{1f989}",':ox:'=>"\u{1f402}",':package:'=>"\u{1f4e6}",':page_facing_up:'=>"\u{1f4c4}",':page_with_curl:'=>"\u{1f4c3}",':pager:'=>"\u{1f4df}",':paintbrush:'=>"\u{1f58c}",':pakistan:'=>"\u{1f1f5}\u{1f1f0}",':palau:'=>"\u{1f1f5}\u{1f1fc}",':palestinian_territories:'=>"\u{1f1f5}\u{1f1f8}",':palm_tree:'=>"\u{1f334}",':palms_up_together:'=>"\u{1f932}\u{1f3ff}",':palms_up_together_tone1:'=>"\u{1f932}\u{1f3fb}",':palms_up_together_tone2:'=>"\u{1f932}\u{1f3fc}",':palms_up_together_tone3:'=>"\u{1f932}\u{1f3fd}",':palms_up_together_tone4:'=>"\u{1f932}\u{1f3fe}",':palms_up_together_tone5:'=>"\u{1f932}\u{1f3ff}",':panama:'=>"\u{1f1f5}\u{1f1e6}",':pancakes:'=>"\u{1f95e}",':panda_face:'=>"\u{1f43c}",':paperclip:'=>"\u{1f4ce}",':paperclips:'=>"\u{1f587}",':papua_new_guinea:'=>"\u{1f1f5}\u{1f1ec}",':paraguay:'=>"\u{1f1f5}\u{1f1fe}",':parasol_on_ground:'=>"\u{26f1}",':park:'=>"\u{1f3de}\u{fe0f}",':parking:'=>"\u{1f17f}\u{fe0f}",':part_alternation_mark:'=>"\u{303d}\u{fe0f}",':partly_sunny:'=>"\u{26c5}\u{fe0f}",':passenger_ship:'=>"\u{1f6f3}",':passport_control:'=>"\u{1f6c2}",':pause_button:'=>"\u{23f8}",':paw_prints:'=>"\u{1f43e}",':peace:'=>"\u{262e}\u{fe0f}",':peace_symbol:'=>"\u{262e}\u{fe0f}",':peach:'=>"\u{1f351}",':peanuts:'=>"\u{1f95c}",':pear:'=>"\u{1f350}",':pen:'=>"\u{1f58a}",':pen_ballpoint:'=>"\u{1f58a}\u{fe0f}",':pen_fountain:'=>"\u{1f58b}\u{fe0f}",':pencil:'=>"\u{1f4dd}",':pencil2:'=>"\u{270f}\u{fe0f}",':penguin:'=>"\u{1f427}",':pensive:'=>"\u{1f614}",':people_with_bunny_ears_partying:'=>"\u{1f46f}",':people_wrestling:'=>"\u{1f93c}",':performing_arts:'=>"\u{1f3ad}",':persevere:'=>"\u{1f623}",':person_biking:'=>"\u{1f6b4}\u{1f3ff}",':person_biking_tone1:'=>"\u{1f6b4}\u{1f3fb}",':person_biking_tone2:'=>"\u{1f6b4}\u{1f3fc}",':person_biking_tone3:'=>"\u{1f6b4}\u{1f3fd}",':person_biking_tone4:'=>"\u{1f6b4}\u{1f3fe}",':person_biking_tone5:'=>"\u{1f6b4}\u{1f3ff}",':person_bouncing_ball:'=>"\u{26f9}\u{1f3ff}",':person_bouncing_ball_tone1:'=>"\u{26f9}\u{1f3fb}",':person_bouncing_ball_tone2:'=>"\u{26f9}\u{1f3fc}",':person_bouncing_ball_tone3:'=>"\u{26f9}\u{1f3fd}",':person_bouncing_ball_tone4:'=>"\u{26f9}\u{1f3fe}",':person_bouncing_ball_tone5:'=>"\u{26f9}\u{1f3ff}",':person_bowing:'=>"\u{1f647}\u{1f3ff}",':person_bowing_tone1:'=>"\u{1f647}\u{1f3fb}",':person_bowing_tone2:'=>"\u{1f647}\u{1f3fc}",':person_bowing_tone3:'=>"\u{1f647}\u{1f3fd}",':person_bowing_tone4:'=>"\u{1f647}\u{1f3fe}",':person_bowing_tone5:'=>"\u{1f647}\u{1f3ff}",':person_climbing:'=>"\u{1f9d7}\u{1f3ff}",':person_climbing_tone1:'=>"\u{1f9d7}\u{1f3fb}",':person_climbing_tone2:'=>"\u{1f9d7}\u{1f3fc}",':person_climbing_tone3:'=>"\u{1f9d7}\u{1f3fd}",':person_climbing_tone4:'=>"\u{1f9d7}\u{1f3fe}",':person_climbing_tone5:'=>"\u{1f9d7}\u{1f3ff}",':person_doing_cartwheel:'=>"\u{1f938}",':person_doing_cartwheel_tone1:'=>"\u{1f938}\u{1f3fb}",':person_doing_cartwheel_tone2:'=>"\u{1f938}\u{1f3fc}",':person_doing_cartwheel_tone3:'=>"\u{1f938}\u{1f3fd}",':person_doing_cartwheel_tone4:'=>"\u{1f938}\u{1f3fe}",':person_doing_cartwheel_tone5:'=>"\u{1f938}\u{1f3ff}",':person_facepalming:'=>"\u{1f926}\u{1f3ff}",':person_facepalming_tone1:'=>"\u{1f926}\u{1f3fb}",':person_facepalming_tone2:'=>"\u{1f926}\u{1f3fc}",':person_facepalming_tone3:'=>"\u{1f926}\u{1f3fd}",':person_facepalming_tone4:'=>"\u{1f926}\u{1f3fe}",':person_facepalming_tone5:'=>"\u{1f926}\u{1f3ff}",':person_fencing:'=>"\u{1f93a}",':person_frowning:'=>"\u{1f64d}",':person_frowning_tone1:'=>"\u{1f64d}\u{1f3fb}",':person_frowning_tone2:'=>"\u{1f64d}\u{1f3fc}",':person_frowning_tone3:'=>"\u{1f64d}\u{1f3fd}",':person_frowning_tone4:'=>"\u{1f64d}\u{1f3fe}",':person_frowning_tone5:'=>"\u{1f64d}\u{1f3ff}",':person_gesturing_no:'=>"\u{1f645}",':person_gesturing_no_tone1:'=>"\u{1f645}\u{1f3fb}",':person_gesturing_no_tone2:'=>"\u{1f645}\u{1f3fc}",':person_gesturing_no_tone3:'=>"\u{1f645}\u{1f3fd}",':person_gesturing_no_tone4:'=>"\u{1f645}\u{1f3fe}",':person_gesturing_no_tone5:'=>"\u{1f645}\u{1f3ff}",':person_gesturing_ok:'=>"\u{1f646}",':person_gesturing_ok_tone1:'=>"\u{1f646}\u{1f3fb}",':person_gesturing_ok_tone2:'=>"\u{1f646}\u{1f3fc}",':person_gesturing_ok_tone3:'=>"\u{1f646}\u{1f3fd}",':person_gesturing_ok_tone4:'=>"\u{1f646}\u{1f3fe}",':person_gesturing_ok_tone5:'=>"\u{1f646}\u{1f3ff}",':person_getting_haircut:'=>"\u{1f487}\u{1f3ff}",':person_getting_haircut_tone1:'=>"\u{1f487}\u{1f3fb}",':person_getting_haircut_tone2:'=>"\u{1f487}\u{1f3fc}",':person_getting_haircut_tone3:'=>"\u{1f487}\u{1f3fd}",':person_getting_haircut_tone4:'=>"\u{1f487}\u{1f3fe}",':person_getting_haircut_tone5:'=>"\u{1f487}\u{1f3ff}",':person_getting_massage:'=>"\u{1f486}\u{1f3ff}",':person_getting_massage_tone1:'=>"\u{1f486}\u{1f3fb}",':person_getting_massage_tone2:'=>"\u{1f486}\u{1f3fc}",':person_getting_massage_tone3:'=>"\u{1f486}\u{1f3fd}",':person_getting_massage_tone4:'=>"\u{1f486}\u{1f3fe}",':person_getting_massage_tone5:'=>"\u{1f486}\u{1f3ff}",':person_golfing:'=>"\u{1f3cc}\u{1f3ff}",':person_golfing_tone1:'=>"\u{1f3cc}\u{1f3fb}",':person_golfing_tone2:'=>"\u{1f3cc}\u{1f3fc}",':person_golfing_tone3:'=>"\u{1f3cc}\u{1f3fd}",':person_golfing_tone4:'=>"\u{1f3cc}\u{1f3fe}",':person_golfing_tone5:'=>"\u{1f3cc}\u{1f3ff}",':person_in_bed_tone1:'=>"\u{1f6cc}\u{1f3fb}",':person_in_bed_tone2:'=>"\u{1f6cc}\u{1f3fc}",':person_in_bed_tone3:'=>"\u{1f6cc}\u{1f3fd}",':person_in_bed_tone4:'=>"\u{1f6cc}\u{1f3fe}",':person_in_bed_tone5:'=>"\u{1f6cc}\u{1f3ff}",':person_in_lotus_position:'=>"\u{1f9d8}\u{1f3ff}",':person_in_lotus_position_tone1:'=>"\u{1f9d8}\u{1f3fb}",':person_in_lotus_position_tone2:'=>"\u{1f9d8}\u{1f3fc}",':person_in_lotus_position_tone3:'=>"\u{1f9d8}\u{1f3fd}",':person_in_lotus_position_tone4:'=>"\u{1f9d8}\u{1f3fe}",':person_in_lotus_position_tone5:'=>"\u{1f9d8}\u{1f3ff}",':person_in_steamy_room:'=>"\u{1f9d6}\u{1f3ff}",':person_in_steamy_room_tone1:'=>"\u{1f9d6}\u{1f3fb}",':person_in_steamy_room_tone2:'=>"\u{1f9d6}\u{1f3fc}",':person_in_steamy_room_tone3:'=>"\u{1f9d6}\u{1f3fd}",':person_in_steamy_room_tone4:'=>"\u{1f9d6}\u{1f3fe}",':person_in_steamy_room_tone5:'=>"\u{1f9d6}\u{1f3ff}",':person_juggling:'=>"\u{1f939}\u{1f3ff}",':person_juggling_tone1:'=>"\u{1f939}\u{1f3fb}",':person_juggling_tone2:'=>"\u{1f939}\u{1f3fc}",':person_juggling_tone3:'=>"\u{1f939}\u{1f3fd}",':person_juggling_tone4:'=>"\u{1f939}\u{1f3fe}",':person_juggling_tone5:'=>"\u{1f939}\u{1f3ff}",':person_lifting_weights:'=>"\u{1f3cb}\u{1f3ff}",':person_lifting_weights_tone1:'=>"\u{1f3cb}\u{1f3fb}",':person_lifting_weights_tone2:'=>"\u{1f3cb}\u{1f3fc}",':person_lifting_weights_tone3:'=>"\u{1f3cb}\u{1f3fd}",':person_lifting_weights_tone4:'=>"\u{1f3cb}\u{1f3fe}",':person_lifting_weights_tone5:'=>"\u{1f3cb}\u{1f3ff}",':person_mountain_biking:'=>"\u{1f6b5}\u{1f3ff}",':person_mountain_biking_tone1:'=>"\u{1f6b5}\u{1f3fb}",':person_mountain_biking_tone2:'=>"\u{1f6b5}\u{1f3fc}",':person_mountain_biking_tone3:'=>"\u{1f6b5}\u{1f3fd}",':person_mountain_biking_tone4:'=>"\u{1f6b5}\u{1f3fe}",':person_mountain_biking_tone5:'=>"\u{1f6b5}\u{1f3ff}",':person_playing_handball:'=>"\u{1f93e}\u{1f3ff}",':person_playing_handball_tone1:'=>"\u{1f93e}\u{1f3fb}",':person_playing_handball_tone2:'=>"\u{1f93e}\u{1f3fc}",':person_playing_handball_tone3:'=>"\u{1f93e}\u{1f3fd}",':person_playing_handball_tone4:'=>"\u{1f93e}\u{1f3fe}",':person_playing_handball_tone5:'=>"\u{1f93e}\u{1f3ff}",':person_playing_water_polo:'=>"\u{1f93d}\u{1f3ff}",':person_playing_water_polo_tone1:'=>"\u{1f93d}\u{1f3fb}",':person_playing_water_polo_tone2:'=>"\u{1f93d}\u{1f3fc}",':person_playing_water_polo_tone3:'=>"\u{1f93d}\u{1f3fd}",':person_playing_water_polo_tone4:'=>"\u{1f93d}\u{1f3fe}",':person_playing_water_polo_tone5:'=>"\u{1f93d}\u{1f3ff}",':person_pouting:'=>"\u{1f64e}\u{1f3ff}",':person_pouting_tone1:'=>"\u{1f64e}\u{1f3fb}",':person_pouting_tone2:'=>"\u{1f64e}\u{1f3fc}",':person_pouting_tone3:'=>"\u{1f64e}\u{1f3fd}",':person_pouting_tone4:'=>"\u{1f64e}\u{1f3fe}",':person_pouting_tone5:'=>"\u{1f64e}\u{1f3ff}",':person_raising_hand:'=>"\u{1f64b}\u{1f3ff}",':person_raising_hand_tone1:'=>"\u{1f64b}\u{1f3fb}",':person_raising_hand_tone2:'=>"\u{1f64b}\u{1f3fc}",':person_raising_hand_tone3:'=>"\u{1f64b}\u{1f3fd}",':person_raising_hand_tone4:'=>"\u{1f64b}\u{1f3fe}",':person_raising_hand_tone5:'=>"\u{1f64b}\u{1f3ff}",':person_rowing_boat:'=>"\u{1f6a3}\u{1f3ff}",':person_rowing_boat_tone1:'=>"\u{1f6a3}\u{1f3fb}",':person_rowing_boat_tone2:'=>"\u{1f6a3}\u{1f3fc}",':person_rowing_boat_tone3:'=>"\u{1f6a3}\u{1f3fd}",':person_rowing_boat_tone4:'=>"\u{1f6a3}\u{1f3fe}",':person_rowing_boat_tone5:'=>"\u{1f6a3}\u{1f3ff}",':person_running:'=>"\u{1f3c3}\u{1f3ff}",':person_running_tone1:'=>"\u{1f3c3}\u{1f3fb}",':person_running_tone2:'=>"\u{1f3c3}\u{1f3fc}",':person_running_tone3:'=>"\u{1f3c3}\u{1f3fd}",':person_running_tone4:'=>"\u{1f3c3}\u{1f3fe}",':person_running_tone5:'=>"\u{1f3c3}\u{1f3ff}",':person_shrugging:'=>"\u{1f937}\u{1f3ff}",':person_shrugging_tone1:'=>"\u{1f937}\u{1f3fb}",':person_shrugging_tone2:'=>"\u{1f937}\u{1f3fc}",':person_shrugging_tone3:'=>"\u{1f937}\u{1f3fd}",':person_shrugging_tone4:'=>"\u{1f937}\u{1f3fe}",':person_shrugging_tone5:'=>"\u{1f937}\u{1f3ff}",':person_surfing:'=>"\u{1f3c4}\u{1f3ff}",':person_surfing_tone1:'=>"\u{1f3c4}\u{1f3fb}",':person_surfing_tone2:'=>"\u{1f3c4}\u{1f3fc}",':person_surfing_tone3:'=>"\u{1f3c4}\u{1f3fd}",':person_surfing_tone4:'=>"\u{1f3c4}\u{1f3fe}",':person_surfing_tone5:'=>"\u{1f3c4}\u{1f3ff}",':person_swimming:'=>"\u{1f3ca}\u{1f3ff}",':person_swimming_tone1:'=>"\u{1f3ca}\u{1f3fb}",':person_swimming_tone2:'=>"\u{1f3ca}\u{1f3fc}",':person_swimming_tone3:'=>"\u{1f3ca}\u{1f3fd}",':person_swimming_tone4:'=>"\u{1f3ca}\u{1f3fe}",':person_swimming_tone5:'=>"\u{1f3ca}\u{1f3ff}",':person_tipping_hand:'=>"\u{1f481}\u{1f3ff}",':person_tipping_hand_tone1:'=>"\u{1f481}\u{1f3fb}",':person_tipping_hand_tone2:'=>"\u{1f481}\u{1f3fc}",':person_tipping_hand_tone3:'=>"\u{1f481}\u{1f3fd}",':person_tipping_hand_tone4:'=>"\u{1f481}\u{1f3fe}",':person_tipping_hand_tone5:'=>"\u{1f481}\u{1f3ff}",':person_walking:'=>"\u{1f6b6}\u{1f3ff}",':person_walking_tone1:'=>"\u{1f6b6}\u{1f3fb}",':person_walking_tone2:'=>"\u{1f6b6}\u{1f3fc}",':person_walking_tone3:'=>"\u{1f6b6}\u{1f3fd}",':person_walking_tone4:'=>"\u{1f6b6}\u{1f3fe}",':person_walking_tone5:'=>"\u{1f6b6}\u{1f3ff}",':person_wearing_turban:'=>"\u{1f473}\u{1f3ff}",':person_wearing_turban_tone1:'=>"\u{1f473}\u{1f3fb}",':person_wearing_turban_tone2:'=>"\u{1f473}\u{1f3fc}",':person_wearing_turban_tone3:'=>"\u{1f473}\u{1f3fd}",':person_wearing_turban_tone4:'=>"\u{1f473}\u{1f3fe}",':person_wearing_turban_tone5:'=>"\u{1f473}\u{1f3ff}",':person_with_blond_hair:'=>"\u{1f471}",':person_with_pouting_face:'=>"\u{1f64e}",':peru:'=>"\u{1f1f5}\u{1f1ea}",':philippines:'=>"\u{1f1f5}\u{1f1ed}",':phone:'=>"\u{260e}\u{fe0f}",':pick:'=>"\u{26cf}",':pie:'=>"\u{1f967}",':pig:'=>"\u{1f437}",':pig2:'=>"\u{1f416}",':pig_nose:'=>"\u{1f43d}",':pill:'=>"\u{1f48a}",':pineapple:'=>"\u{1f34d}",':ping_pong:'=>"\u{1f3d3}",':pisces:'=>"\u{2653}\u{fe0f}",':pitcairn_islands:'=>"\u{1f1f5}\u{1f1f3}",':pizza:'=>"\u{1f355}",':place_of_worship:'=>"\u{1f6d0}",':plate_with_cutlery:'=>"\u{1f37d}",':play_or_pause_button:'=>"\u{23ef}",':play_pause:'=>"\u{23ef}\u{fe0f}",':point_down:'=>"\u{1f447}",':point_down_tone1:'=>"\u{1f447}\u{1f3fb}",':point_down_tone2:'=>"\u{1f447}\u{1f3fc}",':point_down_tone3:'=>"\u{1f447}\u{1f3fd}",':point_down_tone4:'=>"\u{1f447}\u{1f3fe}",':point_down_tone5:'=>"\u{1f447}\u{1f3ff}",':point_left:'=>"\u{1f448}",':point_left_tone1:'=>"\u{1f448}\u{1f3fb}",':point_left_tone2:'=>"\u{1f448}\u{1f3fc}",':point_left_tone3:'=>"\u{1f448}\u{1f3fd}",':point_left_tone4:'=>"\u{1f448}\u{1f3fe}",':point_left_tone5:'=>"\u{1f448}\u{1f3ff}",':point_right:'=>"\u{1f449}",':point_right_tone1:'=>"\u{1f449}\u{1f3fb}",':point_right_tone2:'=>"\u{1f449}\u{1f3fc}",':point_right_tone3:'=>"\u{1f449}\u{1f3fd}",':point_right_tone4:'=>"\u{1f449}\u{1f3fe}",':point_right_tone5:'=>"\u{1f449}\u{1f3ff}",':point_up:'=>"\u{261d}\u{fe0f}",':point_up_2:'=>"\u{1f446}",':point_up_2_tone1:'=>"\u{1f446}\u{1f3fb}",':point_up_2_tone2:'=>"\u{1f446}\u{1f3fc}",':point_up_2_tone3:'=>"\u{1f446}\u{1f3fd}",':point_up_2_tone4:'=>"\u{1f446}\u{1f3fe}",':point_up_2_tone5:'=>"\u{1f446}\u{1f3ff}",':point_up_tone1:'=>"\u{261d}\u{1f3fb}",':point_up_tone2:'=>"\u{261d}\u{1f3fc}",':point_up_tone3:'=>"\u{261d}\u{1f3fd}",':point_up_tone4:'=>"\u{261d}\u{1f3fe}",':point_up_tone5:'=>"\u{261d}\u{1f3ff}",':poland:'=>"\u{1f1f5}\u{1f1f1}",':police_car:'=>"\u{1f693}",':police_officer:'=>"\u{1f46e}\u{1f3ff}",':police_officer_tone1:'=>"\u{1f46e}\u{1f3fb}",':police_officer_tone2:'=>"\u{1f46e}\u{1f3fc}",':police_officer_tone3:'=>"\u{1f46e}\u{1f3fd}",':police_officer_tone4:'=>"\u{1f46e}\u{1f3fe}",':police_officer_tone5:'=>"\u{1f46e}\u{1f3ff}",':policeman:'=>"\u{1f46e}",':policewoman:'=>"\u{1f46e}\u{200d}\u{2640}\u{fe0f}",':poodle:'=>"\u{1f429}",':poop:'=>"\u{1f4a9}",':popcorn:'=>"\u{1f37f}",':portugal:'=>"\u{1f1f5}\u{1f1f9}",':post_office:'=>"\u{1f3e3}",':postal_horn:'=>"\u{1f4ef}",':postbox:'=>"\u{1f4ee}",':potable_water:'=>"\u{1f6b0}",':potato:'=>"\u{1f954}",':pouch:'=>"\u{1f45d}",':poultry_leg:'=>"\u{1f357}",':pound:'=>"\u{1f4b7}",':pound_symbol:'=>"#",':pout:'=>"\u{1f621}",':pouting_cat:'=>"\u{1f63e}",':pouting_man:'=>"\u{1f64e}\u{200d}\u{2642}\u{fe0f}",':pouting_woman:'=>"\u{1f64e}",':pray:'=>"\u{1f64f}",':pray_tone1:'=>"\u{1f64f}\u{1f3fb}",':pray_tone2:'=>"\u{1f64f}\u{1f3fc}",':pray_tone3:'=>"\u{1f64f}\u{1f3fd}",':pray_tone4:'=>"\u{1f64f}\u{1f3fe}",':pray_tone5:'=>"\u{1f64f}\u{1f3ff}",':prayer_beads:'=>"\u{1f4ff}",':pregnant_woman:'=>"\u{1f930}",':pregnant_woman_tone1:'=>"\u{1f930}\u{1f3fb}",':pregnant_woman_tone2:'=>"\u{1f930}\u{1f3fc}",':pregnant_woman_tone3:'=>"\u{1f930}\u{1f3fd}",':pregnant_woman_tone4:'=>"\u{1f930}\u{1f3fe}",':pregnant_woman_tone5:'=>"\u{1f930}\u{1f3ff}",':pretzel:'=>"\u{1f968}",':previous_track_button:'=>"\u{23ee}",':prince:'=>"\u{1f934}",':prince_tone1:'=>"\u{1f934}\u{1f3fb}",':prince_tone2:'=>"\u{1f934}\u{1f3fc}",':prince_tone3:'=>"\u{1f934}\u{1f3fd}",':prince_tone4:'=>"\u{1f934}\u{1f3fe}",':prince_tone5:'=>"\u{1f934}\u{1f3ff}",':princess:'=>"\u{1f478}",':princess_tone1:'=>"\u{1f478}\u{1f3fb}",':princess_tone2:'=>"\u{1f478}\u{1f3fc}",':princess_tone3:'=>"\u{1f478}\u{1f3fd}",':princess_tone4:'=>"\u{1f478}\u{1f3fe}",':princess_tone5:'=>"\u{1f478}\u{1f3ff}",':printer:'=>"\u{1f5a8}",':projector:'=>"\u{1f4fd}\u{fe0f}",':puerto_rico:'=>"\u{1f1f5}\u{1f1f7}",':punch:'=>"\u{1f44a}",':punch_tone1:'=>"\u{1f44a}\u{1f3fb}",':punch_tone2:'=>"\u{1f44a}\u{1f3fc}",':punch_tone3:'=>"\u{1f44a}\u{1f3fd}",':punch_tone4:'=>"\u{1f44a}\u{1f3fe}",':punch_tone5:'=>"\u{1f44a}\u{1f3ff}",':purple_heart:'=>"\u{1f49c}",':purse:'=>"\u{1f45b}",':pushpin:'=>"\u{1f4cc}",':put_litter_in_its_place:'=>"\u{1f6ae}",':qatar:'=>"\u{1f1f6}\u{1f1e6}",':question:'=>"\u{2753}",':rabbit:'=>"\u{1f430}",':rabbit2:'=>"\u{1f407}",':race_car:'=>"\u{1f3ce}\u{fe0f}",':racehorse:'=>"\u{1f40e}",':racing_car:'=>"\u{1f3ce}",':radio:'=>"\u{1f4fb}",':radio_button:'=>"\u{1f518}",':radioactive:'=>"\u{2622}\u{fe0f}",':rage:'=>"\u{1f621}",':railway_car:'=>"\u{1f683}",':railway_track:'=>"\u{1f6e4}",':rainbow:'=>"\u{1f308}",':rainbow_flag:'=>"\u{1f3f3}\u{fe0f}\u{200d}\u{1f308}",':raised_back_of_hand:'=>"\u{1f91a}",':raised_back_of_hand_tone1:'=>"\u{1f91a}\u{1f3fb}",':raised_back_of_hand_tone2:'=>"\u{1f91a}\u{1f3fc}",':raised_back_of_hand_tone3:'=>"\u{1f91a}\u{1f3fd}",':raised_back_of_hand_tone4:'=>"\u{1f91a}\u{1f3fe}",':raised_back_of_hand_tone5:'=>"\u{1f91a}\u{1f3ff}",':raised_hand:'=>"\u{270b}",':raised_hand_tone1:'=>"\u{270b}\u{1f3fb}",':raised_hand_tone2:'=>"\u{270b}\u{1f3fc}",':raised_hand_tone3:'=>"\u{270b}\u{1f3fd}",':raised_hand_tone4:'=>"\u{270b}\u{1f3fe}",':raised_hand_tone5:'=>"\u{270b}\u{1f3ff}",':raised_hand_with_fingers_splayed:'=>"\u{1f590}",':raised_hands:'=>"\u{1f64c}",':raised_hands_tone1:'=>"\u{1f64c}\u{1f3fb}",':raised_hands_tone2:'=>"\u{1f64c}\u{1f3fc}",':raised_hands_tone3:'=>"\u{1f64c}\u{1f3fd}",':raised_hands_tone4:'=>"\u{1f64c}\u{1f3fe}",':raised_hands_tone5:'=>"\u{1f64c}\u{1f3ff}",':raising_hand:'=>"\u{1f64b}",':raising_hand_man:'=>"\u{1f64b}\u{200d}\u{2642}\u{fe0f}",':raising_hand_woman:'=>"\u{1f64b}",':ram:'=>"\u{1f40f}",':ramen:'=>"\u{1f35c}",':rat:'=>"\u{1f400}",':record_button:'=>"\u{23fa}",':recycle:'=>"\u{267b}\u{fe0f}",':red_car:'=>"\u{1f697}",':red_circle:'=>"\u{1f534}",':regional_indicator_a:'=>"\u{1f1e6}",':regional_indicator_b:'=>"\u{1f1e7}",':regional_indicator_c:'=>"\u{1f1e8}",':regional_indicator_d:'=>"\u{1f1e9}",':regional_indicator_e:'=>"\u{1f1ea}",':regional_indicator_f:'=>"\u{1f1eb}",':regional_indicator_g:'=>"\u{1f1ec}",':regional_indicator_h:'=>"\u{1f1ed}",':regional_indicator_i:'=>"\u{1f1ee}",':regional_indicator_j:'=>"\u{1f1ef}",':regional_indicator_k:'=>"\u{1f1f0}",':regional_indicator_l:'=>"\u{1f1f1}",':regional_indicator_m:'=>"\u{1f1f2}",':regional_indicator_n:'=>"\u{1f1f3}",':regional_indicator_o:'=>"\u{1f1f4}",':regional_indicator_p:'=>"\u{1f1f5}",':regional_indicator_q:'=>"\u{1f1f6}",':regional_indicator_r:'=>"\u{1f1f7}",':regional_indicator_s:'=>"\u{1f1f8}",':regional_indicator_t:'=>"\u{1f1f9}",':regional_indicator_u:'=>"\u{1f1fa}",':regional_indicator_v:'=>"\u{1f1fb}",':regional_indicator_w:'=>"\u{1f1fc}",':regional_indicator_x:'=>"\u{1f1fd}",':regional_indicator_y:'=>"\u{1f1fe}",':regional_indicator_z:'=>"\u{1f1ff}",':registered:'=>"\u{ae}\u{fe0f}",':relaxed:'=>"\u{263a}\u{fe0f}",':relieved:'=>"\u{1f60c}",':reminder_ribbon:'=>"\u{1f397}",':repeat:'=>"\u{1f501}",':repeat_one:'=>"\u{1f502}",':rescue_worker_helmet:'=>"\u{26d1}",':restroom:'=>"\u{1f6bb}",':reunion:'=>"\u{1f1f7}\u{1f1ea}",':revolving_hearts:'=>"\u{1f49e}",':rewind:'=>"\u{23ea}",':rhino:'=>"\u{1f98f}",':rhinoceros:'=>"\u{1f98f}",':ribbon:'=>"\u{1f380}",':rice:'=>"\u{1f35a}",':rice_ball:'=>"\u{1f359}",':rice_cracker:'=>"\u{1f358}",':rice_scene:'=>"\u{1f391}",':right_anger_bubble:'=>"\u{1f5ef}",':right_facing_fist:'=>"\u{1f91c}",':right_facing_fist_tone1:'=>"\u{1f91c}\u{1f3fb}",':right_facing_fist_tone2:'=>"\u{1f91c}\u{1f3fc}",':right_facing_fist_tone3:'=>"\u{1f91c}\u{1f3fd}",':right_facing_fist_tone4:'=>"\u{1f91c}\u{1f3fe}",':right_facing_fist_tone5:'=>"\u{1f91c}\u{1f3ff}",':ring:'=>"\u{1f48d}",':robot:'=>"\u{1f916}",':rocket:'=>"\u{1f680}",':rofl:'=>"\u{1f923}",':roll_eyes:'=>"\u{1f644}",':roller_coaster:'=>"\u{1f3a2}",':rolling_eyes:'=>"\u{1f644}",':romania:'=>"\u{1f1f7}\u{1f1f4}",':rooster:'=>"\u{1f413}",':rose:'=>"\u{1f339}",':rosette:'=>"\u{1f3f5}",':rotating_light:'=>"\u{1f6a8}",':round_pushpin:'=>"\u{1f4cd}",':rowboat:'=>"\u{1f6a3}",':rowing_man:'=>"\u{1f6a3}",':rowing_woman:'=>"\u{1f6a3}\u{200d}\u{2640}\u{fe0f}",':ru:'=>"\u{1f1f7}\u{1f1fa}",':rugby_football:'=>"\u{1f3c9}",':runner:'=>"\u{1f3c3}",':running:'=>"\u{1f3c3}",':running_man:'=>"\u{1f3c3}",':running_shirt_with_sash:'=>"\u{1f3bd}",':running_woman:'=>"\u{1f3c3}\u{200d}\u{2640}\u{fe0f}",':rwanda:'=>"\u{1f1f7}\u{1f1fc}",':sa:'=>"\u{1f202}\u{fe0f}",':sagittarius:'=>"\u{2650}\u{fe0f}",':sailboat:'=>"\u{26f5}\u{fe0f}",':sake:'=>"\u{1f376}",':salad:'=>"\u{1f957}",':samoa:'=>"\u{1f1fc}\u{1f1f8}",':san_marino:'=>"\u{1f1f8}\u{1f1f2}",':sandal:'=>"\u{1f461}",':sandwich:'=>"\u{1f96a}",':santa:'=>"\u{1f385}",':santa_tone1:'=>"\u{1f385}\u{1f3fb}",':santa_tone2:'=>"\u{1f385}\u{1f3fc}",':santa_tone3:'=>"\u{1f385}\u{1f3fd}",':santa_tone4:'=>"\u{1f385}\u{1f3fe}",':santa_tone5:'=>"\u{1f385}\u{1f3ff}",':sao_tome_principe:'=>"\u{1f1f8}\u{1f1f9}",':sassy_man:'=>"\u{1f481}\u{200d}\u{2642}\u{fe0f}",':sassy_woman:'=>"\u{1f481}",':satellite:'=>"\u{1f4e1}",':satellite_orbital:'=>"\u{1f6f0}\u{fe0f}",':satisfied:'=>"\u{1f606}",':saudi_arabia:'=>"\u{1f1f8}\u{1f1e6}",':sauropod:'=>"\u{1f995}",':saxophone:'=>"\u{1f3b7}",':scales:'=>"\u{2696}\u{fe0f}",':scarf:'=>"\u{1f9e3}",':school:'=>"\u{1f3eb}",':school_satchel:'=>"\u{1f392}",':scissors:'=>"\u{2702}\u{fe0f}",':scooter:'=>"\u{1f6f4}",':scorpion:'=>"\u{1f982}",':scorpius:'=>"\u{264f}\u{fe0f}",':scotland:'=>"\u{1f3f4}\u{e0067}\u{e0062}\u{e0073}\u{e0063}\u{e0074}\u{e007f}",':scream:'=>"\u{1f631}",':scream_cat:'=>"\u{1f640}",':scroll:'=>"\u{1f4dc}",':seat:'=>"\u{1f4ba}",':second_place:'=>"\u{1f948}",':secret:'=>"\u{3299}\u{fe0f}",':see_no_evil:'=>"\u{1f648}",':seedling:'=>"\u{1f331}",':selfie:'=>"\u{1f933}",':selfie_tone1:'=>"\u{1f933}\u{1f3fb}",':selfie_tone2:'=>"\u{1f933}\u{1f3fc}",':selfie_tone3:'=>"\u{1f933}\u{1f3fd}",':selfie_tone4:'=>"\u{1f933}\u{1f3fe}",':selfie_tone5:'=>"\u{1f933}\u{1f3ff}",':senegal:'=>"\u{1f1f8}\u{1f1f3}",':serbia:'=>"\u{1f1f7}\u{1f1f8}",':seven:'=>"7\u{20e3}",':seychelles:'=>"\u{1f1f8}\u{1f1e8}",':shallow_pan_of_food:'=>"\u{1f958}",':shamrock:'=>"\u{2618}\u{fe0f}",':shark:'=>"\u{1f988}",':shaved_ice:'=>"\u{1f367}",':sheep:'=>"\u{1f411}",':shell:'=>"\u{1f41a}",':shield:'=>"\u{1f6e1}",':shinto_shrine:'=>"\u{26e9}",':ship:'=>"\u{1f6a2}",':shirt:'=>"\u{1f455}",':shit:'=>"\u{1f4a9}",':shoe:'=>"\u{1f45e}",':shopping:'=>"\u{1f6cd}",':shopping_bags:'=>"\u{1f6cd}\u{fe0f}",':shopping_cart:'=>"\u{1f6d2}",':shower:'=>"\u{1f6bf}",':shrimp:'=>"\u{1f990}",':shushing_face:'=>"\u{1f92b}",':sierra_leone:'=>"\u{1f1f8}\u{1f1f1}",':signal_strength:'=>"\u{1f4f6}",':singapore:'=>"\u{1f1f8}\u{1f1ec}",':sint_maarten:'=>"\u{1f1f8}\u{1f1fd}",':six:'=>"6\u{20e3}",':six_pointed_star:'=>"\u{1f52f}",':ski:'=>"\u{1f3bf}",':skier:'=>"\u{26f7}",':skull:'=>"\u{1f480}",':skull_and_crossbones:'=>"\u{2620}\u{fe0f}",':skull_crossbones:'=>"\u{2620}\u{fe0f}",':sled:'=>"\u{1f6f7}",':sleeping:'=>"\u{1f634}",':sleeping_accommodation:'=>"\u{1f6cc}",':sleeping_bed:'=>"\u{1f6cc}",':sleepy:'=>"\u{1f62a}",':slight_frown:'=>"\u{1f641}",':slight_smile:'=>"\u{1f642}",':slightly_frowning_face:'=>"\u{1f641}",':slightly_smiling_face:'=>"\u{1f642}",':slot_machine:'=>"\u{1f3b0}",':slovakia:'=>"\u{1f1f8}\u{1f1f0}",':slovenia:'=>"\u{1f1f8}\u{1f1ee}",':small_airplane:'=>"\u{1f6e9}",':small_blue_diamond:'=>"\u{1f539}",':small_orange_diamond:'=>"\u{1f538}",':small_red_triangle:'=>"\u{1f53a}",':small_red_triangle_down:'=>"\u{1f53b}",':smile:'=>"\u{1f604}",':smile_cat:'=>"\u{1f638}",':smiley:'=>"\u{1f603}",':smiley_cat:'=>"\u{1f63a}",':smiling_imp:'=>"\u{1f608}",':smirk:'=>"\u{1f60f}",':smirk_cat:'=>"\u{1f63c}",':smoking:'=>"\u{1f6ac}",':snail:'=>"\u{1f40c}",':snake:'=>"\u{1f40d}",':sneezing_face:'=>"\u{1f927}",':snowboarder:'=>"\u{1f3c2}",':snowboarder_tone1:'=>"\u{1f3c2}\u{1f3fb}",':snowboarder_tone2:'=>"\u{1f3c2}\u{1f3fc}",':snowboarder_tone3:'=>"\u{1f3c2}\u{1f3fd}",':snowboarder_tone4:'=>"\u{1f3c2}\u{1f3fe}",':snowboarder_tone5:'=>"\u{1f3c2}\u{1f3ff}",':snowflake:'=>"\u{2744}\u{fe0f}",':snowman:'=>"\u{26c4}\u{fe0f}",':snowman2:'=>"\u{2603}\u{fe0f}",':snowman_with_snow:'=>"\u{2603}\u{fe0f}",':sob:'=>"\u{1f62d}",':soccer:'=>"\u{26bd}\u{fe0f}",':socks:'=>"\u{1f9e6}",':solomon_islands:'=>"\u{1f1f8}\u{1f1e7}",':somalia:'=>"\u{1f1f8}\u{1f1f4}",':soon:'=>"\u{1f51c}",':sos:'=>"\u{1f198}",':sound:'=>"\u{1f509}",':south_africa:'=>"\u{1f1ff}\u{1f1e6}",':south_georgia_south_sandwich_islands:'=>"\u{1f1ec}\u{1f1f8}",':south_sudan:'=>"\u{1f1f8}\u{1f1f8}",':space_invader:'=>"\u{1f47e}",':spades:'=>"\u{2660}\u{fe0f}",':spaghetti:'=>"\u{1f35d}",':sparkle:'=>"\u{2747}\u{fe0f}",':sparkler:'=>"\u{1f387}",':sparkles:'=>"\u{2728}",':sparkling_heart:'=>"\u{1f496}",':speak_no_evil:'=>"\u{1f64a}",':speaker:'=>"\u{1f508}",':speaking_head:'=>"\u{1f5e3}",':speech_balloon:'=>"\u{1f4ac}",':speech_left:'=>"\u{1f5e8}\u{fe0f}",':speedboat:'=>"\u{1f6a4}",':spider:'=>"\u{1f577}",':spider_web:'=>"\u{1f578}",':spiral_calendar:'=>"\u{1f5d3}",':spiral_notepad:'=>"\u{1f5d2}",':spoon:'=>"\u{1f944}",':squid:'=>"\u{1f991}",':sri_lanka:'=>"\u{1f1f1}\u{1f1f0}",':st_barthelemy:'=>"\u{1f1e7}\u{1f1f1}",':st_helena:'=>"\u{1f1f8}\u{1f1ed}",':st_kitts_nevis:'=>"\u{1f1f0}\u{1f1f3}",':st_lucia:'=>"\u{1f1f1}\u{1f1e8}",':st_pierre_miquelon:'=>"\u{1f1f5}\u{1f1f2}",':st_vincent_grenadines:'=>"\u{1f1fb}\u{1f1e8}",':stadium:'=>"\u{1f3df}",':star:'=>"\u{2b50}\u{fe0f}",':star2:'=>"\u{1f31f}",':star_and_crescent:'=>"\u{262a}\u{fe0f}",':star_of_david:'=>"\u{2721}\u{fe0f}",':star_struck:'=>"\u{1f929}",':stars:'=>"\u{1f320}",':station:'=>"\u{1f689}",':statue_of_liberty:'=>"\u{1f5fd}",':steam_locomotive:'=>"\u{1f682}",':stew:'=>"\u{1f372}",':stop_button:'=>"\u{23f9}",':stop_sign:'=>"\u{1f6d1}",':stopwatch:'=>"\u{23f1}",':straight_ruler:'=>"\u{1f4cf}",':strawberry:'=>"\u{1f353}",':stuck_out_tongue:'=>"\u{1f61b}",':stuck_out_tongue_closed_eyes:'=>"\u{1f61d}",':stuck_out_tongue_winking_eye:'=>"\u{1f61c}",':studio_microphone:'=>"\u{1f399}",':stuffed_flatbread:'=>"\u{1f959}",':sudan:'=>"\u{1f1f8}\u{1f1e9}",':sun_behind_large_cloud:'=>"\u{1f325}",':sun_behind_rain_cloud:'=>"\u{1f326}",':sun_behind_small_cloud:'=>"\u{1f324}",':sun_with_face:'=>"\u{1f31e}",':sunflower:'=>"\u{1f33b}",':sunglasses:'=>"\u{1f60e}",':sunny:'=>"\u{2600}\u{fe0f}",':sunrise:'=>"\u{1f305}",':sunrise_over_mountains:'=>"\u{1f304}",':surfer:'=>"\u{1f3c4}",':surfing_man:'=>"\u{1f3c4}",':surfing_woman:'=>"\u{1f3c4}\u{200d}\u{2640}\u{fe0f}",':suriname:'=>"\u{1f1f8}\u{1f1f7}",':sushi:'=>"\u{1f363}",':suspension_railway:'=>"\u{1f69f}",':swaziland:'=>"\u{1f1f8}\u{1f1ff}",':sweat:'=>"\u{1f613}",':sweat_drops:'=>"\u{1f4a6}",':sweat_smile:'=>"\u{1f605}",':sweden:'=>"\u{1f1f8}\u{1f1ea}",':sweet_potato:'=>"\u{1f360}",':swimmer:'=>"\u{1f3ca}",':swimming_man:'=>"\u{1f3ca}",':swimming_woman:'=>"\u{1f3ca}\u{200d}\u{2640}\u{fe0f}",':switzerland:'=>"\u{1f1e8}\u{1f1ed}",':symbols:'=>"\u{1f523}",':synagogue:'=>"\u{1f54d}",':syria:'=>"\u{1f1f8}\u{1f1fe}",':syringe:'=>"\u{1f489}",':t_rex:'=>"\u{1f996}",':taco:'=>"\u{1f32e}",':tada:'=>"\u{1f389}",':taiwan:'=>"\u{1f1f9}\u{1f1fc}",':tajikistan:'=>"\u{1f1f9}\u{1f1ef}",':takeout_box:'=>"\u{1f961}",':tanabata_tree:'=>"\u{1f38b}",':tangerine:'=>"\u{1f34a}",':tanzania:'=>"\u{1f1f9}\u{1f1ff}",':taurus:'=>"\u{2649}\u{fe0f}",':taxi:'=>"\u{1f695}",':tea:'=>"\u{1f375}",':telephone:'=>"\u{260e}\u{fe0f}",':telephone_receiver:'=>"\u{1f4de}",':telescope:'=>"\u{1f52d}",':tennis:'=>"\u{1f3be}",':tent:'=>"\u{26fa}\u{fe0f}",':thailand:'=>"\u{1f1f9}\u{1f1ed}",':thermometer:'=>"\u{1f321}",':thermometer_face:'=>"\u{1f912}",':thinking:'=>"\u{1f914}",':third_place:'=>"\u{1f949}",':thought_balloon:'=>"\u{1f4ad}",':three:'=>"3\u{20e3}",':thumbsdown:'=>"\u{1f44e}",':thumbsdown_tone1:'=>"\u{1f44e}\u{1f3fb}",':thumbsdown_tone2:'=>"\u{1f44e}\u{1f3fc}",':thumbsdown_tone3:'=>"\u{1f44e}\u{1f3fd}",':thumbsdown_tone4:'=>"\u{1f44e}\u{1f3fe}",':thumbsdown_tone5:'=>"\u{1f44e}\u{1f3ff}",':thumbsup:'=>"\u{1f44d}",':thumbsup_tone1:'=>"\u{1f44d}\u{1f3fb}",':thumbsup_tone2:'=>"\u{1f44d}\u{1f3fc}",':thumbsup_tone3:'=>"\u{1f44d}\u{1f3fd}",':thumbsup_tone4:'=>"\u{1f44d}\u{1f3fe}",':thumbsup_tone5:'=>"\u{1f44d}\u{1f3ff}",':thunder_cloud_rain:'=>"\u{26c8}\u{fe0f}",':ticket:'=>"\u{1f3ab}",':tickets:'=>"\u{1f39f}",':tiger:'=>"\u{1f42f}",':tiger2:'=>"\u{1f405}",':timer:'=>"\u{23f2}\u{fe0f}",':timer_clock:'=>"\u{23f2}",':timor_leste:'=>"\u{1f1f9}\u{1f1f1}",':tipping_hand_man:'=>"\u{1f481}\u{200d}\u{2642}\u{fe0f}",':tipping_hand_woman:'=>"\u{1f481}",':tired_face:'=>"\u{1f62b}",':tm:'=>"\u{2122}\u{fe0f}",':togo:'=>"\u{1f1f9}\u{1f1ec}",':toilet:'=>"\u{1f6bd}",':tokelau:'=>"\u{1f1f9}\u{1f1f0}",':tokyo_tower:'=>"\u{1f5fc}",':tomato:'=>"\u{1f345}",':tone1:'=>"\u{1f3fb}",':tone2:'=>"\u{1f3fc}",':tone3:'=>"\u{1f3fd}",':tone4:'=>"\u{1f3fe}",':tone5:'=>"\u{1f3ff}",':tonga:'=>"\u{1f1f9}\u{1f1f4}",':tongue:'=>"\u{1f445}",':tools:'=>"\u{1f6e0}\u{fe0f}",':top:'=>"\u{1f51d}",':tophat:'=>"\u{1f3a9}",':tornado:'=>"\u{1f32a}",':tr:'=>"\u{1f1f9}\u{1f1f7}",':track_next:'=>"\u{23ed}\u{fe0f}",':track_previous:'=>"\u{23ee}\u{fe0f}",':trackball:'=>"\u{1f5b2}",':tractor:'=>"\u{1f69c}",':traffic_light:'=>"\u{1f6a5}",':train:'=>"\u{1f68b}",':train2:'=>"\u{1f686}",':tram:'=>"\u{1f68a}",':triangular_flag_on_post:'=>"\u{1f6a9}",':triangular_ruler:'=>"\u{1f4d0}",':trident:'=>"\u{1f531}",':trinidad_tobago:'=>"\u{1f1f9}\u{1f1f9}",':triumph:'=>"\u{1f624}",':trolleybus:'=>"\u{1f68e}",':trophy:'=>"\u{1f3c6}",':tropical_drink:'=>"\u{1f379}",':tropical_fish:'=>"\u{1f420}",':truck:'=>"\u{1f69a}",':trumpet:'=>"\u{1f3ba}",':tshirt:'=>"\u{1f455}",':tulip:'=>"\u{1f337}",':tumbler_glass:'=>"\u{1f943}",':tunisia:'=>"\u{1f1f9}\u{1f1f3}",':turkey:'=>"\u{1f983}",':turkmenistan:'=>"\u{1f1f9}\u{1f1f2}",':turks_caicos_islands:'=>"\u{1f1f9}\u{1f1e8}",':turtle:'=>"\u{1f422}",':tuvalu:'=>"\u{1f1f9}\u{1f1fb}",':tv:'=>"\u{1f4fa}",':twisted_rightwards_arrows:'=>"\u{1f500}",':two:'=>"2\u{20e3}",':two_hearts:'=>"\u{1f495}",':two_men_holding_hands:'=>"\u{1f46c}",':two_women_holding_hands:'=>"\u{1f46d}",':u5272:'=>"\u{1f239}",':u5408:'=>"\u{1f234}",':u55b6:'=>"\u{1f23a}",':u6307:'=>"\u{1f22f}\u{fe0f}",':u6708:'=>"\u{1f237}\u{fe0f}",':u6709:'=>"\u{1f236}",':u6e80:'=>"\u{1f235}",':u7121:'=>"\u{1f21a}\u{fe0f}",':u7533:'=>"\u{1f238}",':u7981:'=>"\u{1f232}",':u7a7a:'=>"\u{1f233}",':uganda:'=>"\u{1f1fa}\u{1f1ec}",':uk:'=>"\u{1f1ec}\u{1f1e7}",':ukraine:'=>"\u{1f1fa}\u{1f1e6}",':umbrella:'=>"\u{2614}\u{fe0f}",':umbrella2:'=>"\u{2602}\u{fe0f}",':unamused:'=>"\u{1f612}",':underage:'=>"\u{1f51e}",':unicorn:'=>"\u{1f984}",':united_arab_emirates:'=>"\u{1f1e6}\u{1f1ea}",':united_nations:'=>"\u{1f1fa}\u{1f1f3}",':unlock:'=>"\u{1f513}",':up:'=>"\u{1f199}",':upside_down:'=>"\u{1f643}",':upside_down_face:'=>"\u{1f643}",':urn:'=>"\u{26b1}\u{fe0f}",':uruguay:'=>"\u{1f1fa}\u{1f1fe}",':us:'=>"\u{1f1fa}\u{1f1f8}",':us_virgin_islands:'=>"\u{1f1fb}\u{1f1ee}",':uzbekistan:'=>"\u{1f1fa}\u{1f1ff}",':v:'=>"\u{270c}\u{fe0f}",':v_tone1:'=>"\u{270c}\u{1f3fb}",':v_tone2:'=>"\u{270c}\u{1f3fc}",':v_tone3:'=>"\u{270c}\u{1f3fd}",':v_tone4:'=>"\u{270c}\u{1f3fe}",':v_tone5:'=>"\u{270c}\u{1f3ff}",':vampire:'=>"\u{1f9db}\u{1f3ff}",':vampire_tone1:'=>"\u{1f9db}\u{1f3fb}",':vampire_tone2:'=>"\u{1f9db}\u{1f3fc}",':vampire_tone3:'=>"\u{1f9db}\u{1f3fd}",':vampire_tone4:'=>"\u{1f9db}\u{1f3fe}",':vampire_tone5:'=>"\u{1f9db}\u{1f3ff}",':vanuatu:'=>"\u{1f1fb}\u{1f1fa}",':vatican_city:'=>"\u{1f1fb}\u{1f1e6}",':venezuela:'=>"\u{1f1fb}\u{1f1ea}",':vertical_traffic_light:'=>"\u{1f6a6}",':vhs:'=>"\u{1f4fc}",':vibration_mode:'=>"\u{1f4f3}",':video_camera:'=>"\u{1f4f9}",':video_game:'=>"\u{1f3ae}",':vietnam:'=>"\u{1f1fb}\u{1f1f3}",':violin:'=>"\u{1f3bb}",':virgo:'=>"\u{264d}\u{fe0f}",':volcano:'=>"\u{1f30b}",':volleyball:'=>"\u{1f3d0}",':vs:'=>"\u{1f19a}",':vulcan:'=>"\u{1f596}",':vulcan_salute:'=>"\u{1f596}",':vulcan_tone1:'=>"\u{1f596}\u{1f3fb}",':vulcan_tone2:'=>"\u{1f596}\u{1f3fc}",':vulcan_tone3:'=>"\u{1f596}\u{1f3fd}",':vulcan_tone4:'=>"\u{1f596}\u{1f3fe}",':vulcan_tone5:'=>"\u{1f596}\u{1f3ff}",':wales:'=>"\u{1f3f4}\u{e0067}\u{e0062}\u{e0077}\u{e006c}\u{e0073}\u{e007f}",':walking:'=>"\u{1f6b6}",':walking_man:'=>"\u{1f6b6}",':walking_woman:'=>"\u{1f6b6}\u{200d}\u{2640}\u{fe0f}",':wallis_futuna:'=>"\u{1f1fc}\u{1f1eb}",':waning_crescent_moon:'=>"\u{1f318}",':waning_gibbous_moon:'=>"\u{1f316}",':warning:'=>"\u{26a0}\u{fe0f}",':wastebasket:'=>"\u{1f5d1}",':watch:'=>"\u{231a}\u{fe0f}",':water_buffalo:'=>"\u{1f403}",':watermelon:'=>"\u{1f349}",':wave:'=>"\u{1f44b}",':wave_tone1:'=>"\u{1f44b}\u{1f3fb}",':wave_tone2:'=>"\u{1f44b}\u{1f3fc}",':wave_tone3:'=>"\u{1f44b}\u{1f3fd}",':wave_tone4:'=>"\u{1f44b}\u{1f3fe}",':wave_tone5:'=>"\u{1f44b}\u{1f3ff}",':wavy_dash:'=>"\u{3030}\u{fe0f}",':waxing_crescent_moon:'=>"\u{1f312}",':waxing_gibbous_moon:'=>"\u{1f314}",':wc:'=>"\u{1f6be}",':weary:'=>"\u{1f629}",':wedding:'=>"\u{1f492}",':weight_lifting_man:'=>"\u{1f3cb}",':weight_lifting_woman:'=>"\u{1f3cb}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':western_sahara:'=>"\u{1f1ea}\u{1f1ed}",':whale:'=>"\u{1f433}",':whale2:'=>"\u{1f40b}",':wheel_of_dharma:'=>"\u{2638}\u{fe0f}",':wheelchair:'=>"\u{267f}\u{fe0f}",':white_check_mark:'=>"\u{2705}",':white_circle:'=>"\u{26aa}\u{fe0f}",':white_flag:'=>"\u{1f3f3}\u{fe0f}",':white_flower:'=>"\u{1f4ae}",':white_large_square:'=>"\u{2b1c}\u{fe0f}",':white_medium_small_square:'=>"\u{25fd}\u{fe0f}",':white_medium_square:'=>"\u{25fb}\u{fe0f}",':white_small_square:'=>"\u{25ab}\u{fe0f}",':white_square_button:'=>"\u{1f533}",':white_sun_cloud:'=>"\u{1f325}\u{fe0f}",':white_sun_rain_cloud:'=>"\u{1f326}\u{fe0f}",':white_sun_small_cloud:'=>"\u{1f324}\u{fe0f}",':wilted_flower:'=>"\u{1f940}",':wilted_rose:'=>"\u{1f940}",':wind_blowing_face:'=>"\u{1f32c}\u{fe0f}",':wind_chime:'=>"\u{1f390}",':wind_face:'=>"\u{1f32c}",':wine_glass:'=>"\u{1f377}",':wink:'=>"\u{1f609}",':wolf:'=>"\u{1f43a}",':woman:'=>"\u{1f469}",':woman_artist:'=>"\u{1f469}\u{200d}\u{1f3a8}",':woman_artist_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f3a8}",':woman_artist_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f3a8}",':woman_artist_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f3a8}",':woman_artist_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f3a8}",':woman_artist_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f3a8}",':woman_astronaut:'=>"\u{1f469}\u{200d}\u{1f680}",':woman_astronaut_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f680}",':woman_astronaut_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f680}",':woman_astronaut_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f680}",':woman_astronaut_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f680}",':woman_astronaut_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f680}",':woman_biking:'=>"\u{1f6b4}\u{200d}\u{2640}\u{fe0f}",':woman_biking_tone1:'=>"\u{1f6b4}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_biking_tone2:'=>"\u{1f6b4}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_biking_tone3:'=>"\u{1f6b4}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_biking_tone4:'=>"\u{1f6b4}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_biking_tone5:'=>"\u{1f6b4}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball:'=>"\u{26f9}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball_tone1:'=>"\u{26f9}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball_tone2:'=>"\u{26f9}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball_tone3:'=>"\u{26f9}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball_tone4:'=>"\u{26f9}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_bouncing_ball_tone5:'=>"\u{26f9}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_bowing:'=>"\u{1f647}\u{200d}\u{2640}\u{fe0f}",':woman_bowing_tone1:'=>"\u{1f647}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_bowing_tone2:'=>"\u{1f647}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_bowing_tone3:'=>"\u{1f647}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_bowing_tone4:'=>"\u{1f647}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_bowing_tone5:'=>"\u{1f647}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling:'=>"\u{1f938}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling_tone1:'=>"\u{1f938}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling_tone2:'=>"\u{1f938}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling_tone3:'=>"\u{1f938}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling_tone4:'=>"\u{1f938}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_cartwheeling_tone5:'=>"\u{1f938}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_climbing:'=>"\u{1f9d7}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_climbing_tone1:'=>"\u{1f9d7}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_climbing_tone2:'=>"\u{1f9d7}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_climbing_tone3:'=>"\u{1f9d7}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_climbing_tone4:'=>"\u{1f9d7}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_climbing_tone5:'=>"\u{1f9d7}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker:'=>"\u{1f477}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker_tone1:'=>"\u{1f477}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker_tone2:'=>"\u{1f477}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker_tone3:'=>"\u{1f477}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker_tone4:'=>"\u{1f477}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_construction_worker_tone5:'=>"\u{1f477}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_cook:'=>"\u{1f469}\u{200d}\u{1f373}",':woman_cook_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f373}",':woman_cook_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f373}",':woman_cook_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f373}",':woman_cook_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f373}",':woman_cook_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f373}",':woman_detective:'=>"\u{1f575}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':woman_detective_tone1:'=>"\u{1f575}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_detective_tone2:'=>"\u{1f575}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_detective_tone3:'=>"\u{1f575}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_detective_tone4:'=>"\u{1f575}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_detective_tone5:'=>"\u{1f575}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_elf:'=>"\u{1f9dd}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_elf_tone1:'=>"\u{1f9dd}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_elf_tone2:'=>"\u{1f9dd}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_elf_tone3:'=>"\u{1f9dd}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_elf_tone4:'=>"\u{1f9dd}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_elf_tone5:'=>"\u{1f9dd}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming:'=>"\u{1f926}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming_tone1:'=>"\u{1f926}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming_tone2:'=>"\u{1f926}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming_tone3:'=>"\u{1f926}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming_tone4:'=>"\u{1f926}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_facepalming_tone5:'=>"\u{1f926}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_factory_worker:'=>"\u{1f469}\u{200d}\u{1f3ed}",':woman_factory_worker_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f3ed}",':woman_factory_worker_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f3ed}",':woman_factory_worker_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f3ed}",':woman_factory_worker_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f3ed}",':woman_factory_worker_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f3ed}",':woman_fairy:'=>"\u{1f9da}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_fairy_tone1:'=>"\u{1f9da}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_fairy_tone2:'=>"\u{1f9da}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_fairy_tone3:'=>"\u{1f9da}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_fairy_tone4:'=>"\u{1f9da}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_fairy_tone5:'=>"\u{1f9da}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_farmer:'=>"\u{1f469}\u{200d}\u{1f33e}",':woman_farmer_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f33e}",':woman_farmer_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f33e}",':woman_farmer_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f33e}",':woman_farmer_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f33e}",':woman_farmer_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f33e}",':woman_firefighter:'=>"\u{1f469}\u{200d}\u{1f692}",':woman_firefighter_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f692}",':woman_firefighter_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f692}",':woman_firefighter_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f692}",':woman_firefighter_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f692}",':woman_firefighter_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f692}",':woman_frowning:'=>"\u{1f64d}\u{200d}\u{2640}\u{fe0f}",':woman_frowning_tone1:'=>"\u{1f64d}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_frowning_tone2:'=>"\u{1f64d}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_frowning_tone3:'=>"\u{1f64d}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_frowning_tone4:'=>"\u{1f64d}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_frowning_tone5:'=>"\u{1f64d}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_genie:'=>"\u{1f9de}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no:'=>"\u{1f645}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no_tone1:'=>"\u{1f645}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no_tone2:'=>"\u{1f645}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no_tone3:'=>"\u{1f645}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no_tone4:'=>"\u{1f645}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_no_tone5:'=>"\u{1f645}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok:'=>"\u{1f646}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok_tone1:'=>"\u{1f646}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok_tone2:'=>"\u{1f646}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok_tone3:'=>"\u{1f646}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok_tone4:'=>"\u{1f646}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_gesturing_ok_tone5:'=>"\u{1f646}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage:'=>"\u{1f486}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage_tone1:'=>"\u{1f486}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage_tone2:'=>"\u{1f486}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage_tone3:'=>"\u{1f486}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage_tone4:'=>"\u{1f486}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_getting_face_massage_tone5:'=>"\u{1f486}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut:'=>"\u{1f487}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut_tone1:'=>"\u{1f487}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut_tone2:'=>"\u{1f487}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut_tone3:'=>"\u{1f487}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut_tone4:'=>"\u{1f487}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_getting_haircut_tone5:'=>"\u{1f487}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_golfing:'=>"\u{1f3cc}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_golfing_tone1:'=>"\u{1f3cc}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_golfing_tone2:'=>"\u{1f3cc}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_golfing_tone3:'=>"\u{1f3cc}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_golfing_tone4:'=>"\u{1f3cc}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_golfing_tone5:'=>"\u{1f3cc}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_guard:'=>"\u{1f482}\u{200d}\u{2640}\u{fe0f}",':woman_guard_tone1:'=>"\u{1f482}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_guard_tone2:'=>"\u{1f482}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_guard_tone3:'=>"\u{1f482}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_guard_tone4:'=>"\u{1f482}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_guard_tone5:'=>"\u{1f482}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_health_worker:'=>"\u{1f469}\u{200d}\u{2695}\u{fe0f}",':woman_health_worker_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{2695}\u{fe0f}",':woman_health_worker_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{2695}\u{fe0f}",':woman_health_worker_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{2695}\u{fe0f}",':woman_health_worker_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{2695}\u{fe0f}",':woman_health_worker_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{2695}\u{fe0f}",':woman_in_lotus_position:'=>"\u{1f9d8}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_in_lotus_position_tone1:'=>"\u{1f9d8}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_in_lotus_position_tone2:'=>"\u{1f9d8}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_in_lotus_position_tone3:'=>"\u{1f9d8}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_in_lotus_position_tone4:'=>"\u{1f9d8}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_in_lotus_position_tone5:'=>"\u{1f9d8}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room:'=>"\u{1f9d6}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room_tone1:'=>"\u{1f9d6}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room_tone2:'=>"\u{1f9d6}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room_tone3:'=>"\u{1f9d6}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room_tone4:'=>"\u{1f9d6}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_in_steamy_room_tone5:'=>"\u{1f9d6}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_judge:'=>"\u{1f469}\u{200d}\u{2696}\u{fe0f}",':woman_judge_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{2696}\u{fe0f}",':woman_judge_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{2696}\u{fe0f}",':woman_judge_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{2696}\u{fe0f}",':woman_judge_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{2696}\u{fe0f}",':woman_judge_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{2696}\u{fe0f}",':woman_juggling:'=>"\u{1f939}\u{200d}\u{2640}\u{fe0f}",':woman_juggling_tone1:'=>"\u{1f939}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_juggling_tone2:'=>"\u{1f939}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_juggling_tone3:'=>"\u{1f939}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_juggling_tone4:'=>"\u{1f939}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_juggling_tone5:'=>"\u{1f939}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights:'=>"\u{1f3cb}\u{fe0f}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights_tone1:'=>"\u{1f3cb}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights_tone2:'=>"\u{1f3cb}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights_tone3:'=>"\u{1f3cb}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights_tone4:'=>"\u{1f3cb}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_lifting_weights_tone5:'=>"\u{1f3cb}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_mage:'=>"\u{1f9d9}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_mage_tone1:'=>"\u{1f9d9}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_mage_tone2:'=>"\u{1f9d9}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_mage_tone3:'=>"\u{1f9d9}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_mage_tone4:'=>"\u{1f9d9}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_mage_tone5:'=>"\u{1f9d9}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_mechanic:'=>"\u{1f469}\u{200d}\u{1f527}",':woman_mechanic_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f527}",':woman_mechanic_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f527}",':woman_mechanic_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f527}",':woman_mechanic_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f527}",':woman_mechanic_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f527}",':woman_mountain_biking:'=>"\u{1f6b5}\u{200d}\u{2640}\u{fe0f}",':woman_mountain_biking_tone1:'=>"\u{1f6b5}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_mountain_biking_tone2:'=>"\u{1f6b5}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_mountain_biking_tone3:'=>"\u{1f6b5}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_mountain_biking_tone4:'=>"\u{1f6b5}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_mountain_biking_tone5:'=>"\u{1f6b5}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_office_worker:'=>"\u{1f469}\u{200d}\u{1f4bc}",':woman_office_worker_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f4bc}",':woman_office_worker_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f4bc}",':woman_office_worker_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f4bc}",':woman_office_worker_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f4bc}",':woman_office_worker_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f4bc}",':woman_pilot:'=>"\u{1f469}\u{200d}\u{2708}\u{fe0f}",':woman_pilot_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{2708}\u{fe0f}",':woman_pilot_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{2708}\u{fe0f}",':woman_pilot_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{2708}\u{fe0f}",':woman_pilot_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{2708}\u{fe0f}",':woman_pilot_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{2708}\u{fe0f}",':woman_playing_handball:'=>"\u{1f93e}\u{200d}\u{2640}\u{fe0f}",':woman_playing_handball_tone1:'=>"\u{1f93e}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_playing_handball_tone2:'=>"\u{1f93e}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_playing_handball_tone3:'=>"\u{1f93e}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_playing_handball_tone4:'=>"\u{1f93e}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_playing_handball_tone5:'=>"\u{1f93e}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo:'=>"\u{1f93d}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo_tone1:'=>"\u{1f93d}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo_tone2:'=>"\u{1f93d}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo_tone3:'=>"\u{1f93d}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo_tone4:'=>"\u{1f93d}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_playing_water_polo_tone5:'=>"\u{1f93d}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer:'=>"\u{1f46e}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer_tone1:'=>"\u{1f46e}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer_tone2:'=>"\u{1f46e}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer_tone3:'=>"\u{1f46e}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer_tone4:'=>"\u{1f46e}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_police_officer_tone5:'=>"\u{1f46e}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_pouting:'=>"\u{1f64e}\u{200d}\u{2640}\u{fe0f}",':woman_pouting_tone1:'=>"\u{1f64e}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_pouting_tone2:'=>"\u{1f64e}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_pouting_tone3:'=>"\u{1f64e}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_pouting_tone4:'=>"\u{1f64e}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_pouting_tone5:'=>"\u{1f64e}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand:'=>"\u{1f64b}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand_tone1:'=>"\u{1f64b}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand_tone2:'=>"\u{1f64b}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand_tone3:'=>"\u{1f64b}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand_tone4:'=>"\u{1f64b}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_raising_hand_tone5:'=>"\u{1f64b}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat:'=>"\u{1f6a3}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat_tone1:'=>"\u{1f6a3}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat_tone2:'=>"\u{1f6a3}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat_tone3:'=>"\u{1f6a3}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat_tone4:'=>"\u{1f6a3}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_rowing_boat_tone5:'=>"\u{1f6a3}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_running:'=>"\u{1f3c3}\u{200d}\u{2640}\u{fe0f}",':woman_running_tone1:'=>"\u{1f3c3}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_running_tone2:'=>"\u{1f3c3}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_running_tone3:'=>"\u{1f3c3}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_running_tone4:'=>"\u{1f3c3}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_running_tone5:'=>"\u{1f3c3}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_scientist:'=>"\u{1f469}\u{200d}\u{1f52c}",':woman_scientist_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f52c}",':woman_scientist_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f52c}",':woman_scientist_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f52c}",':woman_scientist_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f52c}",':woman_scientist_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f52c}",':woman_shrugging:'=>"\u{1f937}\u{200d}\u{2640}\u{fe0f}",':woman_shrugging_tone1:'=>"\u{1f937}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_shrugging_tone2:'=>"\u{1f937}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_shrugging_tone3:'=>"\u{1f937}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_shrugging_tone4:'=>"\u{1f937}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_shrugging_tone5:'=>"\u{1f937}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_singer:'=>"\u{1f469}\u{200d}\u{1f3a4}",':woman_singer_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f3a4}",':woman_singer_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f3a4}",':woman_singer_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f3a4}",':woman_singer_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f3a4}",':woman_singer_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f3a4}",':woman_student:'=>"\u{1f469}\u{200d}\u{1f393}",':woman_student_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f393}",':woman_student_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f393}",':woman_student_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f393}",':woman_student_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f393}",':woman_student_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f393}",':woman_surfing:'=>"\u{1f3c4}\u{200d}\u{2640}\u{fe0f}",':woman_surfing_tone1:'=>"\u{1f3c4}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_surfing_tone2:'=>"\u{1f3c4}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_surfing_tone3:'=>"\u{1f3c4}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_surfing_tone4:'=>"\u{1f3c4}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_surfing_tone5:'=>"\u{1f3c4}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_swimming:'=>"\u{1f3ca}\u{200d}\u{2640}\u{fe0f}",':woman_swimming_tone1:'=>"\u{1f3ca}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_swimming_tone2:'=>"\u{1f3ca}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_swimming_tone3:'=>"\u{1f3ca}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_swimming_tone4:'=>"\u{1f3ca}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_swimming_tone5:'=>"\u{1f3ca}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_teacher:'=>"\u{1f469}\u{200d}\u{1f3eb}",':woman_teacher_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f3eb}",':woman_teacher_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f3eb}",':woman_teacher_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f3eb}",':woman_teacher_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f3eb}",':woman_teacher_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f3eb}",':woman_technologist:'=>"\u{1f469}\u{200d}\u{1f4bb}",':woman_technologist_tone1:'=>"\u{1f469}\u{1f3fb}\u{200d}\u{1f4bb}",':woman_technologist_tone2:'=>"\u{1f469}\u{1f3fc}\u{200d}\u{1f4bb}",':woman_technologist_tone3:'=>"\u{1f469}\u{1f3fd}\u{200d}\u{1f4bb}",':woman_technologist_tone4:'=>"\u{1f469}\u{1f3fe}\u{200d}\u{1f4bb}",':woman_technologist_tone5:'=>"\u{1f469}\u{1f3ff}\u{200d}\u{1f4bb}",':woman_tipping_hand:'=>"\u{1f481}\u{200d}\u{2640}\u{fe0f}",':woman_tipping_hand_tone1:'=>"\u{1f481}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_tipping_hand_tone2:'=>"\u{1f481}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_tipping_hand_tone3:'=>"\u{1f481}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_tipping_hand_tone4:'=>"\u{1f481}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_tipping_hand_tone5:'=>"\u{1f481}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_tone1:'=>"\u{1f469}\u{1f3fb}",':woman_tone2:'=>"\u{1f469}\u{1f3fc}",':woman_tone3:'=>"\u{1f469}\u{1f3fd}",':woman_tone4:'=>"\u{1f469}\u{1f3fe}",':woman_tone5:'=>"\u{1f469}\u{1f3ff}",':woman_vampire:'=>"\u{1f9db}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_vampire_tone1:'=>"\u{1f9db}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_vampire_tone2:'=>"\u{1f9db}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_vampire_tone3:'=>"\u{1f9db}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_vampire_tone4:'=>"\u{1f9db}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_vampire_tone5:'=>"\u{1f9db}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_walking:'=>"\u{1f6b6}\u{200d}\u{2640}\u{fe0f}",':woman_walking_tone1:'=>"\u{1f6b6}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_walking_tone2:'=>"\u{1f6b6}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_walking_tone3:'=>"\u{1f6b6}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_walking_tone4:'=>"\u{1f6b6}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_walking_tone5:'=>"\u{1f6b6}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban:'=>"\u{1f473}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban_tone1:'=>"\u{1f473}\u{1f3fb}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban_tone2:'=>"\u{1f473}\u{1f3fc}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban_tone3:'=>"\u{1f473}\u{1f3fd}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban_tone4:'=>"\u{1f473}\u{1f3fe}\u{200d}\u{2640}\u{fe0f}",':woman_wearing_turban_tone5:'=>"\u{1f473}\u{1f3ff}\u{200d}\u{2640}\u{fe0f}",':woman_with_headscarf:'=>"\u{1f9d5}\u{1f3ff}",':woman_with_headscarf_tone1:'=>"\u{1f9d5}\u{1f3fb}",':woman_with_headscarf_tone2:'=>"\u{1f9d5}\u{1f3fc}",':woman_with_headscarf_tone3:'=>"\u{1f9d5}\u{1f3fd}",':woman_with_headscarf_tone4:'=>"\u{1f9d5}\u{1f3fe}",':woman_with_headscarf_tone5:'=>"\u{1f9d5}\u{1f3ff}",':woman_with_turban:'=>"\u{1f473}\u{200d}\u{2640}\u{fe0f}",':woman_zombie:'=>"\u{1f9df}\u{200d}\u{2640}\u{fe0f}",':womans_clothes:'=>"\u{1f45a}",':womans_hat:'=>"\u{1f452}",':women_with_bunny_ears_partying:'=>"\u{1f46f}\u{200d}\u{2640}\u{fe0f}",':women_wrestling:'=>"\u{1f93c}\u{200d}\u{2640}\u{fe0f}",':womens:'=>"\u{1f6ba}",':world_map:'=>"\u{1f5fa}",':worried:'=>"\u{1f61f}",':wrench:'=>"\u{1f527}",':writing_hand:'=>"\u{270d}\u{fe0f}",':writing_hand_tone1:'=>"\u{270d}\u{1f3fb}",':writing_hand_tone2:'=>"\u{270d}\u{1f3fc}",':writing_hand_tone3:'=>"\u{270d}\u{1f3fd}",':writing_hand_tone4:'=>"\u{270d}\u{1f3fe}",':writing_hand_tone5:'=>"\u{270d}\u{1f3ff}",':x:'=>"\u{274c}",':yellow_heart:'=>"\u{1f49b}",':yemen:'=>"\u{1f1fe}\u{1f1ea}",':yen:'=>"\u{1f4b4}",':yin_yang:'=>"\u{262f}\u{fe0f}",':yum:'=>"\u{1f60b}",':zambia:'=>"\u{1f1ff}\u{1f1f2}",':zap:'=>"\u{26a1}\u{fe0f}",':zebra:'=>"\u{1f993}",':zero:'=>"0\u{20e3}",':zimbabwe:'=>"\u{1f1ff}\u{1f1fc}",':zipper_mouth:'=>"\u{1f910}",':zipper_mouth_face:'=>"\u{1f910}",':zombie:'=>"\u{1f9df}",':zzz:'=>"\u{1f4a4}",':100:'=>"\u{1f4af}",':1234:'=>"\u{1f522}"];

	/**
	* @var string Name of the tag used by this plugin
	*/
	protected $tagName = 'EMOJI';

	/**
	* Plugin's setup
	*
	* Will create the tag used by this plugin
	*/
	protected function setUp()
	{
		if (isset($this->configurator->tags[$this->tagName]))
		{
			return;
		}

		$tag = $this->configurator->tags->add($this->tagName);
		foreach (['seq', 'tseq'] as $attrName)
		{
			$tag->attributes->add($attrName)->filterChain->append(
				$this->configurator->attributeFilters['#identifier']
			);
		}
		$tag->template = '<img alt="{.}" class="emoji" draggable="false" src="https://twemoji.maxcdn.com/v/latest/svg/{@tseq}.svg"/>';
	}

	/**
	* {@inheritdoc}
	*/
	public function asConfig()
	{
		$config  = ['tagName'  => $this->tagName];
		$config += $this->getAliasesConfig();

		return $config;
	}

	/**
	* {@inheritdoc}
	*/
	public function finalize()
	{
		$this->configurator->registeredVars['Emoji.aliases'] = new Dictionary($this->aliases);
	}

	/**
	* {@inheritdoc}
	*/
	public function getJSHints()
	{
		$custom     = $this->getCustomAliases();
		$quickMatch = ConfigHelper::generateQuickMatchFromList($custom);

		// NOTE: we don't set a hint to indicate whether shortnames are set in order to be able to
		//       enable them at parsing time, regardless of the original configuration
		return [
			'EMOJI_HAS_CUSTOM_QUICKMATCH' => ($quickMatch !== false),
			'EMOJI_HAS_CUSTOM_REGEXP'     => !empty($custom)
		];
	}

	/**
	* Generate the config options related to aliases
	*
	* @return array
	*/
	protected function getAliasesConfig()
	{
		$config = [];

		// Prepare a regexp for aliases that don't fit the shortname style
		$custom = $this->getCustomAliases();
		if (!empty($custom))
		{
			$regexp = '/' . RegexpBuilder::fromList($custom, ['unicode' => false]) . "(?!\u{FE0E})/";
			$config['customRegexp'] = new Regexp($regexp, true);

			$quickMatch = ConfigHelper::generateQuickMatchFromList($custom);
			if ($quickMatch !== false)
			{
				$config['customQuickMatch'] = $quickMatch;
			}
		}

		return $config;
	}

	/**
	* Get a list of custom aliases (not shortnames)
	*
	* @return string[]
	*/
	protected function getCustomAliases()
	{
		$custom = [];
		foreach ($this->aliases as $alias => $emoji)
		{
			if (!preg_match('(^:[-+_a-z0-9]+:$)D', $alias))
			{
				$custom[] = $alias;
			}
		}

		return $custom;
	}
}