#ifndef OPENRGBPLUGINSFONT_H
#define OPENRGBPLUGINSFONT_H

#include <QFont>
#include <QString>

class OpenRGBPluginsFont
{
public:
    static OpenRGBPluginsFont* Get();

    enum Glyph {
        add_r  = 0xE000,
        add  = 0xE001,
        alarm  = 0xE002,
        arrow_down_o  = 0xE003,
        arrow_down_r  = 0xE004,
        arrow_down  = 0xE005,
        arrow_left_o  = 0xE006,
        arrow_left_r  = 0xE007,
        arrow_left  = 0xE008,
        arrow_right_o  = 0xE009,
        arrow_right_r  = 0xE00A,
        arrow_right  = 0xE00B,
        arrows_exchange_alt  = 0xE00C,
        arrows_exchange_alt_v  = 0xE00D,
        arrows_exchange  = 0xE00E,
        arrows_exchange_v  = 0xE00F,
        arrow_up_o  = 0xE010,
        arrow_up_r  = 0xE011,
        arrow_up  = 0xE012,
        assign  = 0xE013,
        asterisk  = 0xE014,
        backspace  = 0xE015,
        bell  = 0xE016,
        block  = 0xE017,
        board  = 0xE018,
        bookmark  = 0xE019,
        brush  = 0xE01A,
        bulb  = 0xE01B,
        calendar  = 0xE01C,
        carousel  = 0xE01D,
        cast  = 0xE01E,
        check_o  = 0xE01F,
        check_r  = 0xE020,
        check  = 0xE021,
        chevron_double_down_o  = 0xE022,
        chevron_double_down_r  = 0xE023,
        chevron_double_down  = 0xE024,
        chevron_double_left_o  = 0xE025,
        chevron_double_left_r  = 0xE026,
        chevron_double_left  = 0xE027,
        chevron_double_right_o  = 0xE028,
        chevron_double_right_r  = 0xE029,
        chevron_double_right  = 0xE02A,
        chevron_double_up_o  = 0xE02B,
        chevron_double_up_r  = 0xE02C,
        chevron_double_up  = 0xE02D,
        chevron_down_o  = 0xE02E,
        chevron_down_r  = 0xE02F,
        chevron_down  = 0xE030,
        chevron_left_o  = 0xE031,
        chevron_left_r  = 0xE032,
        chevron_left  = 0xE033,
        chevron_right_o  = 0xE034,
        chevron_right_r  = 0xE035,
        chevron_right  = 0xE036,
        chevron_up_o  = 0xE037,
        chevron_up_r  = 0xE038,
        chevron_up  = 0xE039,
        clipboard  = 0xE03A,
        close_o  = 0xE03B,
        close_r  = 0xE03C,
        close  = 0xE03D,
        cloud  = 0xE03E,
        code_climate  = 0xE03F,
        code_slash  = 0xE040,
        code  = 0xE041,
        color_bucket  = 0xE042,
        color_picker  = 0xE043,
        comment  = 0xE044,
        controller  = 0xE045,
        copy  = 0xE046,
        crop  = 0xE047,
        danger  = 0xE048,
        database  = 0xE049,
        data  = 0xE04A,
        debug  = 0xE04B,
        desktop  = 0xE04C,
        disc  = 0xE04D,
        duplicate  = 0xE04E,
        edit_flip_h  = 0xE04F,
        edit_flip_v  = 0xE050,
        eject  = 0xE051,
        enter  = 0xE052,
        erase  = 0xE053,
        ethernet  = 0xE054,
        expand  = 0xE055,
        export_icon  = 0xE056,
        external  = 0xE057,
        eye_alt  = 0xE058,
        eye  = 0xE059,
        file_add  = 0xE05A,
        file_document  = 0xE05B,
        file_remove  = 0xE05C,
        file  = 0xE05D,
        folder_add  = 0xE05E,
        folder_remove  = 0xE05F,
        folder  = 0xE060,
        font_height  = 0xE061,
        hashtag  = 0xE062,
        heart  = 0xE063,
        home_alt  = 0xE064,
        home  = 0xE065,
        image  = 0xE066,
        import  = 0xE067,
        infinity  = 0xE068,
        info  = 0xE069,
        laptop  = 0xE06A,
        link  = 0xE06B,
        list  = 0xE06C,
        loadbar_sound  = 0xE06D,
        lock  = 0xE06E,
        lock_unlock  = 0xE06F,
        math_divide  = 0xE070,
        math_equal  = 0xE071,
        math_minus  = 0xE072,
        math_percent  = 0xE073,
        math_plus  = 0xE074,
        maximize_alt  = 0xE075,
        maximize  = 0xE076,
        menu_boxed  = 0xE077,
        menu_round  = 0xE078,
        menu  = 0xE079,
        minimize_alt  = 0xE07A,
        minimize  = 0xE07B,
        mini_player  = 0xE07C,
        more_alt  = 0xE07D,
        more_o  = 0xE07E,
        more_r  = 0xE07F,
        more  = 0xE080,
        more_vertical_alt  = 0xE081,
        more_vertical_o  = 0xE082,
        more_vertical_r  = 0xE083,
        more_vertical  = 0xE084,
        music_note  = 0xE085,
        music  = 0xE086,
        nametag  = 0xE087,
        notifications  = 0xE088,
        options  = 0xE089,
        path_back  = 0xE08A,
        path_crop  = 0xE08B,
        path_divide  = 0xE08C,
        path_exclude  = 0xE08D,
        path_front  = 0xE08E,
        path_intersect  = 0xE08F,
        path_outline  = 0xE090,
        path_trim  = 0xE091,
        path_unite  = 0xE092,
        pen  = 0xE093,
        performance  = 0xE094,
        play_backwards  = 0xE095,
        play_button_o  = 0xE096,
        play_button_r  = 0xE097,
        play_button  = 0xE098,
        play_forwards  = 0xE099,
        play_list_add  = 0xE09A,
        play_list_check  = 0xE09B,
        play_list_remove  = 0xE09C,
        play_list_search  = 0xE09D,
        play_list  = 0xE09E,
        play_pause_o  = 0xE09F,
        play_pause_r  = 0xE0A0,
        play_pause  = 0xE0A1,
        play_stop_o  = 0xE0A2,
        play_stop_r  = 0xE0A3,
        play_stop  = 0xE0A4,
        play_track_next_o  = 0xE0A5,
        play_track_next_r  = 0xE0A6,
        play_track_next  = 0xE0A7,
        play_track_prev_o  = 0xE0A8,
        play_track_prev_r  = 0xE0A9,
        play_track_prev  = 0xE0AA,
        profile  = 0xE0AB,
        push_chevron_down_o  = 0xE0AC,
        push_chevron_down_r  = 0xE0AD,
        push_chevron_down  = 0xE0AE,
        push_chevron_left_o  = 0xE0AF,
        push_chevron_left_r  = 0xE0B0,
        push_chevron_left  = 0xE0B1,
        push_chevron_right_o  = 0xE0B2,
        push_chevron_right_r  = 0xE0B3,
        push_chevron_right  = 0xE0B4,
        push_chevron_up_o  = 0xE0B5,
        push_chevron_up_r  = 0xE0B6,
        push_chevron_up  = 0xE0B7,
        push_down  = 0xE0B8,
        push_left  = 0xE0B9,
        push_right  = 0xE0BA,
        push_up  = 0xE0BB,
        qr  = 0xE0BC,
        radio_checked  = 0xE0BD,
        radio_check  = 0xE0BE,
        ratio  = 0xE0BF,
        record  = 0xE0C0,
        redo  = 0xE0C1,
        remove_r  = 0xE0C2,
        remove  = 0xE0C3,
        rename  = 0xE0C4,
        repeat  = 0xE0C5,
        screen_mirror  = 0xE0C6,
        screen_shot  = 0xE0C7,
        screen  = 0xE0C8,
        screen_wide  = 0xE0C9,
        search_found  = 0xE0CA,
        search_loading  = 0xE0CB,
        search  = 0xE0CC,
        select_o  = 0xE0CD,
        select_r  = 0xE0CE,
        select  = 0xE0CF,
        shape_circle  = 0xE0D0,
        shape_half_circle  = 0xE0D1,
        shape_hexagon  = 0xE0D2,
        shape_rhombus  = 0xE0D3,
        shape_square  = 0xE0D4,
        shape_triangle  = 0xE0D5,
        shape_zigzag  = 0xE0D6,
        share  = 0xE0D7,
        shield  = 0xE0D8,
        shortcut  = 0xE0D9,
        sidebar_open  = 0xE0DA,
        sidebar_right  = 0xE0DB,
        sidebar  = 0xE0DC,
        software_download  = 0xE0DD,
        software_upload  = 0xE0DE,
        sort_az  = 0xE0DF,
        sort_za  = 0xE0E0,
        square  = 0xE0E1,
        stack  = 0xE0E2,
        stopwatch  = 0xE0E3,
        style  = 0xE0E4,
        sun  = 0xE0E5,
        swap  = 0xE0E6,
        swap_vertical  = 0xE0E7,
        sync  = 0xE0E8,
        tab  = 0xE0E9,
        tag  = 0xE0EA,
        template_icon  = 0xE0EB,
        thermostat  = 0xE0EC,
        timelapse  = 0xE0ED,
        timer  = 0xE0EE,
        time  = 0xE0EF,
        toggle_off  = 0xE0F0,
        toggle_on  = 0xE0F1,
        toggle_square_off  = 0xE0F2,
        toggle_square  = 0xE0F3,
        toolbar_bottom  = 0xE0F4,
        toolbar_left  = 0xE0F5,
        toolbar_right  = 0xE0F6,
        toolbar_top  = 0xE0F7,
        track  = 0xE0F8,
        trash_empty  = 0xE0F9,
        trash  = 0xE0FA,
        tv  = 0xE0FB,
        unavailable  = 0xE0FC,
        undo  = 0xE0FD,
        user  = 0xE0FE,
        volume  = 0xE0FF,
        website  = 0xE100,
        zoom_in  = 0xE101,
        zoom_out  = 0xE102
    };

    static QString icon(int);
    static QFont GetFont();

private:
    OpenRGBPluginsFont();

    static OpenRGBPluginsFont* instance;
    int fontId = -1;
    QFont font;
};
#endif // OPENRGBPLUGINSFONT_H
