"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEmbeddedCode = resolveEmbeddedCode;
exports.createReferenceResolver = createReferenceResolver;
const vscode_uri_1 = require("vscode-uri");
function resolveEmbeddedCode(context, uriStr) {
    const uri = vscode_uri_1.URI.parse(uriStr);
    const decoded = context.decodeEmbeddedDocumentUri(uri);
    if (!decoded) {
        return;
    }
    const sourceScript = context.language.scripts.get(decoded[0]);
    const code = sourceScript.generated.embeddedCodes.get(decoded[1]);
    return {
        script: sourceScript,
        code,
        root: sourceScript.generated.root,
    };
}
function createReferenceResolver(context, resolveReference, resolveModuleName) {
    return async (ref, base) => {
        let uri = vscode_uri_1.URI.parse(base);
        const decoded = context.decodeEmbeddedDocumentUri(uri);
        if (decoded) {
            uri = decoded[0];
        }
        let moduleName;
        if (!ref.startsWith('./') && !ref.startsWith('../')) {
            moduleName = await resolveModuleName(uri.fsPath, ref);
        }
        return moduleName ?? resolveReference(ref, uri, context.env.workspaceFolders);
    };
}
//# sourceMappingURL=utils.js.map