/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.commands;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.wildwebdeveloper.xml.internal.ui.Messages;

public class AssociateGrammarDialog
extends TitleAreaDialog {
    private static final List<String> W3C_GRAMMAR_FILE_EXTENSION = Arrays.asList("xsd", "dtd");
    private static final List<String> RELAXNG_GRAMMAR_FILE_EXTENSION = Arrays.asList("rng", "rnc");
    private static final List<String> ALL_GRAMMAR_FILE_EXTENSION = Stream.concat(W3C_GRAMMAR_FILE_EXTENSION.stream(), RELAXNG_GRAMMAR_FILE_EXTENSION.stream()).toList();
    private final IPath xmlFilePath;
    private final IContainer xmlResourceContainer;
    private Text grammarURIText;
    private ComboViewer bindingTypeViewer;
    private String grammarURI;
    private BindingType bindingType;

    public AssociateGrammarDialog(Shell parentShell, IPath xmlFilePath) {
        super(parentShell);
        this.xmlFilePath = xmlFilePath;
        this.xmlResourceContainer = this.getResourceContainer(xmlFilePath);
    }

    private IContainer getResourceContainer(IPath xmlFilePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(xmlFilePath);
        if (file != null && file.exists()) {
            return file.getProject();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void create() {
        super.create();
        this.setTitle(Messages.AssociateGrammarDialog_title);
        this.validate();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        this.createGrammarURIField(container);
        this.createLastName(container);
        return area;
    }

    private void createGrammarURIField(Composite parent) {
        Label grammarURILabel = new Label(parent, 0);
        grammarURILabel.setText(Messages.AssociateGrammarDialog_grammar_field);
        this.grammarURIText = new Text(parent, 2048);
        this.grammarURIText.addModifyListener(e -> this.validate());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.grammarURIText.setLayoutData((Object)data);
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.Browse_button);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(AssociateGrammarDialog.this.getParentShell(), false, AssociateGrammarDialog.this.xmlResourceContainer, 1);
                dialog.setInitialPattern("*.");
                if (dialog.open() == 0) {
                    IFile selectedFile = (IFile)dialog.getFirstResult();
                    IPath absolutePath = selectedFile.getFullPath().makeRelativeTo(AssociateGrammarDialog.this.xmlFilePath.removeLastSegments(1));
                    AssociateGrammarDialog.this.grammarURIText.setText(absolutePath.toString());
                }
            }
        });
    }

    private void createLastName(Composite parent) {
        Label bindingTypeLabel = new Label(parent, 0);
        bindingTypeLabel.setText(Messages.AssociateGrammarDialog_bindingType_field);
        this.bindingTypeViewer = new ComboViewer(parent);
        this.bindingTypeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.bindingTypeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof BindingType) {
                    BindingType bindingType = (BindingType)((Object)element);
                    return bindingType.getLabel();
                }
                return super.getText(element);
            }
        });
        this.bindingTypeViewer.addSelectionChangedListener(e -> this.validate());
        GridData daya = new GridData();
        daya.grabExcessHorizontalSpace = true;
        daya.horizontalAlignment = 4;
        daya.horizontalSpan = 2;
        this.bindingTypeViewer.getCombo().setLayoutData((Object)daya);
        this.bindingTypeViewer.setInput((Object)BindingType.values());
        this.bindingTypeViewer.setSelection((ISelection)new StructuredSelection((Object)BindingType.standard));
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.grammarURI = this.grammarURIText.getText();
        this.bindingType = (BindingType)((Object)this.bindingTypeViewer.getStructuredSelection().getFirstElement());
    }

    private void validate() {
        IStatus status = this.performValidation();
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                break;
            }
            default: {
                this.setErrorMessage(null);
                if (status.isOK()) {
                    this.setMessage("");
                    break;
                }
                this.setMessage(status.getMessage(), AssociateGrammarDialog.getMessageType(status.getSeverity()));
            }
        }
    }

    private IStatus performValidation() {
        String grammarURI = this.grammarURIText.getText();
        if (grammarURI.isBlank()) {
            return Status.error((String)Messages.AssociateGrammarDialog_validation_grammar_file_required);
        }
        IFile file = this.xmlResourceContainer.getFile((IPath)new Path(grammarURI));
        if (file == null || !file.exists()) {
            return Status.warning((String)Messages.bind((String)Messages.AssociateGrammarDialog_validation_grammar_file_notExists, (Object)grammarURI));
        }
        if (AssociateGrammarDialog.isRelaxNGGrammarFile(file.getFileExtension())) {
            BindingType bindingType = (BindingType)((Object)this.bindingTypeViewer.getStructuredSelection().getFirstElement());
            if (bindingType == BindingType.standard) {
                return Status.error((String)Messages.bind((String)Messages.AssociateGrammarDialog_validation_grammar_file_invalid_association_for_relaxng, (Object)grammarURI, (Object)BindingType.standard.getLabel()));
            }
            return Status.OK_STATUS;
        }
        if (!AssociateGrammarDialog.isStandardGramarFile(file.getFileExtension())) {
            return Status.warning((String)Messages.bind((String)Messages.AssociateGrammarDialog_validation_grammar_file_invalid_fileExtension, (Object)grammarURI, (Object)ALL_GRAMMAR_FILE_EXTENSION.stream().collect(Collectors.joining(", "))));
        }
        return Status.OK_STATUS;
    }

    private static int getMessageType(int severity) {
        switch (severity) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private static boolean isStandardGramarFile(String fileExtension) {
        return W3C_GRAMMAR_FILE_EXTENSION.contains(fileExtension);
    }

    private static boolean isRelaxNGGrammarFile(String fileExtension) {
        return RELAXNG_GRAMMAR_FILE_EXTENSION.contains(fileExtension);
    }

    public String getGrammarURI() {
        return this.grammarURI;
    }

    public BindingType getBindingType() {
        return this.bindingType;
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public static enum BindingType {
        standard("standard", "Standard (xsi, DOCTYPE)"),
        xmlmodel("xml-model", "XML Model association");

        private final String code;
        private final String label;

        private BindingType(String code, String label) {
            this.code = code;
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

