"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const common_1 = require("../utils/common");
const featureWorkers_1 = require("../utils/featureWorkers");
const cancellation_1 = require("../utils/cancellation");
const transform_1 = require("../utils/transform");
const language_core_1 = require("@volar/language-core");
function register(context) {
    return async (uri, range, token = cancellation_1.NoneCancellationToken) => {
        const sourceScript = context.language.scripts.get(uri);
        if (!sourceScript) {
            return;
        }
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, () => range, function* (map) {
            const mapped = (0, common_1.findOverlapCodeRange)(map.sourceDocument.offsetAt(range.start), map.sourceDocument.offsetAt(range.end), map.map, language_core_1.isInlayHintsEnabled);
            if (mapped) {
                yield {
                    start: map.embeddedDocument.positionAt(mapped.start),
                    end: map.embeddedDocument.positionAt(mapped.end),
                };
            }
        }, async (service, document, arg) => {
            if (token.isCancellationRequested) {
                return;
            }
            const hints = await service[1].provideInlayHints?.(document, arg, token);
            hints?.forEach(link => {
                link.data = {
                    uri,
                    original: {
                        data: link.data,
                    },
                    serviceIndex: context.services.indexOf(service),
                };
            });
            return hints;
        }, (inlayHints, map) => {
            if (!map) {
                return inlayHints;
            }
            return inlayHints
                .map((_inlayHint) => {
                const position = map.getSourcePosition(_inlayHint.position, language_core_1.isInlayHintsEnabled);
                const edits = _inlayHint.textEdits
                    ?.map(textEdit => (0, transform_1.transformTextEdit)(textEdit, range => map.getSourceRange(range), map.embeddedDocument))
                    .filter(common_1.notEmpty);
                if (position) {
                    return {
                        ..._inlayHint,
                        position,
                        textEdits: edits,
                    };
                }
            })
                .filter(common_1.notEmpty);
        }, arr => arr.flat());
    };
}
exports.register = register;
//# sourceMappingURL=provideInlayHints.js.map