/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Element;

public class StyleHelper {
    private static final String PLATFORM_THEME_PREFIX = "org.eclipse.e4.ui.css.theme.";
    private Widget widget;
    private static String latestThemeId;
    private static List<String> latestThemeVariants;

    public StyleHelper on(Widget widget) {
        this.widget = widget;
        return this;
    }

    public StyleHelper setClasses(String ... cssClasses) {
        return this.setClass(String.join((CharSequence)" ", cssClasses));
    }

    public StyleHelper setClass(String cssClass) {
        WidgetElement.setCSSClass((Widget)this.widget, (String)cssClass);
        return this;
    }

    public StyleHelper addClass(String cssClass) {
        String classes = this.getWidgetClasses();
        this.setClass(classes == null ? cssClass : String.valueOf(classes) + " " + cssClass);
        return this;
    }

    public StyleHelper addClasses(String ... cssClasses) {
        return this.addClass(String.join((CharSequence)" ", cssClasses));
    }

    private String getWidgetClasses() {
        return WidgetElement.getCSSClass((Widget)this.widget);
    }

    public StyleHelper setId(String id) {
        WidgetElement.setID((Widget)this.widget, (String)id);
        return this;
    }

    private CSSEngine getCSSEngine() {
        return WidgetElement.getEngine((Widget)this.widget);
    }

    public Element getElement() {
        CSSEngine cssEngine = this.getCSSEngine();
        return cssEngine == null ? null : cssEngine.getElement((Object)this.widget);
    }

    private ITheme getCurrentTheme() {
        BundleContext bundleContext = FrameworkUtil.getBundle(StyleHelper.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IThemeManager.class);
        try {
            IThemeManager themeManager = (IThemeManager)bundleContext.getService(serviceReference);
            IThemeEngine engineForDisplay = themeManager == null ? null : themeManager.getEngineForDisplay(this.widget.getDisplay());
            ITheme iTheme = engineForDisplay == null ? null : engineForDisplay.getActiveTheme();
            return iTheme;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    private List<String> listThemeVariants(ITheme theme) {
        Theme internalTheme;
        String osVersion;
        String variantBaseId;
        ArrayList<String> themeVariants = new ArrayList<String>(2);
        if (theme == null) {
            return themeVariants;
        }
        String themeId = theme.getId();
        if (themeId.equals(latestThemeId)) {
            return latestThemeVariants;
        }
        String themeBaseId = themeId;
        themeVariants.add(themeId);
        int variantPos = themeId.lastIndexOf(95);
        if (variantPos == -1) {
            variantPos = themeId.lastIndexOf(45);
        }
        if (variantPos != -1 && this.getTheme(variantBaseId = themeId.substring(0, variantPos)) != null) {
            themeBaseId = variantBaseId;
            themeVariants.add(themeBaseId);
        }
        if (theme instanceof Theme && (osVersion = (internalTheme = (Theme)theme).getOsVersion()) != null && themeBaseId.endsWith(osVersion)) {
            themeBaseId = themeBaseId.substring(0, themeBaseId.length() - osVersion.length());
            themeVariants.add(themeBaseId);
        }
        latestThemeId = themeId;
        latestThemeVariants = themeVariants;
        return themeVariants;
    }

    private ITheme getTheme(String themeId) {
        BundleContext bundleContext = FrameworkUtil.getBundle(StyleHelper.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IThemeManager.class);
        try {
            IThemeEngine engineForDisplay;
            IThemeManager themeManager = (IThemeManager)bundleContext.getService(serviceReference);
            IThemeEngine iThemeEngine = engineForDisplay = themeManager == null ? null : themeManager.getEngineForDisplay(this.widget.getDisplay());
            if (engineForDisplay == null) {
                return null;
            }
            List themes = engineForDisplay.getThemes();
            for (ITheme theme : themes) {
                if (!themeId.equals(theme.getId())) continue;
                ITheme iTheme = theme;
                return iTheme;
            }
            return null;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public String getCurrentThemeId() {
        ITheme theme = this.getCurrentTheme();
        return theme == null ? null : theme.getId();
    }

    public URL getStylesheet(String theme, String path) {
        String simpleTheme = theme;
        if (theme != null && theme.startsWith(PLATFORM_THEME_PREFIX)) {
            simpleTheme = theme.substring(PLATFORM_THEME_PREFIX.length());
        }
        return FrameworkUtil.getBundle(StyleHelper.class).getEntry("/css/" + (simpleTheme == null ? "default" : simpleTheme) + "/" + path);
    }

    private URL getStylesheet(ITheme theme, String path) {
        for (String themeId : this.listThemeVariants(theme)) {
            URL cssUrl = this.getStylesheet(themeId, path);
            if (cssUrl == null) continue;
            return cssUrl;
        }
        return this.getStylesheet((String)null, path);
    }

    public URL getCurrentThemeStylesheet(String path) {
        return this.getStylesheet(this.getCurrentTheme(), path);
    }

    public StyleHelper applyStyles() {
        CSSEngine cssEngine = this.getCSSEngine();
        if (cssEngine != null) {
            cssEngine.applyStyles((Object)this.widget, true);
        }
        return this;
    }
}

