/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Nullable;

public interface IGrammarSource {
    private static ContentType guessFileFormat(String fileName) {
        String extension;
        return switch (extension = fileName.substring(fileName.lastIndexOf(46) + 1).trim().toLowerCase()) {
            case "json" -> ContentType.JSON;
            case "yml", "yaml", "yaml-tmlanguage" -> ContentType.YAML;
            case "xml", "plist", "tmlanguage" -> ContentType.XML;
            default -> throw new IllegalArgumentException("Unsupported file type: " + fileName);
        };
    }

    public static IGrammarSource fromFile(Path file) {
        return IGrammarSource.fromFile(file, null, null);
    }

    public static IGrammarSource fromFile(final Path file, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final String filePath = file.toString();
        final ContentType contentType1 = contentType == null ? IGrammarSource.guessFileFormat(filePath) : contentType;
        return new IGrammarSource(){

            @Override
            public Reader getReader() throws IOException {
                return Files.newBufferedReader(file, charset == null ? StandardCharsets.UTF_8 : charset);
            }

            @Override
            public String getFilePath() {
                return filePath;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }
        };
    }

    public static IGrammarSource fromResource(Class<?> clazz, String resourceName) {
        return IGrammarSource.fromResource(clazz, resourceName, null, null);
    }

    public static IGrammarSource fromResource(final Class<?> clazz, final String resourceName, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final ContentType contentType1 = contentType == null ? IGrammarSource.guessFileFormat(resourceName) : contentType;
        return new IGrammarSource(){

            @Override
            public Reader getReader() throws IOException {
                return new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(resourceName), charset == null ? StandardCharsets.UTF_8 : charset));
            }

            @Override
            public String getFilePath() {
                return resourceName;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }
        };
    }

    public static IGrammarSource fromString(final ContentType contentType, final String content) {
        return new IGrammarSource(){

            @Override
            public Reader getReader() throws IOException {
                return new StringReader(content);
            }

            @Override
            public String getFilePath() {
                return "string." + contentType.name().toLowerCase();
            }

            @Override
            public ContentType getContentType() {
                return contentType;
            }
        };
    }

    default public ContentType getContentType() {
        return IGrammarSource.guessFileFormat(this.getFilePath());
    }

    public String getFilePath();

    public Reader getReader() throws IOException;

    public static enum ContentType {
        JSON,
        YAML,
        XML;

    }
}

