/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.RemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystemConfiguration;
import org.eclipse.rse.ui.SystemBasePlugin;

public final class ShellServiceSubSystem
extends RemoteCmdSubSystem
implements IShellServiceSubSystem {
    protected String _userHome = null;
    protected IShellService _hostService;
    static /* synthetic */ Class class$0;

    public ShellServiceSubSystem(IHost host, IConnectorService connectorService, IShellService hostService) {
        super(host, connectorService);
        this._hostService = hostService;
    }

    public IShellService getShellService() {
        return this._hostService;
    }

    public void setShellService(IShellService service) {
        this._hostService = service;
    }

    protected String getUserHome() {
        if (this._userHome == null) {
            IRSESystemType type = this.getHost().getSystemType();
            this._userHome = type.isLocal() ? System.getProperty("user.home") : (type.isWindows() ? "c:\\" : "/home/" + this.getUserId());
        }
        return this._userHome;
    }

    protected Object[] internalRunCommand(String cmd, Object context, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return this.internalRunCommand(cmd, context, false, monitor);
    }

    protected Object[] internalRunCommand(String cmd, Object context, boolean interpretOutput, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        String cwd = "";
        if (context instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)context;
            cwd = file.getAbsolutePath();
        } else if (context instanceof String) {
            cwd = (String)context;
        }
        if (cwd == null || cwd.equals("null")) {
            cwd = this.getUserHome();
        }
        IShellService service = this.getShellService();
        IHostShell hostShell = service.runCommand(cwd, cmd, this.getUserAndHostEnvVarsAsStringArray(), monitor);
        IServiceCommandShell cmdShell = this.createRemoteCommandShell(this, hostShell);
        hostShell.addOutputListener((IHostShellOutputListener)cmdShell);
        if (this._cmdShells.size() == 0) {
            this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
        }
        this._cmdShells.add(cmdShell);
        return new Object[]{cmdShell};
    }

    protected IRemoteCommandShell internalRunShell(Object context, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        String encoding;
        IShellService service;
        IHostShell hostShell;
        IServiceCommandShell cmdShell;
        String cwd = "";
        if (context instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)context;
            cwd = file.getAbsolutePath();
        } else if (context instanceof String) {
            cwd = (String)context;
        }
        if (cwd == null || cwd.equals("null")) {
            cwd = this.getUserHome();
        }
        if ((cmdShell = this.createRemoteCommandShell(this, hostShell = (service = this.getShellService()).launchShell(cwd, encoding = this.getHost().getDefaultEncoding(true), this.getUserAndHostEnvVarsAsStringArray(), monitor))) != null) {
            hostShell.addOutputListener((IHostShellOutputListener)cmdShell);
            if (this._cmdShells.size() == 0) {
                this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
            }
            this._cmdShells.add(cmdShell);
        }
        return cmdShell;
    }

    protected void internalCancelShell(Object command, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (command instanceof IServiceCommandShell) {
            IServiceCommandShell cmd = (IServiceCommandShell)command;
            cmd.getHostShell().exit();
        }
    }

    protected void internalSendCommandToShell(String cmd, Object command, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (command instanceof IServiceCommandShell) {
            IServiceCommandShell cmdWrapper = (IServiceCommandShell)command;
            cmdWrapper.writeToShell(cmd);
            cmdWrapper.updateHistory(cmd);
        }
    }

    protected IServiceCommandShell createRemoteCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        IShellServiceSubSystemConfiguration config = (IShellServiceSubSystemConfiguration)this.getParentRemoteCmdSubSystemConfiguration();
        return config.createRemoteCommandShell(cmdSS, hostShell);
    }

    public String[] getHostEnvironment() {
        try {
            return this.getShellService().getHostEnvironment();
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)e.getSystemMessage().getLevelOneText(), (Throwable)e);
            return new String[0];
        }
    }

    public List getHostEnvironmentVariables() {
        ArrayList<String> l = new ArrayList<String>();
        String[] vars = this.getHostEnvironment();
        int i = 0;
        while (i < vars.length) {
            l.add(vars[i]);
            ++i;
        }
        return l;
    }

    public boolean canSwitchTo(ISubSystemConfiguration configuration) {
        return configuration instanceof IShellServiceSubSystemConfiguration;
    }

    protected void internalSwitchSubSystemConfiguration(ISubSystemConfiguration newConfiguration) {
        IShellServiceSubSystemConfiguration configuration = (IShellServiceSubSystemConfiguration)newConfiguration;
        IHost host = this.getHost();
        this.setShellService(configuration.getShellService(host));
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.shells.IShellService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this.getShellService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.cancelAllShells();
        this.getShellService().uninitService(monitor);
        super.uninitializeSubSystem(monitor);
    }
}

