/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.CaptureTreeNode;

public final class Region {
    static final int REGION_NOTPOS = -1;
    @Deprecated
    public final int numRegs;
    @Deprecated
    public final int[] beg;
    @Deprecated
    public final int[] end;
    @Deprecated
    public CaptureTreeNode historyRoot;

    public static Region newRegion(int num) {
        return new Region(num);
    }

    public static Region newRegion(int begin, int end) {
        return new Region(begin, end);
    }

    @Deprecated
    public Region(int num) {
        this.numRegs = num;
        this.beg = new int[num];
        this.end = new int[num];
    }

    @Deprecated
    public Region(int begin, int end) {
        this.numRegs = 1;
        this.beg = new int[]{begin};
        this.end = new int[]{end};
    }

    public Region clone() {
        Region region = new Region(this.numRegs);
        System.arraycopy(this.beg, 0, region.beg, 0, this.beg.length);
        System.arraycopy(this.end, 0, region.end, 0, this.end.length);
        if (this.historyRoot != null) {
            region.historyRoot = this.historyRoot.cloneTree();
        }
        return region;
    }

    public int getNumRegs() {
        return this.numRegs;
    }

    public int getBeg(int index) {
        return this.beg[index];
    }

    public int setBeg(int index, int value) {
        this.beg[index] = value;
        return this.beg[index];
    }

    public int getEnd(int index) {
        return this.end[index];
    }

    public int setEnd(int index, int value) {
        this.end[index] = value;
        return this.end[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Region: \n");
        for (int i = 0; i < this.beg.length; ++i) {
            sb.append(" " + i + ": (" + this.beg[i] + "-" + this.end[i] + ")");
        }
        return sb.toString();
    }

    CaptureTreeNode getCaptureTree() {
        return this.historyRoot;
    }

    CaptureTreeNode setCaptureTree(CaptureTreeNode ctn) {
        this.historyRoot = ctn;
        return this.historyRoot;
    }

    void clear() {
        for (int i = 0; i < this.beg.length; ++i) {
            this.end[i] = -1;
            this.beg[i] = -1;
        }
    }
}

