/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;

public final class MoreCollections {
    @SafeVarargs
    public static <T> List<T> asArrayList(T ... items) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, items);
        return list;
    }

    public static <T> List<T> asArrayList(T firstItem, List<T> moreItems) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(firstItem);
        list.addAll(moreItems);
        return list;
    }

    public static <T> @Nullable T findFirstMatching(List<T> list, Predicate<T> filter) {
        for (T e : list) {
            if (!filter.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <T> @Nullable T findLastElement(@Nullable List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return MoreCollections.getLastElement(list);
    }

    public static <T> T getLastElement(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T removeLastElement(List<T> list) {
        return list.remove(list.size() - 1);
    }

    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private MoreCollections() {
    }
}

