/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import org.eclipse.epp.internal.mpc.ui.MarketplaceClientDebug;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.urischeme.IUriSchemeHandler;

public class MarketplaceUriSchemeHandler
implements IUriSchemeHandler {
    public static final String ECLIPSE_MPC_SCHEME = "eclipse+mpc";
    private final MarketplaceUrlHandler urlHandler = new MarketplaceUrlHandler(){

        @Override
        protected boolean handleInstallRequest(MarketplaceUrlHandler.SolutionInstallationInfo installInfo, String url) {
            return 1.triggerInstall(installInfo);
        }

        @Override
        protected boolean handleImportFavoritesRequest(MarketplaceUrlHandler.FavoritesDescriptor descriptor) {
            return 1.triggerFavoritesImport(descriptor);
        }
    };

    public void handle(String mpcUri) {
        Display display = Display.getDefault();
        if (this.accept(mpcUri)) {
            display.asyncExec(() -> this.proceed(mpcUri));
        } else {
            this.traceInvalidUrl(mpcUri);
        }
    }

    private boolean accept(String mpcUri) {
        return MarketplaceUrlHandler.isPotentialSolution(mpcUri) || MarketplaceUrlHandler.isPotentialFavoritesList(mpcUri);
    }

    private void proceed(String mpcUri) {
        this.urlHandler.handleUri(mpcUri);
    }

    private void traceInvalidUrl(String url) {
        if (MarketplaceClientDebug.DEBUG) {
            MarketplaceClientDebug.trace("/debug/dnd", "URL handler: Data is not a solution url: {0}", url, new Throwable());
        }
    }
}

