/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.variants;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;

public abstract class ThreeWayRemoteTree
extends ResourceVariantTree {
    private ThreeWaySubscriber subscriber;

    public ThreeWayRemoteTree(ThreeWaySubscriber subscriber) {
        super(new RemoteResourceVariantByteStore(subscriber.getSynchronizer()));
        this.subscriber = subscriber;
    }

    @Override
    public IResource[] roots() {
        return this.getSubscriber().roots();
    }

    @Override
    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        return this.getSubscriber().getResourceVariant(resource, this.getByteStore().getBytes(resource));
    }

    protected ThreeWaySubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    protected IResource[] collectChanges(IResource local, IResourceVariant remote, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[][] resources = new IResource[1][];
        this.getSubscriber().getSynchronizer().run(local, monitor1 -> {
            IResource[] iResourceArray2 = ThreeWayRemoteTree.super.collectChanges(local, remote, depth, monitor1);
        }, monitor);
        return resources[0];
    }

    static class RemoteResourceVariantByteStore
    extends ResourceVariantByteStore {
        private ThreeWaySynchronizer synchronizer;

        public RemoteResourceVariantByteStore(ThreeWaySynchronizer synchronizer) {
            this.synchronizer = synchronizer;
        }

        @Override
        public void dispose() {
        }

        @Override
        public byte[] getBytes(IResource resource) throws TeamException {
            return this.getSynchronizer().getRemoteBytes(resource);
        }

        @Override
        public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
            return this.getSynchronizer().setRemoteBytes(resource, bytes);
        }

        @Override
        public boolean flushBytes(IResource resource, int depth) throws TeamException {
            return false;
        }

        public boolean isVariantKnown(IResource resource) throws TeamException {
            return this.getSynchronizer().hasSyncBytes(resource);
        }

        @Override
        public boolean deleteBytes(IResource resource) throws TeamException {
            return this.getSynchronizer().removeRemoteBytes(resource);
        }

        @Override
        public IResource[] members(IResource resource) throws TeamException {
            return this.synchronizer.members(resource);
        }

        private ThreeWaySynchronizer getSynchronizer() {
            return this.synchronizer;
        }
    }
}

