/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class LSPRenameProcessor
extends RefactoringProcessor {
    private static final String ID = "org.eclipse.lsp4e.operations.rename";
    private final @NonNull IDocument document;
    private final int offset;
    private LanguageServerWrapper refactoringServer;
    private String newName;
    private WorkspaceEdit rename;
    private Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior> prepareRenameResult;

    public LSPRenameProcessor(@NonNull IDocument document, int offset) {
        this.document = document;
        this.offset = offset;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ID;
    }

    public String getProcessorName() {
        return Messages.rename_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.document);
            PrepareRenameParams params = new PrepareRenameParams();
            params.setTextDocument(identifier);
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            Optional<Pair> tmp = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withFilter(LSPRenameProcessor::isPrepareRenameProvider)).computeFirst((w, ls) -> ls.getTextDocumentService().prepareRename(params).thenApply(result -> new Pair<LanguageServerWrapper, Either3>((LanguageServerWrapper)w, (Either3)result))).get(1000L, TimeUnit.MILLISECONDS);
            if (tmp.isEmpty() || ((Pair)tmp.get()).getSecond() == null) {
                status.addFatalError(Messages.rename_invalidated);
            } else {
                tmp.ifPresent(p -> {
                    this.refactoringServer = (LanguageServerWrapper)p.getFirst();
                    this.prepareRenameResult = (Either3)p.getSecond();
                });
            }
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not prepare rename due to timeout after 1 seconds in `textDocument/prepareRename`. 'newName' will be used", e);
        }
        catch (Exception e) {
            status.addFatalError(this.getErrorMessage(e));
        }
        return status;
    }

    public String getPlaceholder() {
        @Nullable String placeholder = null;
        if (this.prepareRenameResult != null) {
            placeholder = (String)this.prepareRenameResult.map(range -> {
                try {
                    int startOffset = LSPEclipseUtils.toOffset(range.getStart(), this.document);
                    int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), this.document);
                    return this.document.get(startOffset, endOffset - startOffset);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                    return null;
                }
            }, PrepareRenameResult::getPlaceholder, options -> null);
        }
        return placeholder != null && !placeholder.isBlank() ? placeholder : "newName";
    }

    public static boolean isPrepareRenameProvider(ServerCapabilities serverCapabilities) {
        if (serverCapabilities == null) {
            return false;
        }
        Either renameProvider = serverCapabilities.getRenameProvider();
        if (renameProvider == null) {
            return false;
        }
        if (renameProvider.isRight()) {
            return renameProvider.getRight() != null && ((RenameOptions)renameProvider.getRight()).getPrepareProvider() != false;
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(this.document);
            identifier.setUri(LSPEclipseUtils.toUri(this.document).toString());
            params.setTextDocument(identifier);
            params.setNewName(this.newName);
            if (params.getNewName() != null && this.refactoringServer != null) {
                this.rename = this.refactoringServer != null ? (WorkspaceEdit)this.refactoringServer.execute(ls -> ls.getTextDocumentService().rename(params)).get(1000L, TimeUnit.MILLISECONDS) : (WorkspaceEdit)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withCapability(ServerCapabilities::getRenameProvider)).computeFirst(ls -> ls.getTextDocumentService().rename(params)).get(1000L, TimeUnit.MILLISECONDS).orElse(null);
                if (!status.hasError() && (this.rename == null || this.rename.getChanges().isEmpty() && this.rename.getDocumentChanges().isEmpty())) {
                    status.addWarning(Messages.rename_empty_message);
                }
            }
        }
        catch (Exception e) {
            status.addFatalError(this.getErrorMessage(e));
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    private String getErrorMessage(Throwable e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof ResponseErrorException) {
            String string;
            void responseErrorException;
            ResponseErrorException responseErrorException2 = (ResponseErrorException)throwable;
            ResponseErrorException cfr_ignored_0 = (ResponseErrorException)throwable;
            ResponseError responseError = responseErrorException.getResponseError();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(responseError.getMessage()));
            Object object = responseError.getData();
            if (object instanceof String) {
                void data;
                String string2 = (String)object;
                String cfr_ignored_1 = (String)object;
                string = ": " + (String)data;
            } else {
                string = "";
            }
            return stringBuilder.append(string).toString();
        }
        return e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", Messages.rename_processor_required));
        }
        return LSPEclipseUtils.toCompositeChange(this.rename, Messages.rename_title);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }
}

