/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.search.IHostSearchResult;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchHandler;

public class RemoteSearchResultConfiguration
implements IHostSearchResultConfiguration {
    protected IHostSearchResultSet parentResultSet;
    protected Object searchTarget;
    protected SystemSearchString searchString;
    protected Vector results = new Vector();
    protected int status;
    protected Map _containedResults;
    protected ISearchHandler _searchHandler;

    public RemoteSearchResultConfiguration(IHostSearchResultSet resultSet, Object searchObject, SystemSearchString string) {
        this.setParentResultSet(resultSet);
        this.setSearchTarget(searchObject);
        this.setSearchString(string);
        this.setStatus(0);
        this._containedResults = new HashMap();
    }

    public void setParentResultSet(IHostSearchResultSet resultSet) {
        this.parentResultSet = resultSet;
    }

    public IHostSearchResultSet getParentResultSet() {
        return this.parentResultSet;
    }

    public void setSearchTarget(Object searchObject) {
        this.searchTarget = searchObject;
    }

    public Object getSearchTarget() {
        return this.searchTarget;
    }

    public void setSearchString(SystemSearchString string) {
        this.searchString = string;
    }

    public SystemSearchString getSearchString() {
        return this.searchString;
    }

    public void addResult(Object result) {
        this.results.add(result);
    }

    public void removeResult(Object result) {
        this.results.remove(result);
    }

    public void removeAndAddResult(Object oldResult, Object newResult) {
        this.results.remove(oldResult);
        this.results.add(newResult);
    }

    public Object[] getResults() {
        return this.results.toArray();
    }

    public IHostSearchResult[] getContainedResults(Object resultContainer) {
        return (IHostSearchResult[])this._containedResults.get(resultContainer);
    }

    public int getResultsSize() {
        return this.results.size();
    }

    public void removeResults() {
        this.results.removeAllElements();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void cancel() {
        if (this.getStatus() != 0) {
            return;
        }
    }

    public void dispose() {
        this.cancel();
        this.removeResults();
    }

    public void addResults(Object container, IHostSearchResult[] results) {
        this.addResult(container);
        this._containedResults.put(container, results);
    }

    public void setSearchHandler(ISearchHandler handler) {
        this._searchHandler = handler;
    }

    public ISearchHandler getSearchHandler() {
        return this._searchHandler;
    }
}

