/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.open;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.ui.open.SystemQuickOpenPageDescriptor;

public class SystemQuickOpenUtil {
    public static final String QUICK_OPEN_PAGE_EXTENSION_POINT = "quickOpenPages";
    private static SystemQuickOpenUtil instance;
    private List pageDescriptors;

    private SystemQuickOpenUtil() {
    }

    public static SystemQuickOpenUtil getInstance() {
        if (instance == null) {
            instance = new SystemQuickOpenUtil();
        }
        return instance;
    }

    public List getQuickOpenPageDescriptors(String pageId) {
        Iterator iter = this.getQuickOpenPageDescriptors().iterator();
        ArrayList<SystemQuickOpenPageDescriptor> enabledDescriptors = new ArrayList<SystemQuickOpenPageDescriptor>();
        while (iter.hasNext()) {
            SystemQuickOpenPageDescriptor desc = (SystemQuickOpenPageDescriptor)iter.next();
            if (!desc.isEnabled() && !desc.getId().equals(pageId)) continue;
            enabledDescriptors.add(desc);
        }
        return enabledDescriptors;
    }

    public List getQuickOpenPageDescriptors() {
        if (this.pageDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.rse.ui", QUICK_OPEN_PAGE_EXTENSION_POINT);
            this.pageDescriptors = this.createQuickOpenPageDescriptors(elements);
        }
        return this.pageDescriptors;
    }

    private List createQuickOpenPageDescriptors(IConfigurationElement[] elements) {
        ArrayList<SystemQuickOpenPageDescriptor> result = new ArrayList<SystemQuickOpenPageDescriptor>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("page".equals(element.getName())) {
                SystemQuickOpenPageDescriptor desc = new SystemQuickOpenPageDescriptor(element);
                result.add(desc);
            }
            ++i;
        }
        Collections.sort(result);
        return result;
    }
}

