import { DebugProtocol } from 'vscode-debugprotocol';
import { ChromeDebugSession } from '../chrome/chromeDebugSession';
import { IDebugTransformer, ISetBreakpointsResponseBody, IStackTraceResponseBody, IScopesResponseBody } from '../debugAdapterInterfaces';
/**
 * Converts from 1 based lines/cols on the client side to 0 based lines/cols on the target side
 */
export declare class LineColTransformer implements IDebugTransformer {
    private _session;
    columnBreakpointsEnabled: boolean;
    constructor(_session: ChromeDebugSession);
    setBreakpoints(args: DebugProtocol.SetBreakpointsArguments): DebugProtocol.SetBreakpointsArguments;
    setBreakpointsResponse(response: ISetBreakpointsResponseBody): void;
    stackTraceResponse(response: IStackTraceResponseBody): void;
    breakpointResolved(bp: DebugProtocol.Breakpoint): void;
    scopeResponse(scopeResponse: IScopesResponseBody): void;
    mappedExceptionStack(location: {
        line: number;
        column: number;
    }): void;
    private mapScopeLocations(scope);
    convertClientLocationToDebugger(location: {
        line?: number;
        column?: number;
    }): void;
    convertDebuggerLocationToClient(location: {
        line?: number;
        column?: number;
    }): void;
    convertClientLineToDebugger(line: number): number;
    convertDebuggerLineToClient(line: number): number;
    convertClientColumnToDebugger(column: number): number;
    convertDebuggerColumnToClient(column: number): number;
}
