/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.internal.types.IRawRepository;
import org.eclipse.tm4e.core.internal.types.IRawRule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

class ScopeDependencyProcessor {
    final Set<String> seenFullScopeRequests = new HashSet<String>();
    final Set<String> seenPartialScopeRequests = new HashSet<String>();
    List<ScopeDependency> queue = new ArrayList<ScopeDependency>();
    public final IGrammarRepository repo;
    public final String initialScopeName;

    ScopeDependencyProcessor(IGrammarRepository repo, String initialScopeName) {
        this.repo = repo;
        this.initialScopeName = initialScopeName;
        this.seenFullScopeRequests.add(initialScopeName);
        this.queue.add(new FullScopeDependency(initialScopeName));
    }

    public void processQueue() {
        List<ScopeDependency> q = this.queue;
        this.queue = new ArrayList<ScopeDependency>();
        ScopeDependencyCollector deps = new ScopeDependencyCollector();
        for (ScopeDependency scopeDependency : q) {
            this.collectDependenciesForDep(this.repo, this.initialScopeName, deps, scopeDependency);
        }
        for (FullScopeDependency fullScopeDependency : deps.full) {
            if (this.seenFullScopeRequests.contains(fullScopeDependency.scopeName)) continue;
            this.seenFullScopeRequests.add(fullScopeDependency.scopeName);
            this.queue.add(fullScopeDependency);
        }
        for (PartialScopeDependency partialScopeDependency : deps.partial) {
            if (this.seenFullScopeRequests.contains(partialScopeDependency.scopeName) || this.seenPartialScopeRequests.contains(partialScopeDependency.toKey())) continue;
            this.seenPartialScopeRequests.add(partialScopeDependency.toKey());
            this.queue.add(partialScopeDependency);
        }
    }

    void collectDependenciesForDep(IGrammarRepository repo, String initialScopeName, ScopeDependencyCollector result, ScopeDependency dep) {
        IRawGrammar grammar = repo.lookup(dep.scopeName);
        if (grammar == null) {
            if (dep.scopeName.equals(initialScopeName)) {
                throw new TMException("No grammar provided for <" + initialScopeName + ">");
            }
            return;
        }
        IRawGrammar initialGrammar = repo.lookup(initialScopeName);
        if (dep instanceof FullScopeDependency) {
            this.collectDependencies(result, NullSafetyHelper.castNonNull(initialGrammar), grammar);
        } else {
            PartialScopeDependency pdep = (PartialScopeDependency)dep;
            this.collectSpecificDependencies(result, NullSafetyHelper.castNonNull(initialGrammar), grammar, pdep.include, null);
        }
        Collection<String> injections = repo.injections(dep.scopeName);
        if (injections != null) {
            for (String injection : injections) {
                result.add(new FullScopeDependency(injection));
            }
        }
    }

    void collectSpecificDependencies(ScopeDependencyCollector result, IRawGrammar baseGrammar, IRawGrammar selfGrammar, String include, @Nullable IRawRepository repository) {
        IRawRule rule;
        if (repository == null && selfGrammar.isRepositorySet()) {
            repository = selfGrammar.getRepository();
        }
        if (repository != null && (rule = repository.getRule(include)) != null) {
            this.extractIncludedScopesInPatterns(result, baseGrammar, selfGrammar, List.of(rule), repository);
        }
    }

    void collectDependencies(ScopeDependencyCollector result, IRawGrammar baseGrammar, IRawGrammar selfGrammar) {
        Map<String, IRawRule> injections;
        Collection<IRawRule> patterns = selfGrammar.getPatterns();
        if (patterns != null) {
            this.extractIncludedScopesInPatterns(result, baseGrammar, selfGrammar, patterns, selfGrammar.getRepository());
        }
        if ((injections = selfGrammar.getInjections()) != null) {
            this.extractIncludedScopesInPatterns(result, baseGrammar, selfGrammar, injections.values(), selfGrammar.getRepository());
        }
    }

    void extractIncludedScopesInPatterns(ScopeDependencyCollector result, IRawGrammar baseGrammar, IRawGrammar selfGrammar, Collection<IRawRule> patterns, @Nullable IRawRepository repository) {
        for (IRawRule pattern : patterns) {
            String include;
            if (result.visitedRule.contains(pattern)) continue;
            result.visitedRule.add(pattern);
            IRawRepository patternRepository = pattern.getRepository() == null ? repository : IRawRepository.merge(repository, pattern.getRepository());
            Collection<IRawRule> patternPatterns = pattern.getPatterns();
            if (patternPatterns != null) {
                this.extractIncludedScopesInPatterns(result, baseGrammar, selfGrammar, patternPatterns, patternRepository);
            }
            if ((include = pattern.getInclude()) == null) continue;
            if (include.equals("$base") || include.equals(baseGrammar.getScopeName())) {
                this.collectDependencies(result, baseGrammar, baseGrammar);
                continue;
            }
            if (include.equals("$self") || include.equals(selfGrammar.getScopeName())) {
                this.collectDependencies(result, baseGrammar, selfGrammar);
                continue;
            }
            if (include.charAt(0) == '#') {
                this.collectSpecificDependencies(result, baseGrammar, selfGrammar, include.substring(1), patternRepository);
                continue;
            }
            int sharpIndex = include.indexOf(35);
            if (sharpIndex >= 0) {
                String scopeName = include.substring(0, sharpIndex);
                String includedName = include.substring(sharpIndex + 1);
                if (scopeName.equals(baseGrammar.getScopeName())) {
                    this.collectSpecificDependencies(result, baseGrammar, baseGrammar, includedName, patternRepository);
                    continue;
                }
                if (scopeName.equals(selfGrammar.getScopeName())) {
                    this.collectSpecificDependencies(result, baseGrammar, selfGrammar, includedName, patternRepository);
                    continue;
                }
                result.add(new PartialScopeDependency(scopeName, include.substring(sharpIndex + 1)));
                continue;
            }
            result.add(new FullScopeDependency(include));
        }
    }

    private static final class FullScopeDependency
    extends ScopeDependency {
        FullScopeDependency(String scopeName) {
            super(scopeName);
        }
    }

    private static final class PartialScopeDependency
    extends ScopeDependency {
        final String include;

        PartialScopeDependency(String scopeName, String include) {
            super(scopeName);
            this.include = include;
        }

        String toKey() {
            return String.valueOf(this.scopeName) + '#' + this.include;
        }
    }

    private static abstract class ScopeDependency {
        final String scopeName;

        ScopeDependency(String scopeName) {
            this.scopeName = scopeName;
        }
    }

    private static class ScopeDependencyCollector {
        final List<FullScopeDependency> full = new ArrayList<FullScopeDependency>();
        final List<PartialScopeDependency> partial = new ArrayList<PartialScopeDependency>();
        final Set<IRawRule> visitedRule = new HashSet<IRawRule>();
        private final Set<String> seenFull = new HashSet<String>();
        private final Set<String> seenPartial = new HashSet<String>();

        private ScopeDependencyCollector() {
        }

        void add(ScopeDependency dep) {
            if (dep instanceof FullScopeDependency) {
                FullScopeDependency fdep = (FullScopeDependency)dep;
                if (!this.seenFull.contains(fdep.scopeName)) {
                    this.seenFull.add(fdep.scopeName);
                    this.full.add(fdep);
                }
            } else {
                PartialScopeDependency pdep = (PartialScopeDependency)dep;
                if (!this.seenPartial.contains(pdep.toKey())) {
                    this.seenPartial.add(pdep.toKey());
                    this.partial.add(pdep);
                }
            }
        }
    }
}

