/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.components.FilteredCheckboxTree;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.service.prefs.BackingStoreException;

public class RepositorySearchDialog
extends WizardPage {
    private static final String PREF_DEEP_SEARCH = "RepositorySearchDialogDeepSearch";
    private static final String PREF_SKIP_HIDDEN = "RepositorySearchDialogSkipHidden";
    private static final String PREF_PATH = "RepositorySearchDialogSearchPath";
    private final Set<String> fExistingDirectories = new HashSet<String>();
    private final boolean fillSearch;
    private Set<String> fResult;
    private FilteredCheckboxTree fTree;
    private CachedCheckboxTreeViewer fTreeViewer;
    private Text dir;
    private Button lookForNestedButton;
    private Button skipHiddenButton;
    private Button searchButton;
    private ToolItem checkAllItem;
    private ToolItem uncheckAllItem;
    private final ResourceManager fImageCache = new LocalResourceManager(JFaceResources.getResources());
    private final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
    private boolean allowBare;

    public RepositorySearchDialog(Collection<String> existingDirs) {
        this(existingDirs, false, true);
    }

    public RepositorySearchDialog(Collection<String> existingDirs, boolean fillSearch, boolean allowBare) {
        super("searchPage", UIText.RepositorySearchDialog_SearchTitle, UIIcons.WIZBAN_IMPORT_REPO);
        this.fExistingDirectories.addAll(existingDirs);
        this.fillSearch = fillSearch;
        this.allowBare = allowBare;
    }

    public Set<String> getDirectories() {
        return this.fResult;
    }

    public void dispose() {
        this.fResult = this.getCheckedItems();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setMessage(UIText.RepositorySearchDialog_searchRepositoriesMessage);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Group searchGroup = new Group(main, 16);
        searchGroup.setText(UIText.RepositorySearchDialog_SearchCriteriaGroup);
        searchGroup.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, -1).applyTo((Control)searchGroup);
        Label dirLabel = new Label((Composite)searchGroup, 0);
        dirLabel.setText(UIText.RepositorySearchDialog_directory);
        this.dir = new Text((Composite)searchGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1).minSize(100, -1).applyTo((Control)this.dir);
        this.dir.setToolTipText(UIText.RepositorySearchDialog_EnterDirectoryToolTip);
        Button browse = new Button((Composite)searchGroup, 8);
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        browse.setText(UIText.RepositorySearchDialog_browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(RepositorySearchDialog.this.getShell());
                dd.setMessage(UIText.RepositorySearchDialog_BrowseDialogMessage);
                dd.setFilterPath(RepositorySearchDialog.this.dir.getText());
                String directory = dd.open();
                if (directory != null) {
                    RepositorySearchDialog.this.dir.setText(directory);
                    RepositorySearchDialog.this.prefs.put(RepositorySearchDialog.PREF_PATH, directory);
                    try {
                        RepositorySearchDialog.this.prefs.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        // empty catch block
                    }
                    RepositorySearchDialog.this.doSearch();
                }
            }
        });
        this.searchButton = new Button((Composite)searchGroup, 8);
        this.searchButton.setText(UIText.RepositorySearchDialog_Search);
        this.searchButton.setToolTipText(UIText.RepositorySearchDialog_SearchTooltip);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.doSearch();
            }
        });
        this.lookForNestedButton = new Button((Composite)searchGroup, 32);
        this.lookForNestedButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.lookForNestedButton.setSelection(this.prefs.getBoolean(PREF_DEEP_SEARCH, false));
        this.lookForNestedButton.setText(UIText.RepositorySearchDialog_DeepSearch_button);
        this.lookForNestedButton.setToolTipText(UIText.RepositorySearchDialog_SearchRecursiveToolTip);
        this.lookForNestedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.prefs.putBoolean(RepositorySearchDialog.PREF_DEEP_SEARCH, RepositorySearchDialog.this.lookForNestedButton.getSelection());
                try {
                    RepositorySearchDialog.this.prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                RepositorySearchDialog.this.setNeedsSearch();
            }
        });
        this.skipHiddenButton = new Button((Composite)searchGroup, 32);
        this.skipHiddenButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.skipHiddenButton.setSelection(this.prefs.getBoolean(PREF_SKIP_HIDDEN, true));
        this.skipHiddenButton.setText(UIText.RepositorySearchDialog_SkipHidden);
        this.skipHiddenButton.setToolTipText(UIText.RepositorySearchDialog_SkipHiddenTooltip);
        this.skipHiddenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.prefs.putBoolean(RepositorySearchDialog.PREF_SKIP_HIDDEN, RepositorySearchDialog.this.skipHiddenButton.getSelection());
                try {
                    RepositorySearchDialog.this.prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                RepositorySearchDialog.this.setNeedsSearch();
            }
        });
        Group searchResultGroup = new Group(main, 16);
        searchResultGroup.setText(UIText.RepositorySearchDialog_SearchResultGroup);
        searchResultGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 0).applyTo((Control)searchResultGroup);
        PatternFilter filter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (RepositorySearchDialog.this.getCheckedItems().contains(element)) {
                    return true;
                }
                return super.isElementVisible(viewer, element);
            }
        };
        this.fTree = new FilteredCheckboxTree((Composite)searchResultGroup, null, 0, filter);
        this.fTreeViewer = this.fTree.getCheckboxTreeViewer();
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RepositorySearchDialog.this.enableOk();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).minSize(0, 300).applyTo((Control)this.fTree);
        ToolBar toolbar = new ToolBar((Composite)searchResultGroup, 0x800200);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)toolbar);
        this.checkAllItem = new ToolItem(toolbar, 8);
        this.checkAllItem.setToolTipText(UIText.RepositorySearchDialog_CheckAllRepositories);
        this.checkAllItem.setEnabled(false);
        Image checkImage = UIIcons.CHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)this.checkAllItem, (Resource)checkImage);
        this.checkAllItem.setImage(checkImage);
        this.checkAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.fTreeViewer.setAllChecked(true);
                RepositorySearchDialog.this.enableOk();
            }
        });
        this.uncheckAllItem = new ToolItem(toolbar, 8);
        this.uncheckAllItem.setToolTipText(UIText.RepositorySearchDialog_UncheckAllRepositories);
        this.uncheckAllItem.setEnabled(false);
        Image uncheckImage = UIIcons.UNCHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)this.uncheckAllItem, (Resource)uncheckImage);
        this.uncheckAllItem.setImage(uncheckImage);
        this.uncheckAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.fTreeViewer.setAllChecked(false);
                RepositorySearchDialog.this.enableOk();
            }
        });
        this.dir.addModifyListener(e -> this.setNeedsSearch());
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        String initialPath = this.prefs.get(PREF_PATH, RepositoryUtil.getDefaultRepositoryDir());
        this.dir.setText(initialPath);
        this.setControl((Control)main);
        this.enableOk();
        if (this.fillSearch && this.searchButton.isEnabled()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (!this.getControl().isDisposed()) {
                    this.doSearch();
                }
            });
        }
    }

    private String findGitDirsRecursive(Path root, final Set<Path> gitDirs, IProgressMonitor monitor, final boolean lookForNested, final boolean skipHidden) {
        long start = System.currentTimeMillis();
        final int[] dirCount = new int[1];
        final SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
                private long lastMonitorUpdate;

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path d, BasicFileAttributes attrs) throws IOException {
                    dirCount[0] = dirCount[0] + 1;
                    if (m.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (d == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (this.isHidden(d) || this.isGitInternal(d)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    this.updateMonitor(d);
                    Path resolved = this.resolve(d);
                    if (resolved == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.suppressed(resolved)) {
                        gitDirs.add(resolved.toAbsolutePath());
                        this.updateMonitor(resolved);
                        if (this.isDotGit(resolved)) {
                            if (!lookForNested || this.isSameFile(d, resolved) && !this.hasSubmodule(resolved)) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        } else {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                private boolean isHidden(@NonNull Path d) throws IOException {
                    return skipHidden && Files.isHidden(d) && !this.isDotGit(d);
                }

                private boolean isGitInternal(@NonNull Path d) {
                    Path fileName = d.getFileName();
                    if (fileName == null) {
                        return false;
                    }
                    Path p = d.getParent();
                    String n = fileName.toString();
                    return p != null && this.isDotGit(p) && !"modules".equals(n);
                }

                private Path resolve(@NonNull Path d) {
                    File f = RepositoryCache.FileKey.resolve((File)d.toFile(), (FS)FS.DETECTED);
                    if (f == null) {
                        return null;
                    }
                    return f.toPath();
                }

                private boolean suppressed(@NonNull Path d) {
                    return !RepositorySearchDialog.this.allowBare && !this.isDotGit(d);
                }

                private boolean isDotGit(@NonNull Path d) {
                    Path fileName = d.getFileName();
                    if (fileName == null) {
                        return false;
                    }
                    return ".git".equals(fileName.toString());
                }

                private boolean isSameFile(@NonNull Path f1, @NonNull Path f2) {
                    try {
                        return Files.isSameFile(f1, f2);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }

                private boolean hasSubmodule(@NonNull Path dotGit) {
                    Path gitmodules = dotGit.getParent().resolve(".gitmodules");
                    Path modules = dotGit.resolve("modules");
                    return Files.exists(gitmodules, new LinkOption[0]) && Files.exists(modules, new LinkOption[0]);
                }

                private void updateMonitor(@NonNull Path d) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastMonitorUpdate > 100L) {
                        m.setWorkRemaining(100);
                        m.worked(1);
                        m.setTaskName(MessageFormat.format(UIText.RepositorySearchDialog_RepositoriesFound_message, gitDirs.size(), d.toAbsolutePath().toString()));
                        this.lastMonitorUpdate = now;
                    }
                }
            };
            Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            org.eclipse.egit.core.Activator.error((String)e.getMessage(), (Throwable)e);
        }
        long time = System.currentTimeMillis() - start;
        return this.formatSummary(gitDirs, dirCount, time);
    }

    private String formatSummary(Set<Path> gitDirs, int[] dirCount, long time) {
        String fmtTime = "";
        fmtTime = time < 1000L ? String.format("%dms", time) : (time < 10000L ? String.format("%.1fs", (double)time / 1000.0) : String.format("%ds", time / 1000L));
        return MessageFormat.format(UIText.RepositorySearchDialog_SearchResult, gitDirs.size(), dirCount[0], fmtTime);
    }

    private HashSet<String> getCheckedItems() {
        HashSet<String> ret = new HashSet<String>();
        Object[] objectArray = this.fTreeViewer.getCheckedLeafElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            ret.add((String)item);
            ++n2;
        }
        return ret;
    }

    private void doSearch() {
        this.setMessage(UIText.RepositorySearchDialog_searchRepositoriesMessage);
        this.setErrorMessage(null);
        final TreeSet<Path> directories = new TreeSet<Path>(CommonUtils.PATH_STRING_COMPARATOR);
        final Path file = Paths.get(this.dir.getText(), new String[0]);
        final boolean lookForNested = this.lookForNestedButton.getSelection();
        final boolean skipHidden = this.skipHiddenButton.getSelection();
        if (!Files.isDirectory(file, new LinkOption[0])) {
            return;
        }
        this.prefs.put(PREF_PATH, file.toAbsolutePath().toString());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        TreeSet<String> validDirs = new TreeSet<String>(this.getCheckedItems());
        final String[] summary = new String[1];
        IRunnableWithProgress action = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(UIText.RepositorySearchDialog_ScanningForRepositories_message, -1);
                try {
                    summary[0] = RepositorySearchDialog.this.findGitDirsRecursive(file, directories, monitor, lookForNested, skipHidden);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            this.getContainer().run(true, true, action);
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositorySearchDialog_errorOccurred, e1.getCause(), true);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        int foundOld = 0;
        for (Path foundDir : directories) {
            String absolutePath = foundDir.toAbsolutePath().toString();
            if (!this.fExistingDirectories.contains(absolutePath) && !this.fExistingDirectories.contains(FileUtils.canonicalize((File)foundDir.toFile()).getAbsolutePath())) {
                validDirs.add(absolutePath);
                continue;
            }
            ++foundOld;
        }
        if (foundOld > 0) {
            String message = String.valueOf(summary[0]) + '\n' + MessageFormat.format(UIText.RepositorySearchDialog_SomeDirectoriesHiddenMessage, foundOld);
            this.setMessage(message, 1);
        } else if (directories.isEmpty()) {
            this.setMessage(summary[0], 1);
        } else {
            this.setMessage(summary[0]);
        }
        this.checkAllItem.setEnabled(!validDirs.isEmpty());
        this.uncheckAllItem.setEnabled(!validDirs.isEmpty());
        this.fTree.clearFilter();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTree);
        this.fTreeViewer.setInput(validDirs);
        if (!validDirs.isEmpty()) {
            this.fTree.getFilterControl().setFocus();
        }
        this.enableOk();
    }

    private void setNeedsSearch() {
        this.fTreeViewer.setInput(null);
        try {
            Path file = Paths.get(this.dir.getText(), new String[0]);
            if (!Files.isDirectory(file, new LinkOption[0])) {
                this.setErrorMessage(MessageFormat.format(UIText.RepositorySearchDialog_DirectoryNotFoundMessage, this.dir.getText()));
                this.searchButton.setEnabled(false);
            } else {
                this.searchButton.setEnabled(true);
                this.setErrorMessage(null);
                this.setMessage(UIText.RepositorySearchDialog_NoSearchAvailableMessage, 1);
            }
        }
        catch (InvalidPathException e) {
            this.setErrorMessage(MessageFormat.format(UIText.RepositorySearchDialog_InvalidDirectoryMessage, e.getLocalizedMessage()));
            this.searchButton.setEnabled(false);
        }
        this.enableOk();
    }

    private void enableOk() {
        boolean enable = this.fTreeViewer.getCheckedElements().length > 0;
        this.setPageComplete(enable);
    }

    private static final class ContentProvider
    implements ITreeContentProvider {
        private final Object[] children = new Object[0];

        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Set)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private final class RepositoryLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private RepositoryLabelProvider() {
        }

        public Image getImage(Object element) {
            return RepositorySearchDialog.this.fImageCache.createImage(UIIcons.REPOSITORY);
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (RepositorySearchDialog.this.fExistingDirectories.contains(element)) {
                return RepositorySearchDialog.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public void dispose() {
            RepositorySearchDialog.this.fImageCache.dispose();
        }
    }
}

