/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties.tabbed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.IActionProvider;
import org.eclipse.ui.views.properties.tabbed.IOverridableTabListContentProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TabbedPropertySheetPage
extends Page
implements IPropertySheetPage,
ILabelProviderListener {
    private TabbedPropertyComposite tabbedPropertyComposite;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private ITabbedPropertySheetPageContributor contributor;
    private TabbedPropertyRegistry registry;
    private ITabbedPropertySheetPageContributor selectionContributor = null;
    private String currentContributorId;
    protected IStructuredContentProvider tabListContentProvider;
    private ISelection currentSelection;
    private boolean activePropertySheet;
    private TabbedPropertyViewer tabbedPropertyViewer;
    private TabContents currentTab;
    private Map<ITabDescriptor, TabContents> descriptorToTab;
    private Map<TabContents, Composite> tabToComposite;
    private List<String> selectionQueue;
    private boolean selectionQueueLocked;
    private List<ITabSelectionListener> tabSelectionListeners;
    private IWorkbenchWindow cachedWorkbenchWindow;
    private boolean hasTitleBar;
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            TabbedPropertySheetPage.this.handlePartActivated(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public TabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
        this(tabbedPropertySheetPageContributor, true);
    }

    public TabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, boolean showTitleBar) {
        this.hasTitleBar = showTitleBar;
        this.contributor = tabbedPropertySheetPageContributor;
        this.tabToComposite = new HashMap<TabContents, Composite>();
        this.selectionQueue = new ArrayList<String>(10);
        this.tabSelectionListeners = new ArrayList<ITabSelectionListener>();
        this.initContributor(this.contributor.getContributorId());
    }

    protected void handlePartActivated(IWorkbenchPart part) {
        IContributedContentsView view;
        boolean thisActivated;
        boolean bl = thisActivated = part instanceof PropertySheet && ((PropertySheet)part).getCurrentPage() == this;
        if (!(thisActivated || part.equals(this.contributor) || part.getSite().getId().equals(this.contributor.getContributorId()) || (view = (IContributedContentsView)Adapters.adapt((Object)part, IContributedContentsView.class)) != null && (view.getContributingPart() == null || view.getContributingPart().equals(this.contributor)))) {
            if (this.activePropertySheet) {
                if (this.currentTab != null) {
                    this.currentTab.aboutToBeHidden();
                }
                this.activePropertySheet = false;
            }
            return;
        }
        if (!this.activePropertySheet && this.currentTab != null) {
            this.currentTab.aboutToBeShown();
            this.currentTab.refresh();
        }
        this.activePropertySheet = true;
    }

    public void createControl(Composite parent) {
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.tabbedPropertyComposite = new TabbedPropertyComposite(parent, this.widgetFactory, this.hasTitleBar);
        this.widgetFactory.paintBordersFor(this.tabbedPropertyComposite);
        this.tabbedPropertyComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.tabbedPropertyComposite.setLayoutData(formData);
        this.tabbedPropertyViewer = new TabbedPropertyViewer(this.tabbedPropertyComposite.getList());
        this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        this.tabbedPropertyViewer.setLabelProvider((IBaseLabelProvider)new TabbedPropertySheetPageLabelProvider());
        this.tabbedPropertyViewer.addSelectionChangedListener(new SelectionChangedListener());
        this.tabbedPropertyComposite.getScrolledComposite().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertySheetPage.this.resizeScrolledComposite();
            }
        });
        this.cachedWorkbenchWindow = this.getSite().getWorkbenchWindow();
        this.cachedWorkbenchWindow.getPartService().addPartListener(this.partActivationListener);
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    private void initContributor(String contributorId) {
        this.descriptorToTab = new HashMap<ITabDescriptor, TabContents>();
        if (this.contributor.getContributorId().equals(contributorId)) {
            this.registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(this.contributor);
        } else {
            this.selectionContributor = new TabbedPropertySheetPageContributorFromSelection(contributorId);
            this.registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(this.selectionContributor);
        }
        this.currentContributorId = contributorId;
        this.tabListContentProvider = this.getTabListContentProvider();
        boolean bl = this.hasTitleBar = this.hasTitleBar && this.registry.getLabelProvider() != null;
        if (this.tabbedPropertyViewer != null) {
            this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        }
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    protected IStructuredContentProvider getTabListContentProvider() {
        return this.registry.getTabListContentProvider();
    }

    protected void disposeContributor() {
        if (this.currentTab != null) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = new HashMap<ITabDescriptor, TabContents>();
        if (this.hasTitleBar && this.registry != null) {
            this.registry.getLabelProvider().removeListener((ILabelProviderListener)this);
        }
        if (this.selectionContributor != null) {
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry(this.selectionContributor);
            this.selectionContributor = null;
        }
    }

    public void dispose() {
        this.disposeContributor();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
            this.widgetFactory = null;
        }
        if (this.cachedWorkbenchWindow != null) {
            this.cachedWorkbenchWindow.getPartService().removePartListener(this.partActivationListener);
            this.cachedWorkbenchWindow = null;
        }
        if (this.registry != null) {
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry(this.contributor);
            this.registry = null;
        }
        this.contributor = null;
        this.currentSelection = null;
    }

    public Control getControl() {
        return this.tabbedPropertyComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        IActionBars partActionBars = null;
        if (this.contributor instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)this.contributor;
            partActionBars = editorPart.getEditorSite().getActionBars();
        } else if (this.contributor instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)this.contributor;
            partActionBars = viewPart.getViewSite().getActionBars();
        }
        if (partActionBars != null) {
            IAction action = partActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
            if (action != null) {
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            }
            if ((action = partActionBars.getGlobalActionHandler(ActionFactory.REDO.getId())) != null) {
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            }
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setInput(part, selection);
    }

    private void storeCurrentTabSelection(String label) {
        if (!this.selectionQueueLocked) {
            this.selectionQueue.remove(label);
            this.selectionQueue.add(0, label);
        }
    }

    public void resizeScrolledComposite() {
        ScrollBar horizontalScrollBar;
        Composite sizeReference;
        Point currentTabSize = new Point(0, 0);
        if (this.currentTab != null && (sizeReference = this.tabToComposite.get(this.currentTab)) != null) {
            currentTabSize = sizeReference.computeSize(-1, -1);
        }
        this.tabbedPropertyComposite.getScrolledComposite().setMinSize(currentTabSize);
        ScrollBar verticalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getVerticalBar();
        if (verticalScrollBar != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.height - 5;
            verticalScrollBar.setPageIncrement(increment);
        }
        if ((horizontalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getHorizontalBar()) != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.width - 5;
            horizontalScrollBar.setPageIncrement(increment);
        }
    }

    protected void disposeTabs(Collection tabs) {
        for (TabContents tab : tabs) {
            Composite composite = this.tabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
    }

    private int getLastTabSelection(IWorkbenchPart part, ISelection input) {
        ITabDescriptor[] descriptors = this.registry.getTabDescriptors(part, input);
        if (descriptors.length != 0) {
            for (String text : this.selectionQueue) {
                int i = 0;
                while (i < descriptors.length) {
                    if (text.equals(descriptors[i].getLabel())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    protected void updateTabs(ITabDescriptor[] descriptors) {
        HashMap<ITabDescriptor, TabContents> newTabs = new HashMap<ITabDescriptor, TabContents>(descriptors.length * 2);
        boolean disposingCurrentTab = this.currentTab != null;
        ITabDescriptor[] iTabDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor descriptor = iTabDescriptorArray[n2];
            TabContents tab = this.descriptorToTab.remove(descriptor);
            if (tab != null && tab.controlsHaveBeenCreated()) {
                if (tab == this.currentTab) {
                    disposingCurrentTab = false;
                }
            } else {
                tab = this.createTab(descriptor);
            }
            newTabs.put(descriptor, tab);
            ++n2;
        }
        if (disposingCurrentTab) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = newTabs;
    }

    protected TabContents createTab(ITabDescriptor tabDescriptor) {
        return tabDescriptor.createTab();
    }

    private Composite createTabComposite() {
        Composite result = this.widgetFactory.createComposite(this.tabbedPropertyComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = this.hasTitleBar ? new FormAttachment((Control)this.tabbedPropertyComposite.getTitle(), 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    private void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.validateRegistry(selection);
        ITabDescriptor[] descriptors = this.registry.getTabDescriptors(part, this.currentSelection);
        if (descriptors.length > 0) {
            this.updateTabs(descriptors);
        }
        this.tabbedPropertyViewer.setInput(part, this.currentSelection);
        int lastTabSelectionIndex = this.getLastTabSelection(part, this.currentSelection);
        Object selectedTab = this.tabbedPropertyViewer.getElementAt(lastTabSelectionIndex);
        this.selectionQueueLocked = true;
        try {
            if (selectedTab == null) {
                this.tabbedPropertyViewer.setSelection(null);
            } else {
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection(selectedTab));
            }
        }
        finally {
            this.selectionQueueLocked = false;
        }
        this.refreshTitleBar();
    }

    public void refresh() {
        this.currentTab.refresh();
    }

    public TabContents getCurrentTab() {
        return this.currentTab;
    }

    private void handleTabSelection(ITabDescriptor tabDescriptor) {
        if (this.selectionQueueLocked) {
            return;
        }
        for (ITabSelectionListener listener : this.tabSelectionListeners) {
            listener.tabSelected(tabDescriptor);
        }
    }

    public void addTabSelectionListener(ITabSelectionListener listener) {
        this.tabSelectionListeners.add(listener);
    }

    public void removeTabSelectionListener(ITabSelectionListener listener) {
        this.tabSelectionListeners.remove(listener);
    }

    public void overrideTabs() {
        if (this.tabListContentProvider instanceof IOverridableTabListContentProvider) {
            IOverridableTabListContentProvider overridableTabListContentProvider = (IOverridableTabListContentProvider)this.tabListContentProvider;
            overridableTabListContentProvider.overrideTabs();
        }
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void refreshTitleBar() {
        if (this.hasTitleBar) {
            TabbedPropertyTitle title = this.tabbedPropertyComposite.getTitle();
            if (this.currentTab == null) {
                title.setTitle(null, null);
            } else {
                String text = this.registry.getLabelProvider().getText((Object)this.currentSelection);
                Image image = this.registry.getLabelProvider().getImage((Object)this.currentSelection);
                title.setTitle(text, image);
            }
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.refreshTitleBar();
    }

    private ITabbedPropertySheetPageContributor getTabbedPropertySheetPageContributor(Object object) {
        return (ITabbedPropertySheetPageContributor)Adapters.adapt((Object)object, ITabbedPropertySheetPageContributor.class);
    }

    private void validateRegistry(ISelection selection) {
        String selectionContributorId;
        if (selection == null) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return;
        }
        ITabbedPropertySheetPageContributor newContributor = this.getTabbedPropertySheetPageContributor(structuredSelection.getFirstElement());
        if (newContributor == null) {
            newContributor = this.contributor;
        }
        if ((selectionContributorId = newContributor.getContributorId()).equals(this.currentContributorId)) {
            return;
        }
        Iterator i = structuredSelection.iterator();
        i.next();
        while (i.hasNext()) {
            newContributor = this.getTabbedPropertySheetPageContributor(i.next());
            if (newContributor != null && newContributor.getContributorId().equals(selectionContributorId)) continue;
            if (this.selectionContributor != null) {
                this.disposeContributor();
                this.currentContributorId = this.contributor.getContributorId();
                this.initContributor(this.currentContributorId);
            }
            return;
        }
        this.disposeContributor();
        this.currentContributorId = selectionContributorId;
        this.initContributor(this.currentContributorId);
        this.overrideActionBars();
    }

    private void overrideActionBars() {
        if (this.registry.getActionProvider() != null) {
            IActionProvider actionProvider = this.registry.getActionProvider();
            actionProvider.setActionBars(this.contributor, this.getSite().getActionBars());
        }
    }

    public ITabDescriptor getSelectedTab() {
        Object object;
        int selectedTab = this.tabbedPropertyViewer.getSelectionIndex();
        if (selectedTab != -1 && (object = this.tabbedPropertyViewer.getElementAt(selectedTab)) instanceof ITabDescriptor) {
            return (ITabDescriptor)object;
        }
        return null;
    }

    public ITabDescriptor[] getActiveTabs() {
        List elements = this.tabbedPropertyViewer.getElements();
        if (elements != null && elements.size() > 0) {
            return elements.toArray(new ITabDescriptor[elements.size()]);
        }
        return new ITabDescriptor[0];
    }

    public void setSelectedTab(String id) {
        List elements = this.tabbedPropertyViewer.getElements();
        if (elements != null && elements.size() > 0) {
            for (ITabDescriptor tabDescriptor : elements) {
                if (tabDescriptor.getId() == null || !tabDescriptor.getId().equals(id)) continue;
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)tabDescriptor), true);
            }
        }
    }

    public String getTitleText(ISelection selection) {
        if (selection == null) {
            selection = this.currentSelection;
        }
        return this.registry.getLabelProvider().getText((Object)selection);
    }

    public Image getTitleImage(ISelection selection) {
        if (selection == null) {
            selection = this.currentSelection;
        }
        return this.registry.getLabelProvider().getImage((Object)selection);
    }

    protected TabContents getTabContents(ITabDescriptor tabDescriptor) {
        TabContents tabContents = null;
        if (this.descriptorToTab.containsKey(tabDescriptor)) {
            tabContents = this.descriptorToTab.get(tabDescriptor);
        }
        return tabContents;
    }

    protected ITabbedPropertySheetPageContributor getSelectionContributor() {
        return this.selectionContributor;
    }

    protected String getCurrentContributorId() {
        return this.currentContributorId;
    }

    protected ISelection getCurrentSelection() {
        return this.currentSelection;
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = event.getStructuredSelection();
            TabContents tab = null;
            ITabDescriptor descriptor = (ITabDescriptor)selection.getFirstElement();
            if (descriptor == null) {
                this.hideTab(TabbedPropertySheetPage.this.currentTab);
            } else {
                Composite tabComposite;
                tab = TabbedPropertySheetPage.this.descriptorToTab.get(descriptor);
                if (tab != TabbedPropertySheetPage.this.currentTab) {
                    this.hideTab(TabbedPropertySheetPage.this.currentTab);
                }
                if ((tabComposite = TabbedPropertySheetPage.this.tabToComposite.get(tab)) == null) {
                    tabComposite = TabbedPropertySheetPage.this.createTabComposite();
                    tab.createControls(tabComposite, TabbedPropertySheetPage.this);
                    TabbedPropertySheetPage.this.tabToComposite.put(tab, tabComposite);
                }
                tab.setInput(TabbedPropertySheetPage.this.tabbedPropertyViewer.getWorkbenchPart(), (ISelection)TabbedPropertySheetPage.this.tabbedPropertyViewer.getInput());
                TabbedPropertySheetPage.this.storeCurrentTabSelection(descriptor.getLabel());
                if (tab != TabbedPropertySheetPage.this.currentTab) {
                    this.showTab(tab);
                }
                tab.refresh();
            }
            TabbedPropertySheetPage.this.tabbedPropertyComposite.getTabComposite().layout(true);
            TabbedPropertySheetPage.this.currentTab = tab;
            TabbedPropertySheetPage.this.resizeScrolledComposite();
            if (descriptor != null) {
                TabbedPropertySheetPage.this.handleTabSelection(descriptor);
            }
        }

        private void showTab(TabContents target) {
            Composite tabComposite;
            if (target != null && (tabComposite = TabbedPropertySheetPage.this.tabToComposite.get(target)) != null) {
                tabComposite.moveAbove(null);
                target.aboutToBeShown();
                tabComposite.setVisible(true);
            }
        }

        private void hideTab(TabContents target) {
            Composite tabComposite;
            if (target != null && (tabComposite = TabbedPropertySheetPage.this.tabToComposite.get(target)) != null) {
                target.aboutToBeHidden();
                tabComposite.setVisible(false);
            }
        }
    }

    private static class TabbedPropertySheetPageContributorFromSelection
    implements ITabbedPropertySheetPageContributor {
        private String contributorId;

        public TabbedPropertySheetPageContributorFromSelection(String contributorId) {
            this.contributorId = contributorId;
        }

        @Override
        public String getContributorId() {
            return this.contributorId;
        }
    }

    static class TabbedPropertySheetPageLabelProvider
    extends LabelProvider {
        TabbedPropertySheetPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITabDescriptor) {
                return ((ITabDescriptor)element).getLabel();
            }
            return null;
        }
    }
}

