/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Objects;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ResizingInputDialog
extends InputDialog {
    private String currentErrorMessage;
    private Composite container;

    public ResizingInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.container = parent;
        return result;
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
        if (!Objects.equals(this.currentErrorMessage, errorMessage)) {
            this.currentErrorMessage = errorMessage;
            if (this.container != null) {
                Rectangle oldSize = this.container.getClientArea();
                Point newSize = this.container.computeSize(oldSize.width, -1, true);
                int dh = newSize.y - oldSize.height;
                if (dh > 0) {
                    Shell shell = this.container.getShell();
                    Point currentSize = shell.getSize();
                    currentSize.y += dh;
                    shell.setSize(currentSize);
                }
            }
        }
    }
}

