"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const embeddedSupport_1 = require("./embeddedSupport");
class VirtualDocumentProvider {
    createVirtualDocument(context, useRawText = false) {
        const contents = useRawText ? context.rawText : context.text;
        return {
            uri: 'untitled://embedded.html',
            languageId: 'html',
            version: 1,
            getText: () => contents,
            positionAt: (offset) => {
                return context.toPosition(offset);
            },
            offsetAt: (p) => {
                return context.toOffset(p);
            },
            lineCount: contents.split(/\n/g).length + 1,
        };
    }
    toVirtualDocPosition(position) {
        return position;
    }
    fromVirtualDocPosition(position) {
        return position;
    }
    toVirtualDocOffset(offset) {
        return offset;
    }
    fromVirtualDocOffset(offset) {
        return offset;
    }
}
exports.VirtualDocumentProvider = VirtualDocumentProvider;
class CssDocumentProvider extends VirtualDocumentProvider {
    constructor(htmlLanguageService) {
        super();
        this.htmlLanguageService = htmlLanguageService;
    }
    createVirtualDocument(context) {
        const regions = embeddedSupport_1.getDocumentRegions(this.htmlLanguageService, new VirtualDocumentProvider().createVirtualDocument(context));
        return regions.getEmbeddedDocument('css');
    }
}
exports.CssDocumentProvider = CssDocumentProvider;
//# sourceMappingURL=virtual-document-provider.js.map