/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isNgLanguageService = void 0;
    function isNgLanguageService(ls) {
        return 'getTcb' in ls;
    }
    exports.isNgLanguageService = isNgLanguageService;
});
//# sourceMappingURL=data:application/json;base64,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