/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.phrase;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class ExtendedAutomaticLinkReplacementToken
extends PatternBasedElement {
    private static final String AUTOMATIC_LINK_REGEX = "(?<=^|\\s|\\p{Punct})((https?://(?!/)|www\\.)[a-zA-Z0-9:/?#\\[\\]@!$&'\\(\\)\\*+,;=\\-\\._~%]+)(?=$|\"|\\s|<)";
    private static final Set<String> EMPTY_LINKS = ImmutableSet.of((Object)"www.", (Object)"http://", (Object)"https://");

    protected String getPattern(int groupOffset) {
        return AUTOMATIC_LINK_REGEX;
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new PatternBasedElementProcessor(){

            public void emit() {
                String href = this.group(1);
                int parensBalance = href.codePoints().map(c -> {
                    switch (c) {
                        case 40: {
                            return -1;
                        }
                        case 41: {
                            return 1;
                        }
                    }
                    return 0;
                }).sum();
                int endIndex = -1;
                block5: for (int i = href.length() - 1; i > 3; --i) {
                    switch (href.charAt(i)) {
                        case '!': 
                        case '\"': 
                        case '\'': 
                        case '*': 
                        case '.': 
                        case ':': 
                        case '?': 
                        case '_': 
                        case '~': {
                            endIndex = i;
                            continue block5;
                        }
                        case ')': {
                            if (parensBalance <= 0) break block5;
                            --parensBalance;
                        }
                        case ';': {
                            endIndex = i = this.skipHtmlEntity(href, i);
                            continue block5;
                        }
                    }
                }
                String linkText = endIndex > -1 ? href.substring(0, endIndex) : href;
                String linkHref = linkText.startsWith("www.") ? "http://" + linkText : linkText;
                if (EMPTY_LINKS.contains(linkText)) {
                    this.builder.characters(href);
                } else {
                    this.builder.link(linkHref, linkText);
                    if (endIndex > -1) {
                        this.builder.characters(href.substring(endIndex));
                    }
                }
            }

            private int skipHtmlEntity(String href, int endIndex) {
                for (int i = endIndex - 1; i > 3; --i) {
                    boolean isAlphaNum;
                    char c = href.charAt(i);
                    boolean bl = isAlphaNum = this.inRange(c, 'a', 'z') || this.inRange(c, 'A', 'Z') || this.inRange(c, '0', '9');
                    if (c == '&') {
                        return i;
                    }
                    if (isAlphaNum) continue;
                    return endIndex;
                }
                return endIndex;
            }

            private boolean inRange(char toCheck, char lowerBound, char upperBound) {
                return toCheck >= lowerBound && toCheck <= upperBound;
            }
        };
    }
}

