/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class CompareCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode>
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RepositoryTreeNode> nodes = this.getSelectedNodes();
        ArrayList refs = new ArrayList();
        nodes.forEach(node -> {
            Ref ref = this.getRef((RepositoryTreeNode)node);
            if (ref != null) {
                refs.add(ref);
            }
        });
        int numberOfRefs = refs.size();
        try {
            if (numberOfRefs == 2) {
                Repository repo = ((RepositoryTreeNode)nodes.get(0)).getRepository();
                IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                RevCommit a = repo.parseCommit((AnyObjectId)((Ref)refs.get(0)).getObjectId());
                RevCommit b = repo.parseCommit((AnyObjectId)((Ref)refs.get(1)).getObjectId());
                if (a.getCommitTime() <= b.getCommitTime()) {
                    this.compare(workbenchPage, repo, b.getName(), a.getName());
                } else {
                    this.compare(workbenchPage, repo, a.getName(), b.getName());
                }
            } else if (numberOfRefs == 1) {
                Repository repo = ((RepositoryTreeNode)nodes.get(0)).getRepository();
                IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                RevCommit a = repo.parseCommit((AnyObjectId)((Ref)refs.get(0)).getObjectId());
                this.compare(workbenchPage, repo, null, a.getName());
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    protected void compare(IWorkbenchPage workbenchPage, Repository repo, String compareCommit, String baseCommit) throws ExecutionException {
        GitCompareEditorInput compareInput = new GitCompareEditorInput(compareCommit, baseCommit, repo, new IPath[0]);
        CompareUtils.openInCompare(workbenchPage, compareInput);
    }

    private Ref getRef(RepositoryTreeNode node) {
        if (node instanceof TagNode) {
            return (Ref)((TagNode)node).getObject();
        }
        if (node instanceof RefNode || node instanceof AdditionalRefNode) {
            return (Ref)node.getObject();
        }
        return null;
    }

    public boolean isEnabled() {
        List nodes = this.getSelectedNodes();
        int numberOfNodes = nodes.size();
        if (numberOfNodes > 1) {
            return numberOfNodes == 2 && nodes.stream().map(RepositoryTreeNode::getRepository).distinct().count() == 1L;
        }
        return numberOfNodes == 1 && this.getRef((RepositoryTreeNode)nodes.get(0)) != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IStructuredSelection selection = SelectionUtils.getSelection(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        if (selection.size() == 1) {
            element.setText(UIText.CompareCommand_WithWorkingTreeLabel);
        }
    }
}

