/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentViolationEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.ScannableComponent;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspacePluginXML;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.ScanComponent;

public class ScanAPI
extends Action
implements IActionDelegate {
    private ScanComponent job;

    public void run() {
        Object firstElement;
        IStructuredSelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = (IStructuredSelection)window.getSelectionService().getSelection()) != null && !selection.isEmpty() && (firstElement = selection.getFirstElement()) != null && firstElement instanceof IFile) {
            ComponentManager manager = ComponentManager.getManager();
            ScannableComponent scannableComp = this.getScannableComponent((IFile)firstElement);
            if (scannableComp != null) {
                this.job = new ScanComponent(scannableComp, true);
                this.job.schedule();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
                try {
                    dialog.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            boolean interrupted = true;
                            while (interrupted) {
                                try {
                                    ScanAPI.this.job.join();
                                    interrupted = false;
                                }
                                catch (InterruptedException interruptedException) {
                                    interrupted = true;
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (this.hasAPIViolation(this.job.getSources())) {
                    MessageDialog.openError((Shell)window.getShell(), (String)manager.getMessage("TITLE_HAS_API_VIOLATIONS"), (String)manager.getMessage("ERROR_MSG_HAS_API_VIOLATIONS"));
                } else {
                    MessageDialog.openInformation((Shell)window.getShell(), (String)manager.getMessage("TITLE_HAS_API_VIOLATIONS"), (String)manager.getMessage("INFO_MSG_NO_API_VIOLATIONS"));
                }
            } else {
                MessageDialog.openError((Shell)window.getShell(), (String)manager.getMessage("TITLE_NO_WORKSPACE_PLUGINS"), (String)manager.getMessage("ERROR_MSG_NO_WORKSPACE_PLUGINS"));
            }
        }
    }

    private ScannableComponent getScannableComponent(IFile compXMLFile) {
        ComponentXML compXML = new ComponentXML();
        compXML.setLocation((ILocation)new WorkspaceFileLocation(compXMLFile));
        try {
            compXML.load();
        }
        catch (IOException iOException) {
            return null;
        }
        Collection plugins = compXML.getPlugins();
        HashMap<String, IPluginXML> pluginId2Plugins = new HashMap<String, IPluginXML>(plugins.size());
        ArrayList<IProject> workspacePluginProjects = new ArrayList<IProject>();
        ComponentManager manager = ComponentManager.getManager();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            IPluginXML pluginXML = manager.getPlugin(plugin.getId());
            pluginId2Plugins.put(pluginXML.getName(), pluginXML);
            if (!(pluginXML instanceof WorkspacePluginXML)) continue;
            workspacePluginProjects.add(((WorkspacePluginXML)pluginXML).getProject());
        }
        if (workspacePluginProjects.size() > 0) {
            HashMap<String, ComponentXML> compXMLs = new HashMap<String, ComponentXML>(1);
            compXMLs.put(compXML.getLocation().getAbsolutePath(), compXML);
            ComponentViolationEmitter emitter = new ComponentViolationEmitter(null);
            emitter.setDebug(true);
            ArrayList<String> excludes = new ArrayList<String>();
            excludes.add("java.");
            excludes.add("javax.");
            excludes.add("org.w3c.");
            excludes.add("org.xml.");
            excludes.add("org.apache.");
            excludes.add("sun.");
            emitter.setClassUseExcludes(excludes);
            emitter.init(compXMLs, this.getCompRefs(), pluginId2Plugins, new HashMap(0));
            return new ScannableComponent(compXML, emitter, workspacePluginProjects);
        }
        return null;
    }

    private Map getCompRefs() {
        final HashMap refs = new HashMap();
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy res) {
                    if (res.getType() == 1 && res.getName().equals("component.xml")) {
                        IFile file = (IFile)res.requestResource();
                        WorkspaceFileLocation location = new WorkspaceFileLocation(file);
                        ComponentXML compXML = new ComponentXML();
                        compXML.setLocation((ILocation)location);
                        try {
                            compXML.load();
                            refs.put(compXML.getLocation().getAbsolutePath(), compXML);
                        }
                        catch (IOException iOException) {}
                    }
                    return true;
                }
            }, 2);
        }
        catch (CoreException coreException) {}
        return refs;
    }

    private boolean hasAPIViolation(List sources) {
        if (sources != null) {
            int i = 0;
            while (i < sources.size()) {
                if (((Source)sources.get(i)).getClassUses().size() > 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

