/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaFileUpdateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileTestingUtilities {
    protected static final int MAX_FILE_CREATION_WAIT = 3000;
    private static final String WAR_EXTENSION = "war";
    private static final String JAR_EXTENSION = "jar";
    private static final String RAR_EXTENSION = "rar";
    private static final String WEB_PACKAGE = "webSrc";
    private static final String APP_CLIENT_PACKAGE = "appClientSrc";
    private static final String EJB_PACKAGE = "ejbSrc";
    private static final String CONNECTOR_PACKAGE = "connectorSrc";
    private static final String UTILITY_PACKAGE = "utilitySrc";
    private static Map<String, String[]> webProjectJavaFiles = new HashMap<String, String[]>();
    private static Map<String, String[]> appClientProjectJavaFiles = new HashMap<String, String[]>();
    private static Map<String, String[]> ejbProjectJavaFiles = new HashMap<String, String[]>();
    private static Map<String, String[]> connectorProjectJavaFiles = new HashMap<String, String[]>();
    private static Map<String, String[]> utilityProjectJavaFiles = new HashMap<String, String[]>();

    public static void addJavaFilesToAppClient(String projectName, String[] classNames, String prackageName) throws Exception {
        IVirtualComponent projVirtComp = ComponentUtilities.getComponent((String)projectName);
        IVirtualFolder virtRootFolder = projVirtComp.getRootFolder();
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(virtRootFolder, classNames, prackageName, null);
    }

    public static void addJavaFilesToEJB(String projectName, String[] classNames, String prackageName) throws Exception {
        IVirtualComponent projVirtComp = ComponentUtilities.getComponent((String)projectName);
        IVirtualFolder virtRootFolder = projVirtComp.getRootFolder();
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(virtRootFolder, classNames, prackageName, null);
    }

    public static void addJavaFileToEJB(String projectName, String className, String packageName, String classContents) throws Exception {
        IVirtualComponent projVirtComp = ComponentUtilities.getComponent((String)projectName);
        IVirtualFolder virtRootFolder = projVirtComp.getRootFolder();
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(virtRootFolder, new String[]{className}, packageName, classContents);
    }

    public static void addJavaFilesToWeb(String projectName, String[] classNames, String prackageName) throws Exception {
        IProject proj = J2EEProjectUtilities.getProject((String)projectName);
        IPackageFragmentRoot[] fragmentSrcRoots = J2EEProjectUtilities.getSourceContainers((IProject)proj);
        IPackageFragmentRoot fragmentSrcRoot = fragmentSrcRoots[0];
        Assert.assertNotNull((String)"Project should have at least one source root", (Object)fragmentSrcRoot);
        IPath srcRootProjectRelitivePath = fragmentSrcRoot.getPath().removeFirstSegments(1);
        IFolder srcFolder = proj.getFolder(srcRootProjectRelitivePath);
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(srcFolder, classNames, prackageName, null);
    }

    public static void addJavaFilesToConnector(String projectName, String[] classNames, String prackageName) throws Exception {
        IVirtualComponent projVirtComp = ComponentUtilities.getComponent((String)projectName);
        IVirtualFolder virtRootFolder = projVirtComp.getRootFolder();
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(virtRootFolder, classNames, prackageName, null);
    }

    public static void addJavaFilesToUtility(String projectName, String[] classNames, String prackageName) throws Exception {
        IVirtualComponent projVirtComp = ComponentUtilities.getComponent((String)projectName);
        IVirtualFolder virtRootFolder = projVirtComp.getRootFolder();
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(virtRootFolder, classNames, prackageName, null);
    }

    public static void verifyJavaFilesInJAR(String archivePath, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        IArchive archive = null;
        try {
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(archivePath));
            JavaFileTestingUtilities.verifyJavaFilesInJAR(archive, classNames, packageName, withClassFiles, withSource);
        }
        finally {
            if (archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
        }
    }

    public static void verifyJavaFilesInWAR(String archivePath, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        IArchive archive = null;
        try {
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(archivePath));
            JavaFileTestingUtilities.verifyJavaFilesInWAR(archive, classNames, packageName, withClassFiles, withSource);
        }
        finally {
            if (archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
        }
    }

    public static void verifyJavaFilesInRAR(String archivePath, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        IArchive archive = null;
        try {
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(archivePath));
            JavaFileTestingUtilities.verifyJavaFilesInRAR(archive, classNames, packageName, withClassFiles, withSource);
        }
        finally {
            if (archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
        }
    }

    public static void verifyJavaFilesInJAR(IArchive archive, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        String srcDirectoryPath = String.valueOf(packageName) + File.separatorChar;
        JavaFileTestingUtilities.verifyJavaFilesExported(archive, srcDirectoryPath, classNames, withClassFiles, withSource);
    }

    public static void verifyJavaFilesInWAR(IArchive archive, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        String srcDirectoryPath = "WEB-INF" + File.separatorChar + "classes" + File.separatorChar + packageName + File.separatorChar;
        JavaFileTestingUtilities.verifyJavaFilesExported(archive, srcDirectoryPath, classNames, withClassFiles, withSource);
    }

    public static void verifyJavaFilesInRAR(IArchive archive, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        List resources = archive.getArchiveResources();
        IPath resourcePath = null;
        String resourceName = null;
        boolean foundNestedArchiveResource = false;
        for (IArchiveResource resource : resources) {
            resourcePath = resource.getPath();
            resourceName = resourcePath.lastSegment();
            boolean bl = foundNestedArchiveResource = resourceName.contains("_") && resourcePath.getFileExtension().equals(JAR_EXTENSION);
            if (foundNestedArchiveResource) break;
        }
        Assert.assertTrue((String)"The connector should contain a nested archive resource", (boolean)foundNestedArchiveResource);
        IArchiveResource nestedArchiveResource = archive.getArchiveResource((IPath)new Path(resourceName));
        IArchive nestedArchive = archive.getNestedArchive(nestedArchiveResource);
        String srcDirectoryPath = String.valueOf(packageName) + File.separatorChar;
        JavaFileTestingUtilities.verifyJavaFilesExported(nestedArchive, srcDirectoryPath, classNames, withClassFiles, withSource);
    }

    protected static void addJavaFilesToSrcFolder(IVirtualFolder virtSrcFolder, String[] classNames, String prackageName, String classContents) throws Exception {
        IVirtualFolder packageVirtFolder = virtSrcFolder.getFolder(prackageName);
        packageVirtFolder.create(0, null);
        IVirtualFile virtFile = null;
        ArrayList<IFile> filesList = new ArrayList<IFile>();
        int i = 0;
        while (i < classNames.length) {
            virtFile = packageVirtFolder.getFile(String.valueOf(classNames[i]) + ".java");
            filesList.add(virtFile.getUnderlyingFile());
            ++i;
        }
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(filesList, prackageName, classContents);
    }

    protected static void addJavaFilesToSrcFolder(IFolder srcFolder, String[] classNames, String prackageName, String classContents) throws Exception {
        IFolder packageFolder = srcFolder.getFolder(prackageName);
        packageFolder.create(0, true, null);
        IFile file = null;
        ArrayList<IFile> filesList = new ArrayList<IFile>();
        int i = 0;
        while (i < classNames.length) {
            file = packageFolder.getFile(String.valueOf(classNames[i]) + ".java");
            filesList.add(file);
            ++i;
        }
        JavaFileTestingUtilities.addJavaFilesToSrcFolder(filesList, prackageName, classContents);
    }

    protected static void addJavaFilesToSrcFolder(List<IFile> filesList, String packageName, String classContents) throws Exception {
        int maxWait = 3000;
        String fileContents = null;
        String className = null;
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)JavaFileUpdateListener.getInstance());
            ArrayList<IFile> files = new ArrayList<IFile>();
            files.addAll(filesList);
            JavaFileUpdateListener.getInstance().setFiles(files);
            int i = 0;
            while (i < filesList.size()) {
                className = filesList.get(i).getProjectRelativePath().removeFileExtension().lastSegment();
                fileContents = classContents == null ? JavaFileTestingUtilities.generateJavaFileContent(className, packageName) : classContents;
                filesList.get(i).create((InputStream)new StringBufferInputStream(fileContents), true, null);
                ++i;
            }
            while (!JavaFileUpdateListener.getInstance().areFilesCreated() && maxWait > 0) {
                Thread.sleep(10L);
                maxWait -= 10;
            }
            Assert.assertTrue((String)"Should not have timed out waiting for Java files to be created", (maxWait > 0 ? 1 : 0) != 0);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)JavaFileUpdateListener.getInstance());
        }
    }

    protected static String generateJavaFileContent(String className, String packageName) {
        return "package " + packageName + "; public class " + className + " { }";
    }

    protected static void verifyJavaFilesExported(IArchive archive, String srcDirectoryPath, String[] classNames, boolean withClassFiles, boolean withSource) throws Exception {
        IArchiveResource resource = null;
        Path resourcePath = null;
        int i = 0;
        while (i < classNames.length) {
            if (withClassFiles) {
                resourcePath = new Path(String.valueOf(srcDirectoryPath) + classNames[i] + ".class");
                try {
                    resource = archive.getArchiveResource((IPath)resourcePath);
                    if (resource == null) {
                        System.err.println("TODO -- There should be an archive resource class file for class " + classNames[i]);
                        System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=195668");
                    }
                    resource = null;
                    resourcePath = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("TODO -- There should be an archive resource class file for class " + classNames[i]);
                    System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=195668");
                }
            }
            if (withSource) {
                resourcePath = new Path(String.valueOf(srcDirectoryPath) + classNames[i] + ".java");
                resource = archive.getArchiveResource((IPath)resourcePath);
                if (resource == null) {
                    Assert.fail((String)("There should be an archive resource source file for class " + classNames[i]));
                }
                resource = null;
                resourcePath = null;
            }
            ++i;
        }
    }

    public static void addJavaFilesToAllProjectsInEAR(IProject earProject) throws Exception {
        String[] classNameList;
        IProject project;
        IProject[] webProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.web");
        IProject[] appClientProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.appclient");
        IProject[] connectorProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.connector");
        IProject[] ejbProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ejb");
        IProject[] utilityProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.utility");
        String projectName = null;
        int fileCount = 0;
        List<IProject> referencedProjects = Arrays.asList(earProject.getReferencedProjects());
        IProject[] iProjectArray = webProjects;
        int n = webProjects.length;
        int n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            if (referencedProjects.contains(project)) {
                projectName = project.getName();
                classNameList = new String[]{"JavaFile" + fileCount++, "Javafile" + fileCount++};
                JavaFileTestingUtilities.addJavaFilesToWeb(projectName, classNameList, WEB_PACKAGE);
                webProjectJavaFiles.put(projectName, classNameList);
            }
            ++n2;
        }
        iProjectArray = appClientProjects;
        n = appClientProjects.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            if (referencedProjects.contains(project)) {
                projectName = project.getName();
                classNameList = new String[]{"JavaFile" + fileCount++, "Javafile" + fileCount++};
                JavaFileTestingUtilities.addJavaFilesToAppClient(projectName, classNameList, APP_CLIENT_PACKAGE);
                appClientProjectJavaFiles.put(projectName, classNameList);
            }
            ++n2;
        }
        iProjectArray = connectorProjects;
        n = connectorProjects.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            if (referencedProjects.contains(project)) {
                projectName = project.getName();
                classNameList = new String[]{"JavaFile" + fileCount++, "Javafile" + fileCount++};
                JavaFileTestingUtilities.addJavaFilesToConnector(projectName, classNameList, CONNECTOR_PACKAGE);
                connectorProjectJavaFiles.put(projectName, classNameList);
            }
            ++n2;
        }
        iProjectArray = ejbProjects;
        n = ejbProjects.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            if (referencedProjects.contains(project)) {
                projectName = project.getName();
                classNameList = new String[]{"JavaFile" + fileCount++, "Javafile" + fileCount++};
                JavaFileTestingUtilities.addJavaFilesToEJB(projectName, classNameList, EJB_PACKAGE);
                ejbProjectJavaFiles.put(projectName, classNameList);
            }
            ++n2;
        }
        iProjectArray = utilityProjects;
        n = utilityProjects.length;
        n2 = 0;
        while (n2 < n) {
            project = iProjectArray[n2];
            if (referencedProjects.contains(project)) {
                projectName = project.getName();
                classNameList = new String[]{"JavaFile" + fileCount++, "Javafile" + fileCount++};
                JavaFileTestingUtilities.addJavaFilesToUtility(projectName, classNameList, UTILITY_PACKAGE);
                utilityProjectJavaFiles.put(projectName, classNameList);
            }
            ++n2;
        }
    }

    public static void verifyAllJavaFilesExportedToProjectsInEAR(String earArchivePath, boolean withClassFiles, boolean withSource) throws Exception {
        IArchive earArchive = null;
        try {
            earArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(earArchivePath));
            List resources = earArchive.getArchiveResources();
            String extension = null;
            IArchive nestedArchive = null;
            String nestedArchiveName = null;
            String[] classNames = null;
            for (IArchiveResource resource : resources) {
                extension = resource.getPath().getFileExtension();
                if (extension == null) continue;
                if (extension.equals(WAR_EXTENSION)) {
                    nestedArchive = earArchive.getNestedArchive(resource);
                    nestedArchiveName = nestedArchive.getPath().removeFileExtension().lastSegment();
                    classNames = webProjectJavaFiles.get(nestedArchiveName);
                    JavaFileTestingUtilities.verifyJavaFilesInWAR(nestedArchive, classNames, WEB_PACKAGE, withClassFiles, withSource);
                    continue;
                }
                if (extension.equals(JAR_EXTENSION)) {
                    nestedArchive = earArchive.getNestedArchive(resource);
                    nestedArchiveName = nestedArchive.getPath().removeFileExtension().lastSegment();
                    classNames = appClientProjectJavaFiles.get(nestedArchiveName);
                    if (classNames == null) {
                        classNames = ejbProjectJavaFiles.get(nestedArchiveName);
                        if (classNames != null) {
                            JavaFileTestingUtilities.verifyJavaFilesInJAR(nestedArchive, classNames, EJB_PACKAGE, withClassFiles, withSource);
                            continue;
                        }
                        classNames = utilityProjectJavaFiles.get(nestedArchiveName);
                        JavaFileTestingUtilities.verifyJavaFilesInJAR(nestedArchive, classNames, UTILITY_PACKAGE, withClassFiles, withSource);
                        continue;
                    }
                    JavaFileTestingUtilities.verifyJavaFilesInJAR(nestedArchive, classNames, APP_CLIENT_PACKAGE, withClassFiles, withSource);
                    continue;
                }
                if (!extension.equals(RAR_EXTENSION)) continue;
                nestedArchive = earArchive.getNestedArchive(resource);
                nestedArchiveName = nestedArchive.getPath().removeFileExtension().lastSegment();
                classNames = connectorProjectJavaFiles.get(nestedArchiveName);
                JavaFileTestingUtilities.verifyJavaFilesInRAR(nestedArchive, classNames, CONNECTOR_PACKAGE, withClassFiles, withSource);
            }
        }
        finally {
            if (earArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(earArchive);
            }
        }
    }

    public static void clearJavaFilesForEAR() {
        appClientProjectJavaFiles.clear();
        ejbProjectJavaFiles.clear();
        connectorProjectJavaFiles.clear();
        webProjectJavaFiles.clear();
    }
}

