/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;

public class JdtChangeListenerWithSemaphore
implements IElementChangedListener {
    private final Semaphore s;
    private final int expectedEvents;
    private final List<ElementChangedEvent> receivedEvents;

    public JdtChangeListenerWithSemaphore(int expectedEvents) throws InterruptedException {
        this.expectedEvents = expectedEvents;
        this.s = new Semaphore(1);
        this.s.acquire();
        this.receivedEvents = Collections.synchronizedList(new LinkedList());
    }

    public boolean waitForEvents() throws InterruptedException {
        return this.s.tryAcquire(5L, TimeUnit.SECONDS);
    }

    public synchronized int getEvents() {
        return this.receivedEvents.size();
    }

    public void elementChanged(ElementChangedEvent event) {
        this.receivedEvents.add(event);
        if (this.receivedEvents.size() > this.expectedEvents) {
            throw new IllegalStateException("The expected events were already reached");
        }
        if (this.expectedEvents == this.receivedEvents.size()) {
            this.s.release();
        }
    }
}

