/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MethodParams;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;
import org.eclipse.jst.jee.model.internal.mergers.SessionBeanMerger;

public class SessionMergerTest
extends TestCase {
    public void testTimeOutComplexNoParams() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        baseBean1.setTimeoutMethod(base);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodName().equals(value));
        SessionMergerTest.assertNull((Object)baseBean1.getTimeoutMethod().getMethodParams());
    }

    public void testTimeOutComplexWithParams() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        params.getMethodParams().add("java.lang.String");
        base.setMethodParams(params);
        NamedMethodType merge = EjbFactory.eINSTANCE.createNamedMethodType();
        merge.setMethodName(value);
        baseBean1.setTimeoutMethod(base);
        toMergeBean1.setTimeoutMethod(merge);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodName().equals(value));
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodParams());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getTimeoutMethod().getMethodParams().getMethodParams().size());
    }

    public void testTimeOutComplexWithParams2() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        NamedMethodType merge = EjbFactory.eINSTANCE.createNamedMethodType();
        merge.setMethodName(value);
        baseBean1.setTimeoutMethod(base);
        toMergeBean1.setTimeoutMethod(merge);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodName().equals(value));
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodParams());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testTimeOutBase() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        baseBean1.setTimeoutMethod(base);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodName().equals(value));
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodParams());
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testTimeOutMerge() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        NamedMethodType base = EjbFactory.eINSTANCE.createNamedMethodType();
        String value = "getMethod";
        base.setMethodName(value);
        MethodParams params = EjbFactory.eINSTANCE.createMethodParams();
        String string = "java.lang.String";
        params.getMethodParams().add(string);
        base.setMethodParams(params);
        baseBean1.setTimeoutMethod(base);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getTimeoutMethod());
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getTimeoutMethod().getMethodName().equals(value));
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getTimeoutMethod().getMethodParams());
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getTimeoutMethod().getMethodParams().getMethodParams().get(0).equals(string));
    }

    public void testSecurityIdentityBase() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        toMergeBean1.setSecurityIdentities(type);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getSecurityIdentities().getUseCallerIdentity());
    }

    public void testSecurityIdentityMerge() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        toMergeBean1.setSecurityIdentities(type);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getSecurityIdentities().getUseCallerIdentity());
    }

    public void testSecurityIdentitySame() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        toMergeBean1.setSecurityIdentities(type);
        baseBean1.setSecurityIdentities(type);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getSecurityIdentities().getUseCallerIdentity());
    }

    public void testSecurityIdentityComplex() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityIdentityType type = EjbFactory.eINSTANCE.createSecurityIdentityType();
        type.setUseCallerIdentity(JavaeeFactory.eINSTANCE.createEmptyType());
        SecurityIdentityType type2 = EjbFactory.eINSTANCE.createSecurityIdentityType();
        RunAs createRunAs = JavaeeFactory.eINSTANCE.createRunAs();
        createRunAs.setRoleName("ttt");
        type2.setRunAs(createRunAs);
        toMergeBean1.setSecurityIdentities(type);
        baseBean1.setSecurityIdentities(type2);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNull((Object)baseBean1.getSecurityIdentities().getUseCallerIdentity());
        SessionMergerTest.assertNotNull((Object)baseBean1.getSecurityIdentities().getRunAs().getRoleName());
    }

    public void testTransactionTypeBase() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)toMergeBean1.getTransactionType());
    }

    public void testTransactionTypeMerge() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        baseBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)toMergeBean1.getTransactionType());
    }

    public void testTransactionTypeSame() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        baseBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertEquals((Object)TransactionType.BEAN_LITERAL, (Object)toMergeBean1.getTransactionType());
    }

    public void testTransactionTypeComplex() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.setTransactionType(TransactionType.CONTAINER_LITERAL);
        baseBean1.setTransactionType(TransactionType.BEAN_LITERAL);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertEquals((Object)TransactionType.CONTAINER_LITERAL, (Object)toMergeBean1.getTransactionType());
    }

    public void testInitMethodBase() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        InitMethodType methodType = this.generateInitType(value, new String[]{mParam1});
        baseBean1.getInitMethods().add(methodType);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getInitMethods());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getInitMethods().size());
        InitMethodType aMethod = this.findInitMethod(baseBean1.getInitMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testInitMethodToMerge() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        InitMethodType methodType = this.generateInitType(value, new String[]{mParam1});
        baseBean1.getInitMethods().add(methodType);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getInitMethods());
        SessionMergerTest.assertEquals((int)1, (int)toMergeBean1.getInitMethods().size());
        InitMethodType aMethod = this.findInitMethod(toMergeBean1.getInitMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testInitMethodSame() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        InitMethodType methodType = this.generateInitType(value, new String[]{mParam1});
        baseBean1.getInitMethods().add(methodType);
        toMergeBean1.getInitMethods().add(methodType);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getInitMethods());
        SessionMergerTest.assertEquals((int)1, (int)toMergeBean1.getInitMethods().size());
        InitMethodType aMethod = this.findInitMethod(toMergeBean1.getInitMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testInitMethodComplex() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        InitMethodType methodType = this.generateInitType(value, new String[]{mParam1});
        InitMethodType methodType2 = this.generateInitType(value, new String[]{mParam1, mParam1});
        InitMethodType methodType3 = this.generateInitType(value, new String[]{mParam1});
        baseBean1.getInitMethods().add(methodType);
        toMergeBean1.getInitMethods().add(methodType2);
        toMergeBean1.getInitMethods().add(methodType3);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getInitMethods());
        SessionMergerTest.assertEquals((int)2, (int)toMergeBean1.getInitMethods().size());
        InitMethodType aMethod = this.findInitMethod(toMergeBean1.getInitMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
        InitMethodType aMethod2 = this.findInitMethod(toMergeBean1.getInitMethods(), methodType2.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod2);
    }

    private InitMethodType findInitMethod(List namedMethodsBase, NamedMethodType object) {
        for (Object base : namedMethodsBase) {
            InitMethodType tmpBase = (InitMethodType)base;
            if (!tmpBase.getBeanMethod().getMethodName().equals(object.getMethodName()) || !this.sameParams(tmpBase.getBeanMethod().getMethodParams(), object.getMethodParams())) continue;
            return (InitMethodType)base;
        }
        return null;
    }

    private boolean sameParams(MethodParams methodParams, MethodParams methodParams2) {
        if (methodParams == null && methodParams2 == null) {
            return true;
        }
        if (methodParams == null | methodParams2 == null) {
            return false;
        }
        if (methodParams.getMethodParams().size() != methodParams2.getMethodParams().size()) {
            return false;
        }
        int i = 0;
        while (i < methodParams.getMethodParams().size()) {
            if (!methodParams.getMethodParams().get(i).equals(methodParams2.getMethodParams().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private InitMethodType generateInitType(String name, String[] parameters) {
        InitMethodType methodType3 = EjbFactory.eINSTANCE.createInitMethodType();
        NamedMethodType nMethodType3 = EjbFactory.eINSTANCE.createNamedMethodType();
        nMethodType3.setMethodName(name);
        MethodParams params3 = EjbFactory.eINSTANCE.createMethodParams();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                params3.getMethodParams().add(parameters[i]);
                ++i;
            }
            nMethodType3.setMethodParams(params3);
        }
        methodType3.setBeanMethod(nMethodType3);
        return methodType3;
    }

    private RemoveMethodType generateRemoveMethodType(String name, String[] parameters) {
        RemoveMethodType methodType3 = EjbFactory.eINSTANCE.createRemoveMethodType();
        NamedMethodType nMethodType3 = EjbFactory.eINSTANCE.createNamedMethodType();
        nMethodType3.setMethodName(name);
        MethodParams params3 = EjbFactory.eINSTANCE.createMethodParams();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                params3.getMethodParams().add(parameters[i]);
                ++i;
            }
            nMethodType3.setMethodParams(params3);
        }
        methodType3.setBeanMethod(nMethodType3);
        return methodType3;
    }

    public void testRemoveMethodBase() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        RemoveMethodType methodType = this.generateRemoveMethodType(value, new String[]{mParam1});
        baseBean1.getRemoveMethods().add(methodType);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getRemoveMethods());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getRemoveMethods().size());
        RemoveMethodType aMethod = this.findRemoveMethod(baseBean1.getRemoveMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testRemoveMethodToMerge() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        RemoveMethodType methodType = this.generateRemoveMethodType(value, new String[]{mParam1});
        baseBean1.getRemoveMethods().add(methodType);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getRemoveMethods());
        SessionMergerTest.assertEquals((int)1, (int)toMergeBean1.getRemoveMethods().size());
        RemoveMethodType aMethod = this.findRemoveMethod(toMergeBean1.getRemoveMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testRemoveMethodSame() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        RemoveMethodType methodType = this.generateRemoveMethodType(value, new String[]{mParam1});
        baseBean1.getRemoveMethods().add(methodType);
        toMergeBean1.getRemoveMethods().add(methodType);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getRemoveMethods());
        SessionMergerTest.assertEquals((int)1, (int)toMergeBean1.getRemoveMethods().size());
        RemoveMethodType aMethod = this.findRemoveMethod(toMergeBean1.getRemoveMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
    }

    public void testRemoveMethodComplex() throws ModelException {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String value = "getMethod";
        String mParam1 = "java.lang.String";
        RemoveMethodType methodType = this.generateRemoveMethodType(value, new String[]{mParam1});
        RemoveMethodType methodType2 = this.generateRemoveMethodType(value, new String[]{mParam1, mParam1});
        RemoveMethodType methodType3 = this.generateRemoveMethodType(value, new String[]{mParam1});
        baseBean1.getRemoveMethods().add(methodType);
        toMergeBean1.getRemoveMethods().add(methodType2);
        toMergeBean1.getRemoveMethods().add(methodType3);
        new SessionBeanMerger(toMergeBean1, baseBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)toMergeBean1.getRemoveMethods());
        SessionMergerTest.assertEquals((int)2, (int)toMergeBean1.getRemoveMethods().size());
        RemoveMethodType aMethod = this.findRemoveMethod(toMergeBean1.getRemoveMethods(), methodType.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod);
        RemoveMethodType aMethod2 = this.findRemoveMethod(toMergeBean1.getRemoveMethods(), methodType2.getBeanMethod());
        SessionMergerTest.assertNotNull((Object)aMethod2);
    }

    private RemoveMethodType findRemoveMethod(List namedMethodsBase, NamedMethodType object) {
        for (Object base : namedMethodsBase) {
            RemoveMethodType tmpBase = (RemoveMethodType)base;
            if (!tmpBase.getBeanMethod().getMethodName().equals(object.getMethodName()) || !this.sameParams(tmpBase.getBeanMethod().getMethodParams(), object.getMethodParams())) continue;
            return (RemoveMethodType)base;
        }
        return null;
    }

    public void testSecurityRoleRefsBase() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityRoleRef ref = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
        String name0 = "roleName1";
        ref.setRoleName(name0);
        String link0 = "roleLink1";
        ref.setRoleLink(link0);
        baseBean1.getSecurityRoleRefs().add(ref);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertNotNull((Object)baseBean1.getSecurityRoleRefs());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getSecurityRoleRefs().size());
        SessionMergerTest.assertNotNull((Object)this.getSecurityRoleRefByName(baseBean1.getSecurityRoleRefs(), name0));
    }

    private SecurityRoleRef getSecurityRoleRefByName(List securityRoleRefs, String name0) {
        for (Object object : securityRoleRefs) {
            SecurityRoleRef sr = (SecurityRoleRef)object;
            if (!sr.getRoleName().equals(name0)) continue;
            return sr;
        }
        return null;
    }

    public void testSecurityRoleRefsMerge() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityRoleRef ref = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
        String name0 = "roleName1";
        ref.setRoleName(name0);
        String link0 = "roleLink1";
        ref.setRoleLink(link0);
        toMergeBean1.getSecurityRoleRefs().add(ref);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getSecurityRoleRefs().size());
        SessionMergerTest.assertNotNull((Object)this.getSecurityRoleRefByName(baseBean1.getSecurityRoleRefs(), name0));
    }

    public void testSecurityRoleRefsSame() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityRoleRef ref = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
        String name0 = "roleName1";
        ref.setRoleName(name0);
        String link0 = "roleLink1";
        ref.setRoleLink(link0);
        baseBean1.getSecurityRoleRefs().add(ref);
        toMergeBean1.getSecurityRoleRefs().add(ref);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getSecurityRoleRefs().size());
        SessionMergerTest.assertNotNull((Object)this.getSecurityRoleRefByName(baseBean1.getSecurityRoleRefs(), name0));
    }

    public void testSecurityRoleRefsComplex() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        SecurityRoleRef ref = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
        String name0 = "roleName1";
        ref.setRoleName(name0);
        String link0 = "roleLink1";
        ref.setRoleLink(link0);
        SecurityRoleRef ref2 = JavaeeFactory.eINSTANCE.createSecurityRoleRef();
        String name1 = "roleName2";
        ref2.setRoleName(name1);
        ref2.setRoleLink(link0);
        baseBean1.getSecurityRoleRefs().add(ref);
        toMergeBean1.getSecurityRoleRefs().add(ref2);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)2, (int)baseBean1.getSecurityRoleRefs().size());
        SessionMergerTest.assertNotNull((Object)this.getSecurityRoleRefByName(baseBean1.getSecurityRoleRefs(), name0));
        SessionMergerTest.assertNotNull((Object)this.getSecurityRoleRefByName(baseBean1.getSecurityRoleRefs(), name1));
    }

    public void testBeanClassBase() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String expected = "test.Test";
        baseBean1.setEjbClass(expected);
        String notExpected = "test.Test2";
        toMergeBean1.setEjbClass(notExpected);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)expected, (String)baseBean1.getEjbClass());
    }

    public void testBeanClassMerge() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String expected = "test.Test";
        toMergeBean1.setEjbClass(expected);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)expected, (String)baseBean1.getEjbClass());
    }

    public void testBeanClassSame() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String expected = "test.Test";
        baseBean1.setEjbClass(expected);
        toMergeBean1.setEjbClass(expected);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)expected, (String)baseBean1.getEjbClass());
    }

    public void testBussinessInterfacesBase() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        baseBean1.getBusinessLocals().add("intfs1");
        baseBean1.getBusinessRemotes().add("intfs2");
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessLocals().size());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessRemotes().size());
        SessionMergerTest.assertEquals((Object)"intfs1", baseBean1.getBusinessLocals().get(0));
        SessionMergerTest.assertEquals((Object)"intfs2", baseBean1.getBusinessRemotes().get(0));
    }

    public void testBussinessInterfacesMerge() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.getBusinessLocals().add("intfs1");
        toMergeBean1.getBusinessRemotes().add("intfs2");
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessLocals().size());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessRemotes().size());
        SessionMergerTest.assertEquals((Object)"intfs1", baseBean1.getBusinessLocals().get(0));
        SessionMergerTest.assertEquals((Object)"intfs2", baseBean1.getBusinessRemotes().get(0));
    }

    public void testBussinessInterfacesSame() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.getBusinessLocals().add("intfs1");
        toMergeBean1.getBusinessRemotes().add("intfs2");
        baseBean1.getBusinessLocals().add("intfs1");
        baseBean1.getBusinessRemotes().add("intfs2");
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessLocals().size());
        SessionMergerTest.assertEquals((int)1, (int)baseBean1.getBusinessRemotes().size());
        SessionMergerTest.assertEquals((Object)"intfs1", baseBean1.getBusinessLocals().get(0));
        SessionMergerTest.assertEquals((Object)"intfs2", baseBean1.getBusinessRemotes().get(0));
    }

    public void testBussinessInterfacesComplex() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        toMergeBean1.getBusinessLocals().add("intfs1");
        toMergeBean1.getBusinessRemotes().add("intfs2");
        toMergeBean1.getBusinessLocals().add("intfs3");
        toMergeBean1.getBusinessRemotes().add("intfs4");
        toMergeBean1.getBusinessLocals().add("intfs5");
        toMergeBean1.getBusinessRemotes().add("intfs6");
        baseBean1.getBusinessLocals().add("intfs1");
        baseBean1.getBusinessRemotes().add("intfs9");
        baseBean1.getBusinessLocals().add("intfs0");
        baseBean1.getBusinessRemotes().add("intfs2");
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((int)4, (int)baseBean1.getBusinessLocals().size());
        SessionMergerTest.assertEquals((int)4, (int)baseBean1.getBusinessRemotes().size());
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessLocals().contains("intfs1"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessLocals().contains("intfs3"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessLocals().contains("intfs5"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessLocals().contains("intfs0"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessRemotes().contains("intfs2"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessRemotes().contains("intfs4"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessRemotes().contains("intfs6"));
        SessionMergerTest.assertTrue((boolean)baseBean1.getBusinessRemotes().contains("intfs9"));
    }

    public void test2xInterfacesBase() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String l = "local1";
        baseBean1.setLocal(l);
        String lh = "localhome1";
        baseBean1.setLocalHome(lh);
        String r = "remote1";
        baseBean1.setRemote(r);
        String h = "home1";
        baseBean1.setHome(h);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)l, (String)baseBean1.getLocal());
        SessionMergerTest.assertEquals((String)lh, (String)baseBean1.getLocalHome());
        SessionMergerTest.assertEquals((String)r, (String)baseBean1.getRemote());
        SessionMergerTest.assertEquals((String)h, (String)baseBean1.getHome());
    }

    public void test2xInterfacesMerge() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String l = "local1";
        toMergeBean1.setLocal(l);
        String lh = "localhome1";
        toMergeBean1.setLocalHome(lh);
        String r = "remote1";
        toMergeBean1.setRemote(r);
        String h = "home1";
        toMergeBean1.setHome(h);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)l, (String)baseBean1.getLocal());
        SessionMergerTest.assertEquals((String)lh, (String)baseBean1.getLocalHome());
        SessionMergerTest.assertEquals((String)r, (String)baseBean1.getRemote());
        SessionMergerTest.assertEquals((String)h, (String)baseBean1.getHome());
    }

    public void test2xInterfacesSame() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String l = "local1";
        baseBean1.setLocal(l);
        toMergeBean1.setLocal(l);
        String lh = "localhome1";
        baseBean1.setLocalHome(lh);
        toMergeBean1.setLocalHome(lh);
        String r = "remote1";
        baseBean1.setRemote(r);
        toMergeBean1.setRemote(r);
        String h = "home1";
        baseBean1.setHome(h);
        toMergeBean1.setHome(h);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)l, (String)baseBean1.getLocal());
        SessionMergerTest.assertEquals((String)lh, (String)baseBean1.getLocalHome());
        SessionMergerTest.assertEquals((String)r, (String)baseBean1.getRemote());
        SessionMergerTest.assertEquals((String)h, (String)baseBean1.getHome());
    }

    public void test2xInterfacesComplex() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String l = "local1";
        baseBean1.setLocal(l);
        String lh = "localhome1";
        toMergeBean1.setLocalHome(lh);
        String r = "remote1";
        baseBean1.setRemote(r);
        String h = "home1";
        toMergeBean1.setHome(h);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)l, (String)baseBean1.getLocal());
        SessionMergerTest.assertEquals((String)lh, (String)baseBean1.getLocalHome());
        SessionMergerTest.assertEquals((String)r, (String)baseBean1.getRemote());
        SessionMergerTest.assertEquals((String)h, (String)baseBean1.getHome());
    }

    public void test2xInterfacesComplexInversed() throws Exception {
        SessionBean baseBean1 = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean toMergeBean1 = EjbFactory.eINSTANCE.createSessionBean();
        baseBean1.setEjbName("name");
        toMergeBean1.setEjbName("name");
        String l = "local1";
        toMergeBean1.setLocal(l);
        String lh = "localhome1";
        baseBean1.setLocalHome(lh);
        String r = "remote1";
        toMergeBean1.setRemote(r);
        String h = "home1";
        baseBean1.setHome(h);
        new SessionBeanMerger(baseBean1, toMergeBean1, 0).process();
        SessionMergerTest.assertEquals((String)l, (String)baseBean1.getLocal());
        SessionMergerTest.assertEquals((String)lh, (String)baseBean1.getLocalHome());
        SessionMergerTest.assertEquals((String)r, (String)baseBean1.getRemote());
        SessionMergerTest.assertEquals((String)h, (String)baseBean1.getHome());
    }
}

