/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.modulecore;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class FlexibleProjectBuilderTest
extends TestCase {
    public static final String MODULE__RESOURCE_URI_PROTOCOL = "module:/resource/";
    private IProject project;
    private EMFWorkbenchContext emfContext;

    public FlexibleProjectBuilderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new FlexibleProjectBuilderTest("testFlexibleProjectBuilderOutput"));
        return suite;
    }

    public void setUp() throws Exception {
        IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
        desc.setAutoBuilding(false);
        ResourcesPlugin.getWorkspace().setDescription(desc);
        this.getProjectForWebModuleAndLocalWebLib().delete(true, null);
        this.getProjectForRemoteWebLib().delete(true, null);
        super.setUp();
    }

    public void testFlexibleProjectBuilderOutput() throws Exception {
        this.setupContent();
        this.buildProjects();
    }

    private void buildProjects() {
        try {
            ResourcesPlugin.getWorkspace().build(6, null);
        }
        catch (Exception exception) {}
    }

    public void setupContent() throws Exception {
        StructureEdit localModuleCore = null;
        try {
            this.getProjectForWebModuleAndLocalWebLib();
            IProject containingProject = StructureEdit.getContainingProject((URI)this.getWebModuleURI());
            localModuleCore = StructureEdit.getStructureEditForWrite((IProject)containingProject);
            this.createLocalModules(localModuleCore);
            this.getProjectForRemoteWebLib();
            WorkbenchComponent webModule = localModuleCore.getComponent();
            this.addDependentModule(webModule, (IPath)new Path("WEB-INF/lib"), this.getLocalWebLibraryModuleURI());
            this.addDependentModule(webModule, (IPath)new Path("WEB-INF/lib"), this.getRemoteWebLibraryModuleURI());
            localModuleCore.saveIfNecessary(null);
        }
        finally {
            if (localModuleCore != null) {
                localModuleCore.dispose();
            }
        }
    }

    public IProject getProjectForWebModuleAndLocalWebLib() throws Exception {
        return this.getWebProject(this.getWebModuleAndLocalWebLibModuleProjectName());
    }

    public IProject getProjectForRemoteWebLib() throws Exception {
        return this.getJavaProject(this.getRemoteWebLibModuleProjectName());
    }

    public String getWebModuleAndLocalWebLibModuleProjectName() {
        return "MyModulesProject";
    }

    public String getRemoteWebLibModuleProjectName() {
        return "RemoteWebLibProject";
    }

    public IProject getWebProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            project = this.createWebProject(aProjectName);
        }
        return project;
    }

    public IProject getJavaProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        project.exists();
        return project;
    }

    public IProject createWebProject(String aProjectName) throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!this.project.exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    public void addResource(WorkbenchComponent aModule, IResource aSourceFile, String aDeployPath) {
        ComponentResource resource = ComponentcoreFactory.eINSTANCE.createComponentResource();
        resource.setSourcePath(aSourceFile.getFullPath());
        resource.setRuntimePath((IPath)new Path(aDeployPath));
        aModule.getResources().add((Object)resource);
    }

    public WorkbenchComponent addWorkbenchModule(ProjectComponents theModules, String aDeployedName, URI aHandle) {
        WorkbenchComponent module = ComponentcoreFactory.eINSTANCE.createWorkbenchComponent();
        module.setName(aDeployedName);
        theModules.getComponents().add((Object)module);
        return module;
    }

    public void addDependentModule(WorkbenchComponent aModule, IPath aDeployedPath, URI aHandle) {
        ReferencedComponent aClasspathDependentModule = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
        aClasspathDependentModule.setRuntimePath(aDeployedPath);
        aClasspathDependentModule.setHandle(aHandle);
        aModule.getReferencedComponents().add((Object)aClasspathDependentModule);
    }

    public void createLocalModules(StructureEdit moduleCore) throws Exception {
        ProjectComponents projectModules = moduleCore.getComponentModelRoot();
        WorkbenchComponent webLibraryModule = this.addWorkbenchModule(projectModules, this.getLocalWebLibraryDeployedName(), this.getLocalWebLibraryModuleURI());
        IFolder localWebLibrary = this.getProjectForWebModuleAndLocalWebLib().getFolder(this.getLocalWebLibraryFolderName());
        if (!localWebLibrary.exists()) {
            localWebLibrary.create(true, true, null);
        }
        this.addResource(webLibraryModule, (IResource)localWebLibrary, "/");
    }

    public URI getWebModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getWebModuleDeployedName()));
    }

    public URI getLocalWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getLocalWebLibraryDeployedName()));
    }

    public URI getRemoteWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getRemoteWebLibModuleProjectName() + '/' + this.getRemoteWebLibraryDeployedName()));
    }

    public String getWebModuleDeployedName() {
        return String.valueOf(this.getWebModuleAndLocalWebLibModuleProjectName()) + ".war";
    }

    public String getLocalWebLibraryDeployedName() {
        return "LocalWebLibrary.jar";
    }

    public String getRemoteWebLibraryDeployedName() {
        return String.valueOf(this.getRemoteWebLibModuleProjectName()) + ".jar";
    }

    public String getModulesFolder() {
        return "MyWebModule";
    }

    public String getTestResourcePath() {
        return "WEB-INF/web.xml";
    }

    public String getLocalWebLibraryFolderName() {
        return "WebLibraryContents";
    }
}

