/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.JaxRPCMapArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JaxRPCMapArtifactEditFVTest
extends TestCase {
    private IProject webProject;
    private String webModuleName;
    private String serverContextData = "WebContentTest";

    public JaxRPCMapArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.webProject = TestWorkspace.getTargetProject("WebArtifactEditTest");
            this.webModuleName = "WebArtifactEditModule";
        } else {
            JaxRPCMapArtifactEditFVTest.fail();
        }
    }

    private void updateClient(WebServices client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private void pass() {
        JaxRPCMapArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        JaxRPCMapArtifactEdit jaxedit = null;
        WebArtifactEdit webedit = null;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.webProject, (String)this.webModuleName);
        jaxedit = JaxRPCMapArtifactEdit.getJaxRPCMapArtifactEditForRead((IVirtualComponent)comp);
        jaxedit.getDeploymentDescriptorRoot("WebArtifactEditTest/WebArtifactEditModule/WebContent/WEB-INF/testmap.xml");
        jaxedit.dispose();
        webedit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)comp);
        webedit.getWebApp();
        webedit.saveIfNecessary(null);
        webedit.dispose();
    }

    private static void pass(WebServices webservice) {
        boolean pass = webservice.getDescription().equals("FVT Description Test") && webservice.getDisplayName().equals("FVT DisplayName Test") && webservice.getLargeIcon().equals("fvtLargeIcon.gif");
        JaxRPCMapArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

