/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class EJBArtifactEditFVTest
extends TestCase {
    private IProject ejbProject;
    private String ejbModuleName;

    public EJBArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.ejbProject = TestWorkspace.getTargetProject("EJBArtifactEditTest");
            this.ejbModuleName = "EJBArtifactEditModule";
        } else {
            EJBArtifactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    EJBArtifactEditFVTest.this.pass();
                }
            });
            EJBJar client = edit.getEJBJar();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void updateClient(EJBJar client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private void pass() {
        EJBArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
            EJBJar ejb = edit.getEJBJar();
            EJBArtifactEditFVTest.pass(ejb);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(EJBJar ejb) {
        boolean pass = ejb.getDescription().equals("FVT Description Test") && ejb.getDisplayName().equals("FVT DisplayName Test") && ejb.getLargeIcon().equals("fvtLargeIcon.gif");
        EJBArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        EJBArtifactEdit edit = null;
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentResource createResourceComponent() {
        ComponentResource resourceComponent = ComponentcoreFactory.eINSTANCE.createComponentResource();
        File testFile = TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH.toFile();
        if (testFile.exists()) {
            resourceComponent.setRuntimePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
            resourceComponent.setSourcePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
        } else {
            EJBArtifactEditFVTest.fail((String)"Missing: TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH");
        }
        return resourceComponent;
    }
}

