/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public class ProjectClasspathRefactoringTests
extends AbstractTests {
    public ProjectClasspathRefactoringTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project Classpath Refactoring Tests");
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testSourcePathAdditionWeb"));
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testSourcePathRemovalWeb"));
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testSourcePathAdditionUtil"));
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testSourcePathRemovalUtil"));
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testWebContentRename"));
        suite.addTest((Test)new ProjectClasspathRefactoringTests("testEarContentRename"));
        return suite;
    }

    public void testSourcePathAdditionWeb() throws Exception {
        ProjectClasspathRefactoringTests.testSourcePathAddition(ProjectUtil.createWebProject("TestWeb", null));
    }

    public void testSourcePathAdditionUtil() throws Exception {
        ProjectClasspathRefactoringTests.testSourcePathAddition(ProjectUtil.createUtilityProject("TestUtil", null));
    }

    private static void testSourcePathAddition(IProject project) throws Exception {
        Path srcPath = new Path("src");
        Path newSrcPath = new Path("newSrc");
        DependencyUtil.verifyComponentMapping(project, (IPath)srcPath, true);
        DependencyUtil.verifyComponentMapping(project, (IPath)newSrcPath, false);
        ProjectClasspathRefactoringTests.assertTrue((String)("Failed to add new source path " + newSrcPath), (boolean)DependencyUtil.addJavaSrcPath(project, (IPath)newSrcPath));
        DependencyUtil.verifyComponentMapping(project, (IPath)srcPath, true);
        DependencyUtil.verifyComponentMapping(project, (IPath)newSrcPath, true);
    }

    public void testSourcePathRemovalWeb() throws Exception {
        ProjectClasspathRefactoringTests.testSourcePathRemoval(ProjectUtil.createWebProject("TestWeb", null));
    }

    public void testSourcePathRemovalUtil() throws Exception {
        ProjectClasspathRefactoringTests.testSourcePathRemoval(ProjectUtil.createUtilityProject("TestUtil", null));
    }

    private static void testSourcePathRemoval(IProject project) throws Exception {
        Path srcPath = new Path("src");
        DependencyUtil.verifyComponentMapping(project, (IPath)srcPath, true);
        ProjectClasspathRefactoringTests.assertTrue((String)("Failed to remove src path " + srcPath), (boolean)DependencyUtil.removeJavaSrcPath(project, (IPath)srcPath));
        DependencyUtil.verifyComponentMapping(project, (IPath)srcPath, false);
    }

    public void testWebContentRename() throws Exception {
        IProject webProject = ProjectUtil.createWebProject("TestWeb", null);
        Path webContent = new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent"));
        Path newWebContent = new Path("WebContent2");
        DependencyUtil.verifyComponentMapping(webProject, (IPath)webContent, (IPath)Path.ROOT, true);
        DependencyUtil.verifyComponentMapping(webProject, (IPath)newWebContent, (IPath)Path.ROOT, false);
        IFolder folder = webProject.getFolder((IPath)webContent);
        folder.move(webProject.getFullPath().append((IPath)newWebContent), true, null);
        DependencyUtil.waitForComponentRefactoringJobs();
        DependencyUtil.verifyComponentMapping(webProject, (IPath)webContent, (IPath)Path.ROOT, false);
        DependencyUtil.verifyComponentMapping(webProject, (IPath)newWebContent, (IPath)Path.ROOT, true);
    }

    public void testEarContentRename() throws Exception {
        IProject earProject = ProjectUtil.createEARProject("TestEAR");
        Path earContent = new Path(J2EEPlugin.getDefault().getJ2EEPreferences().getString("earContent"));
        Path newEarContent = new Path("EarContent2");
        DependencyUtil.verifyComponentMapping(earProject, (IPath)earContent, (IPath)Path.ROOT, true);
        DependencyUtil.verifyComponentMapping(earProject, (IPath)newEarContent, (IPath)Path.ROOT, false);
        IFolder folder = earProject.getFolder((IPath)earContent);
        folder.move(earProject.getFullPath().append((IPath)newEarContent), true, null);
        DependencyUtil.waitForComponentRefactoringJobs();
        DependencyUtil.verifyComponentMapping(earProject, (IPath)earContent, (IPath)Path.ROOT, false);
        DependencyUtil.verifyComponentMapping(earProject, (IPath)newEarContent, (IPath)Path.ROOT, true);
    }
}

