/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFValidationContext;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.strategy.ContainmentValidatingStrategy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestJSPSemanticsValidator_Containment
extends TestCase {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IFile _jspFragmentFile;
    private IStructuredModel _jspStructuredModel;
    private IStructuredDocument _jspStructuredDocument;
    private IStructuredModel _jspFragStructuredModel;
    private IStructuredDocument _jspFragStructuredDocument;

    protected void setUp() throws Exception {
        super.setUp();
        this._testEnv = new WebProjectTestEnvironment("ContainmentValidationTest" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        this._testEnv.createProject(false);
        TestJSPSemanticsValidator_Containment.assertNotNull((Object)this._testEnv);
        TestJSPSemanticsValidator_Containment.assertNotNull((Object)this._testEnv.getTestProject());
        TestJSPSemanticsValidator_Containment.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsf-core.tld.data", "META-INF/jsf-core.tld");
        this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/myfaces_html.tld.data", "META-INF/myfaces_html.tld");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testContainment.jsp.data", "testContainment.jsp");
        this._jspStructuredModel = StructuredModelManager.getModelManager().getModelForRead(this._jspFile);
        this._jspStructuredDocument = this._jspStructuredModel.getStructuredDocument();
        this._jspFragmentFile = (IFile)this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testContainment.jsp.data", "testContainment.jsf");
        this._jspFragStructuredModel = StructuredModelManager.getModelManager().getModelForRead(this._jspFile);
        this._jspFragStructuredDocument = this._jspFragStructuredModel.getStructuredDocument();
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._jspStructuredModel != null) {
            this._jspStructuredModel.releaseFromRead();
        }
        if (this._jspFragStructuredModel != null) {
            this._jspFragStructuredModel.releaseFromRead();
        }
    }

    public void testContainmentInJSP() throws Exception {
        MockValidationReporter reporter = new MockValidationReporter();
        ContainmentValidatingStrategy validator = this.createContainmentValidator(this._jspFile, (IJSFViewValidator.IValidationReporter)reporter);
        IStructuredDocumentContext correctlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 487);
        this.checkTag(correctlyNested, validator, reporter, 0);
        reporter.reset();
        IStructuredDocumentContext firstIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 538);
        this.checkTag(firstIncorrectlyNested, validator, reporter, 1);
        reporter.reset();
        IStructuredDocumentContext secondIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 568);
        this.checkTag(secondIncorrectlyNested, validator, reporter, 0);
        reporter.reset();
    }

    public void testContainmentInJSPFrag() throws Exception {
        MockValidationReporter reporter = new MockValidationReporter();
        ContainmentValidatingStrategy validator = this.createContainmentValidator(this._jspFragmentFile, (IJSFViewValidator.IValidationReporter)reporter);
        IStructuredDocumentContext correctlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 487);
        this.checkTag(correctlyNested, validator, reporter, 0);
        reporter.reset();
        IStructuredDocumentContext firstIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 538);
        this.checkTag(firstIncorrectlyNested, validator, reporter, 0);
        reporter.reset();
        IStructuredDocumentContext secondIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 568);
        this.checkTag(secondIncorrectlyNested, validator, reporter, 0);
        reporter.reset();
    }

    private void checkTag(IStructuredDocumentContext context, ContainmentValidatingStrategy validator, MockValidationReporter reporter, int expectedCount) throws Exception {
        IndexedRegion region = JSFTestUtil.getIndexedRegion((IStructuredDocument)((IStructuredDocument)context.getStructuredDocument()), (int)context.getDocumentPosition());
        IDOMNode domNode = (IDOMNode)region;
        Node node = (Node)region;
        TestJSPSemanticsValidator_Containment.assertTrue((boolean)(node instanceof Element));
        Element elem = (Element)node;
        TestJSPSemanticsValidator_Containment.assertEquals((String)"inputText", (String)elem.getLocalName());
        System.out.println(CMUtil.getElementNamespaceURI((Element)elem));
        validator.validate((DOMAdapter)new Region2ElementAdapter((ITextRegion)domNode.getFirstStructuredDocumentRegion()));
        TestJSPSemanticsValidator_Containment.assertEquals((int)expectedCount, (int)reporter.getReportedProblems().size());
    }

    private ContainmentValidatingStrategy createContainmentValidator(IFile file, IJSFViewValidator.IValidationReporter reporter) {
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        DiagnosticFactory diagnosticFactory = new DiagnosticFactory();
        IDTViewHandler viewHandler = DTAppManagerUtil.getViewHandler((IProject)file.getProject());
        JSFValidationContext validationContext = new JSFValidationContext(false, prefs, viewHandler, diagnosticFactory, file, reporter, null);
        return new ContainmentValidatingStrategy(validationContext);
    }
}

