/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.JDTBeanPropertyWorkingCopy;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestJDTBeanPropertyWorkingCopy
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private IType _testBean1Type;
    private static final String srcFolderName = "src";
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJDTBeanPropertyWorkingCopy" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        projectTestEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data");
        String code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanName1, code);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)this._testBean1Type);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IProject project = this._jdtTestEnvironment.getJavaProject().getProject();
        try {
            project.close(null);
            project.delete(true, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }

    public void testSimpleBeanProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getStringProp1", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setStringProp1", new String[]{"QString;"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.addSetter(simpleSetter);
        workingCopy.setGetter(simpleGetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.lang.String;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }

    public void testSimpleIsBeanProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("isBooleanIsProp1", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setBooleanIsProp1", new String[]{"Z"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.addSetter(simpleSetter);
        workingCopy.setGetter(simpleGetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Z", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getType());
    }

    public void testIsAccessorTakesPrecedence() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleIsGetter = this._testBean1Type.getMethod("isBooleanIsProp2", new String[0]);
        IMethod simpleGetter = this._testBean1Type.getMethod("getBooleanIsProp2", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setBooleanIsProp2", new String[]{"Z"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleIsGetter);
        workingCopy.setIsGetter(simpleIsGetter);
        workingCopy.addSetter(simpleSetter);
        workingCopy.setGetter(simpleGetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleIsGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Z", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getType());
    }

    public void testDoNotUseSetterIfDoesNotMatchGetterType() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getStringProperty2", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setStringProperty2", new String[]{"I"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.addSetter(simpleSetter);
        workingCopy.setGetter(simpleGetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertFalse((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getSetter());
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.lang.String;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }

    public void testReadonlyBeanProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getReadonlyStringProperty", new String[0]);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        workingCopy.addSetter(null);
        workingCopy.setGetter(simpleGetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((!beanProperty.isWritable() ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getSetter());
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.lang.String;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
        workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod isGetter = this._testBean1Type.getMethod("isReadonlyBooleanProperty", new String[0]);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)isGetter);
        workingCopy.addSetter(null);
        workingCopy.setGetter(isGetter);
        beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertFalse((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == isGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getSetter());
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Z", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getType());
    }

    public void testWriteonlyBeanProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleSetter = this._testBean1Type.getMethod("setWriteonlyStringProperty", new String[]{"QString;"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.addSetter(simpleSetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertFalse((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertNull((Object)beanProperty.getGetter());
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.lang.String;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }

    public void testStringArrayProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getStringArrayProperty", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setStringArrayProperty", new String[]{"[QString;"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.setGetter(simpleGetter);
        workingCopy.addSetter(simpleSetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"[Ljava.lang.String;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }

    public void testCollectionProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getCollectionProperty", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setCollectionProperty", new String[]{"QCollection;"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.setGetter(simpleGetter);
        workingCopy.addSetter(simpleSetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.util.Collection;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }

    public void testMapProperty() {
        JDTBeanPropertyWorkingCopy workingCopy = new JDTBeanPropertyWorkingCopy(this._testBean1Type);
        IMethod simpleGetter = this._testBean1Type.getMethod("getMapProperty", new String[0]);
        IMethod simpleSetter = this._testBean1Type.getMethod("setMapProperty", new String[]{"QMap;"});
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleGetter);
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)simpleSetter);
        workingCopy.setGetter(simpleGetter);
        workingCopy.addSetter(simpleSetter);
        JDTBeanProperty beanProperty = workingCopy.toValueObject();
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty);
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isReadable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((boolean)beanProperty.isWritable());
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getGetter() == simpleGetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertTrue((beanProperty.getSetter() == simpleSetter ? 1 : 0) != 0);
        TestJDTBeanPropertyWorkingCopy.assertEquals((String)"Ljava.util.Map;", (String)beanProperty.getTypeSignature());
        TestJDTBeanPropertyWorkingCopy.assertNotNull((Object)beanProperty.getType());
    }
}

