/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.types;

import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorDiagnosticFactory;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;

public class TypeComparatorTests
extends TestCase {
    private final CompositeType simpleString = new CompositeType("Ljava.lang.String;", 2);
    private final CompositeType simpleInteger = new CompositeType("I", 2);
    private final CompositeType simpleLong = new CompositeType("J", 2);
    private final CompositeType simpleBoolean = new CompositeType("Z", 2);
    private final CompositeType simpleDouble = new CompositeType("D", 2);
    private final CompositeType boxedInteger = new CompositeType("Ljava.lang.Integer;", 2);
    private final CompositeType boxedLong = new CompositeType("Ljava.lang.Long;", 2);
    private final CompositeType boxedBoolean = new CompositeType("Ljava.lang.Boolean;", 2);
    private final CompositeType boxedDouble = new CompositeType("Ljava.lang.Double;", 2);
    private final CompositeType comparableType = new CompositeType("Ljava.lang.Comparable;", 2);
    private final CompositeType mapType = new CompositeType("Ljava.util.Map;", 2);
    private final CompositeType objectAndComparable = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.lang.Comparable;"}, 2);
    private final CompositeType objectAndMap = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.util.Map;"}, 2);
    private final CompositeType objectAndCollection = new CompositeType(new String[]{"Ljava.lang.Object;", "Ljava.util.Collection;"}, 2);
    private final CompositeType readWritePrimitiveLong = new CompositeType("J", 3);
    private final CompositeType readWriteString = new CompositeType("Ljava.lang.String;", 3);
    private final CompositeType readWriteObject = new CompositeType("Ljava.lang.Object;", 3);
    private final CompositeType writeOnlyObject = new CompositeType("Ljava.lang.Object;", 1);
    private static final String actionMethodSig = Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.String;");
    private static final String actionListenerSig = Signature.createMethodSignature((String[])new String[]{"Ljavax.faces.event.ActionEvent;"}, (String)"V");
    private static final String hasReturnAndArgSig = Signature.createMethodSignature((String[])new String[]{"Ljavax.faces.event.ActionEvent;"}, (String)"Ljava.lang.String;");
    private static final String sameNumArgsDiffTypeSig = Signature.createMethodSignature((String[])new String[]{"Ljava.lang.String;"}, (String)"Ljava.lang.String;");
    private final CompositeType actionMethod = new CompositeType(actionMethodSig, 0);
    private final CompositeType actionListener = new CompositeType(actionListenerSig, 0);
    private final CompositeType hasReturnAndArg = new CompositeType(hasReturnAndArgSig, 0);
    private final CompositeType actionAndActionListener = new CompositeType(new String[]{actionMethodSig, actionListenerSig}, 0);
    private final CompositeType sameNumArgsDiffType = new CompositeType(new String[]{sameNumArgsDiffTypeSig}, 0);
    private final CompositeType takesUnboxedInt = new CompositeType(Signature.createMethodSignature((String[])new String[]{"I"}, (String)"V"), 0);
    private final CompositeType takesBoxedInt = new CompositeType(Signature.createMethodSignature((String[])new String[]{"Ljava.lang.Integer;"}, (String)"V"), 0);
    private TypeComparator _typeComparator;

    protected void setUp() throws Exception {
        super.setUp();
        this._typeComparator = new TypeComparator(new TypeComparatorDiagnosticFactory(new TypeComparatorPreferences()));
    }

    public void testSimpleTypes() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleString, this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testIntegerCoercions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testLongCoercions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testBooleanCoercions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.boxedBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.boxedBoolean, this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.simpleDouble);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testDoubleCoercions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.simpleString);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.simpleBoolean);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testStringCoercions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleString, this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleString, this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleString, this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleString, this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testSimpleToBoxConversions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleInteger, this.boxedInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.boxedLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleDouble, this.boxedDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.simpleBoolean, this.boxedBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testBoxToSimpleConversions() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.boxedInteger, this.simpleInteger);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.boxedLong, this.simpleLong);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.boxedDouble, this.simpleDouble);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.boxedBoolean, this.simpleBoolean);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testObjectLists() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.comparableType, this.objectAndComparable);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.comparableType, this.objectAndCollection);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.mapType, this.objectAndMap);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.mapType, this.objectAndCollection);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testAssignability() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.simpleLong, this.readWritePrimitiveLong);
        TypeComparatorTests.assertEquals((int)result.getSeverity(), (int)0);
        result = this._typeComparator.calculateTypeCompatibility(this.readWritePrimitiveLong, this.simpleLong);
        TypeComparatorTests.assertNotSame((Object)result.getSeverity(), (Object)0);
        result = this._typeComparator.calculateTypeCompatibility(this.readWriteString, this.readWriteObject);
        TypeComparatorTests.assertNotSame((Object)result.getSeverity(), (Object)0);
        result = this._typeComparator.calculateTypeCompatibility(this.readWriteObject, this.writeOnlyObject);
        TypeComparatorTests.assertNotSame((Object)result.getSeverity(), (Object)0);
    }

    public void testMethodSignatures() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.actionMethod, this.actionMethod);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionListener, this.actionListener);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionMethod, this.actionListener);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionListener, this.actionMethod);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.hasReturnAndArg, this.hasReturnAndArg);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.takesBoxedInt, this.takesUnboxedInt);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.takesUnboxedInt, this.takesBoxedInt);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionMethod, this.hasReturnAndArg);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.hasReturnAndArg, this.actionMethod);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionListener, this.hasReturnAndArg);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.hasReturnAndArg, this.actionListener);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.hasReturnAndArg, this.sameNumArgsDiffType);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionAndActionListener, this.actionMethod);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionAndActionListener, this.actionListener);
        TypeComparatorTests.assertTrue((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.actionAndActionListener, this.hasReturnAndArg);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testValueMethodMix() {
        Diagnostic result = this._typeComparator.calculateTypeCompatibility(this.actionMethod, this.readWriteObject);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
        result = this._typeComparator.calculateTypeCompatibility(this.readWriteObject, this.actionMethod);
        TypeComparatorTests.assertFalse((result.getSeverity() == 0 ? 1 : 0) != 0);
    }
}

