/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.tagmatcher;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsf.core.set.mapping.ElementToTagIdentifierMapping;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.core.tests.tagmatcher.BaseTagMatcherTestCase;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestXPathTagMatcher
extends BaseTagMatcherTestCase {
    protected void setUp() throws Exception {
        this._srcFileName = "/testfiles/jsps/testdata1.jsp.data";
        this._destFileName = "/testdata1.jsp";
        super.setUp();
    }

    public void testSimpleMatches() {
        IDOMDocument doc = ((IDOMModel)this._structuredModel).getDocument();
        System.out.println(System.currentTimeMillis());
        XPathMatchingAlgorithm viewMatcher = new XPathMatchingAlgorithm("/view");
        AxiomaticSet set = viewMatcher.evaluate((Node)doc);
        System.out.println(System.currentTimeMillis());
        TestXPathTagMatcher.assertEquals((int)1, (int)set.size());
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._structuredDocument, 529);
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node node = resolver.getNode();
        TestXPathTagMatcher.assertEquals((String)"f:view", (String)node.getNodeName());
        System.out.println(CMUtil.getElementNamespaceURI((Element)((Element)node)));
        XPathMatchingAlgorithm matcher = new XPathMatchingAlgorithm("html/body/form/panelGrid/inputText");
        set = matcher.evaluate(node);
        System.out.println(System.currentTimeMillis());
        TestXPathTagMatcher.assertEquals((int)1, (int)set.size());
        Node inputText = (Node)set.getFirstElement();
        System.out.println(CMUtil.getElementNamespaceURI((Element)((Element)inputText)));
        matcher = new XPathMatchingAlgorithm("ancestor::*");
        set = matcher.evaluate(inputText);
        TestXPathTagMatcher.assertEquals((int)5, (int)set.size());
        set = new ElementToTagIdentifierMapping().map(set);
        for (TagIdentifier tagId : set) {
            System.out.println(tagId.getUri());
            System.out.println(tagId.getTagName());
        }
    }
}

