/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryregistry.migration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryUpgradeUtil;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.TestFileResource;

public class MigrationV1toV2Test
extends TestCase {
    private ByteArrayOutputStream _v1RegistryFile;
    private ByteArrayOutputStream _v2RegistryFile;
    private ByteArrayOutputStream _v1RegistryBackup;

    protected void setUp() throws Exception {
        MigrationV1toV2Test.assertEquals((int)32, (int)JSFCorePlugin.getDefault().getBundle().getState());
        JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
        this._v1RegistryFile = this.clearRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
        this._v2RegistryFile = this.clearRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
        this._v1RegistryBackup = this.clearRegistryFile(JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"));
    }

    private ByteArrayOutputStream clearRegistryFile(String fileName) throws Exception {
        File file = this.getRegistryFile(fileName);
        ByteArrayOutputStream backup = null;
        if (file.exists()) {
            backup = JSFTestUtil.loadFromFile((File)file);
            MigrationV1toV2Test.assertTrue((String)"Must be able to delete file: ".concat(fileName), (boolean)file.delete());
        }
        return backup;
    }

    protected void tearDown() throws Exception {
        this.tearDownRegistryFile(this._v1RegistryFile, ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
        this.tearDownRegistryFile(this._v2RegistryFile, ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
        this.tearDownRegistryFile(this._v1RegistryBackup, JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"));
    }

    private void tearDownRegistryFile(ByteArrayOutputStream backup, String name) throws Exception {
        if (backup != null) {
            JSFTestUtil.saveToFileSystem((byte[])backup.toByteArray(), (URI)JSFTestUtil.getPlatformAbsPath((String)name));
        } else {
            this.clearRegistryFile(name);
        }
    }

    private File getRegistryFile(String fileName) throws Exception {
        URI uri = JSFTestUtil.getPlatformAbsPath((String)fileName);
        return new File(uri);
    }

    public void testEmptyFileMigration() {
        TestFileResource emptyReg = new TestFileResource();
        try {
            emptyReg.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/EmptyJSFLibraryRegistryV1.xml.data");
            JSFTestUtil.savePlatformRelative((TestFileResource)emptyReg, (String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)emptyReg, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
            upgradeUtil.upgradeRegistryIfNecessary(2);
            MigrationV1toV2Test.assertEquals((int)0, (int)upgradeUtil.getUpgradeStatus().getSeverity());
            MigrationV1toV2Test.assertEquals((boolean)false, (boolean)upgradeUtil.getUpgradeStatus().isUpgradeOccurred());
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)emptyReg, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml".concat(".bkp"))));
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)emptyReg, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void testValidNonEmptyMigration() {
        TestFileResource validNonEmptyReg = new TestFileResource();
        try {
            validNonEmptyReg.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/ValidNonEmptyJSFLibraryRegistryV1.xml.data");
            JSFTestUtil.savePlatformRelative((TestFileResource)validNonEmptyReg, (String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validNonEmptyReg, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
            upgradeUtil.upgradeRegistryIfNecessary(2);
            MigrationV1toV2Test.assertEquals((int)0, (int)upgradeUtil.getUpgradeStatus().getSeverity());
            MigrationV1toV2Test.assertEquals((boolean)true, (boolean)upgradeUtil.getUpgradeStatus().isUpgradeOccurred());
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validNonEmptyReg, (URI)JSFTestUtil.getPlatformAbsPath((String)JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"))));
            TestFileResource expectedV2File = new TestFileResource();
            expectedV2File.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/ValidNonEmptyJSFLibraryRegistryV1_expectedMigrationResult.xml.data");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)expectedV2File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void testNoRegistryFileMigration() {
        JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
        upgradeUtil.upgradeRegistryIfNecessary(2);
        MigrationV1toV2Test.assertEquals((int)0, (int)upgradeUtil.getUpgradeStatus().getSeverity());
        MigrationV1toV2Test.assertEquals((boolean)false, (boolean)upgradeUtil.getUpgradeStatus().isUpgradeOccurred());
        try {
            File file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
            file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
            file = this.getRegistryFile(JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"));
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testV2AlreadyPresent_NoV1() {
        TestFileResource validV2File = new TestFileResource();
        try {
            validV2File.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/ValidNonEmptyJSFLibraryRegistryV2.xml.data");
            JSFTestUtil.savePlatformRelative((TestFileResource)validV2File, (String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV2File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml")));
            JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
            upgradeUtil.upgradeRegistryIfNecessary(2);
            MigrationV1toV2Test.assertEquals((int)0, (int)upgradeUtil.getUpgradeStatus().getSeverity());
            MigrationV1toV2Test.assertEquals((boolean)false, (boolean)upgradeUtil.getUpgradeStatus().isUpgradeOccurred());
            File file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
            file = this.getRegistryFile(JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"));
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
            file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            MigrationV1toV2Test.assertTrue((boolean)file.exists());
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV2File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testV2AlreadyPresent_WithV1() {
        TestFileResource validV2File = new TestFileResource();
        TestFileResource validV1File = new TestFileResource();
        try {
            validV1File.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/ValidNonEmptyJSFLibraryRegistryV1.xml.data");
            JSFTestUtil.savePlatformRelative((TestFileResource)validV1File, (String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV1File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            validV2File.load(TestsPlugin.getDefault().getBundle(), "/testfiles/JSFLib/registryFiles/ValidNonEmptyJSFLibraryRegistryV2.xml.data");
            JSFTestUtil.savePlatformRelative((TestFileResource)validV2File, (String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV1File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            JSFLibraryRegistryUpgradeUtil upgradeUtil = JSFLibraryRegistryUpgradeUtil.getInstance();
            upgradeUtil.upgradeRegistryIfNecessary(2);
            MigrationV1toV2Test.assertEquals((int)0, (int)upgradeUtil.getUpgradeStatus().getSeverity());
            MigrationV1toV2Test.assertEquals((boolean)false, (boolean)upgradeUtil.getUpgradeStatus().isUpgradeOccurred());
            File file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml");
            MigrationV1toV2Test.assertTrue((boolean)file.exists());
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV1File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            file = this.getRegistryFile(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            MigrationV1toV2Test.assertTrue((boolean)file.exists());
            MigrationV1toV2Test.assertTrue((boolean)JSFTestUtil.areEqual((TestFileResource)validV1File, (URI)JSFTestUtil.getPlatformAbsPath((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml")));
            file = this.getRegistryFile(JSFLibraryRegistryUpgradeUtil.getBackupFileName((String)".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistry.xml"));
            MigrationV1toV2Test.assertFalse((boolean)file.exists());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

