/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryregistry;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

public class JSFLibraryTestCases
extends TestCase {
    private JSFLibrary jsfLib = null;
    private String jsfLibID = "MyfacesID";
    private String jsfLibName = "MyfacesName";
    private String[] archivefiles = new String[]{"faces-all-bogus.jar", "faces-api-bogus.jar", "faces-impl-bogus.jar", "tomahawk-bogus.jar"};

    public JSFLibraryTestCases(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jsfLib = JSFCoreUtilHelper.constructJSFLib(this.jsfLibID, this.jsfLibName, this.archivefiles, true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.jsfLib = null;
    }

    public void testgetArchiveFiles() {
        EList el = this.jsfLib.getArchiveFiles();
        Assert.assertNotNull((Object)el);
        Assert.assertEquals((int)this.archivefiles.length, (int)el.size());
        Iterator it = el.iterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((String)this.archivefiles[i], (String)((ArchiveFile)it.next()).getName());
            ++i;
        }
    }

    public void testcontainsArchiveFile() {
        String pathTestFiles = String.valueOf(TestsPlugin.getInstallLocation().getPath()) + "testfiles/";
        Assert.assertTrue((boolean)this.jsfLib.containsArchiveFile(String.valueOf(pathTestFiles) + this.archivefiles[2]));
        Assert.assertFalse((boolean)this.jsfLib.containsArchiveFile(String.valueOf(pathTestFiles) + "bogus.jar"));
        Assert.assertFalse((boolean)this.jsfLib.containsArchiveFile(String.valueOf(pathTestFiles) + "sandbox.jar"));
    }

    public void testgetWorkingCopy() {
        JSFLibrary jsfLibWorkingCopy = this.jsfLib.getWorkingCopy();
        Assert.assertNotNull((Object)jsfLibWorkingCopy);
        Assert.assertEquals((int)jsfLibWorkingCopy.getArchiveFiles().size(), (int)this.jsfLib.getArchiveFiles().size());
    }

    public void testupdateValue() {
        String[] archives = new String[]{"faces-all-bogus.jar", "faces-api-bogus.jar"};
        JSFLibrary jsfLibtmp = JSFCoreUtilHelper.constructJSFLib("jsfLibTmp", "jsfLibTmpName", archives, true);
        jsfLibtmp.updateValues(this.jsfLib);
        Assert.assertEquals((String)jsfLibtmp.getID(), (String)this.jsfLib.getID());
        Assert.assertEquals((String)jsfLibtmp.getName(), (String)this.jsfLib.getName());
        Assert.assertEquals((int)jsfLibtmp.getArchiveFiles().size(), (int)this.jsfLib.getArchiveFiles().size());
    }
}

