/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryregistry;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

public class JSFLibraryRegistryTestCases
extends TestCase {
    public JSFLibraryRegistryTestCases(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDefaultImplementationID() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        Assert.assertEquals((String)"", (String)jsfLibRegistry.getDefaultImplementationID());
    }

    public void testSetDefaultImplementationID() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        String updatedImplID = "myfaces_reg";
        jsfLibRegistry.setDefaultImplementationID(updatedImplID);
        Assert.assertEquals((String)updatedImplID, (String)jsfLibRegistry.getDefaultImplementationID());
    }

    public void testGetJSFLibraries() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        String[] archivefiles = new String[]{"faces-all-bogu.jar", "faces-api-bogus.jar", "faces-impl-bogus.jar", "tomahawk-bogus.jar"};
        JSFLibrary implJSFLib = JSFCoreUtilHelper.constructJSFLib("impljsflib_id", "impljsflib_name", archivefiles, true);
        JSFLibrary nonimplJSFLib = JSFCoreUtilHelper.constructJSFLib("nonimpljsflib_id", "nonimpljsflib_name", archivefiles, false);
        jsfLibRegistry.addJSFLibrary(implJSFLib);
        jsfLibRegistry.addJSFLibrary(nonimplJSFLib);
        Assert.assertEquals((int)2, (int)jsfLibRegistry.getJSFLibraries().size());
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getImplJSFLibraries().size());
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getNonImplJSFLibraries().size());
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getJSFLibrariesByName("impljsflib_name").size());
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getJSFLibrariesByName("nonimpljsflib_name").size());
        Assert.assertNull((Object)jsfLibRegistry.getJSFLibraryByID("nosuchlib_id"));
    }

    public void testGetPluginProvidedJSFLibraries() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        PluginProvidedJSFLibrary pluginLib = (PluginProvidedJSFLibrary)JSFCoreUtilHelper.constructJSFLib("plugin_provided", "testfiles/JSFLib", true, true);
        jsfLibRegistry.addJSFLibrary((JSFLibrary)pluginLib);
        JSFLibrary nonPluginLib = JSFCoreUtilHelper.constructJSFLib("non_plugin_provided", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(nonPluginLib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getPluginProvidedJSFLibraries().size());
        Assert.assertEquals((String)pluginLib.getName(), (String)pluginLib.getLabel());
        pluginLib.setLabel("plugin_providedLABEL");
        Assert.assertEquals((String)"plugin_providedLABEL", (String)pluginLib.getLabel());
        Assert.assertEquals((String)nonPluginLib.getName(), (String)nonPluginLib.getLabel());
        Assert.assertEquals((String)nonPluginLib.getName(), (String)nonPluginLib.getID());
    }

    public void testGetDefaultImplementation() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib);
        jsfLibRegistry.setDefaultImplementation(lib);
        Assert.assertEquals((Object)lib, (Object)jsfLibRegistry.getDefaultImplementation());
    }

    public void testSetDefaultImplementation() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib);
        jsfLibRegistry.setDefaultImplementation(lib);
        Assert.assertEquals((Object)lib, (Object)jsfLibRegistry.getDefaultImplementation());
    }

    public void testGetJSFLibraryByID() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib);
        String libID = "lib";
        Assert.assertEquals((Object)lib, (Object)jsfLibRegistry.getJSFLibraryByID(libID));
    }

    public void testGetJSFLibrariesByName() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        String lib1Name = "Sun RI v1.1";
        JSFLibrary lib1 = JSFCoreUtilHelper.constructJSFLib(lib1Name, "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib1);
        String lib2Name = "Another Sun RI v1.1";
        JSFLibrary lib2 = JSFCoreUtilHelper.constructJSFLib(lib2Name, "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib2);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getJSFLibrariesByName(lib1Name).size());
    }

    public void testGetImplJSFLibraries() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary implLib = JSFCoreUtilHelper.constructJSFLib("impl_lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(implLib);
        JSFLibrary nonImplLib = JSFCoreUtilHelper.constructJSFLib("non_impl_lib", "testfiles/JSFLib", false, false);
        jsfLibRegistry.addJSFLibrary(nonImplLib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getImplJSFLibraries().size());
    }

    public void testGetNonImplJSFLibraries() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary implLib = JSFCoreUtilHelper.constructJSFLib("impl_lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(implLib);
        JSFLibrary nonImplLib = JSFCoreUtilHelper.constructJSFLib("non_impl_lib", "testfiles/JSFLib", false, false);
        jsfLibRegistry.addJSFLibrary(nonImplLib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getNonImplJSFLibraries().size());
    }

    public void testGetAllJSFLibraries() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary lib1 = JSFCoreUtilHelper.constructJSFLib("plugin_provided", "testfiles/JSFLib", true, true);
        jsfLibRegistry.addJSFLibrary(lib1);
        JSFLibrary lib2 = JSFCoreUtilHelper.constructJSFLib("non_plugin_provided", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib2);
        Assert.assertEquals((int)2, (int)jsfLibRegistry.getAllJSFLibraries().size());
    }

    public void testAddJSFLibrary() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary pluginLib = JSFCoreUtilHelper.constructJSFLib("plugin_provided", "testfiles/JSFLib", true, true);
        jsfLibRegistry.addJSFLibrary(pluginLib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getPluginProvidedJSFLibraries().size());
        Assert.assertEquals((int)0, (int)jsfLibRegistry.getJSFLibraries().size());
        JSFLibrary nonPluginLib = JSFCoreUtilHelper.constructJSFLib("non_plugin_provided", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(nonPluginLib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getPluginProvidedJSFLibraries().size());
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getJSFLibraries().size());
    }

    public void testRemoveJSFLibrary() {
        JSFLibraryRegistry jsfLibRegistry = JSFCoreUtilHelper.getNewJSFLibraryRegistry();
        JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("lib", "testfiles/JSFLib", true, false);
        jsfLibRegistry.addJSFLibrary(lib);
        Assert.assertEquals((int)1, (int)jsfLibRegistry.getJSFLibraries().size());
        jsfLibRegistry.removeJSFLibrary(lib);
        Assert.assertEquals((int)0, (int)jsfLibRegistry.getJSFLibraries().size());
    }

    public void testPluginProvidedJSFLibCreationFromExtPt() {
        JSFLibraryRegistry jsfLibRegistry = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
        EList libs = jsfLibRegistry.getJSFLibrariesByName("TEST_PP_LIB_2");
        Assert.assertNotNull((Object)libs);
        Assert.assertEquals((int)1, (int)libs.size());
        JSFLibrary lib = (JSFLibrary)libs.get(0);
        Assert.assertTrue((boolean)(lib instanceof PluginProvidedJSFLibrary));
        Assert.assertEquals((int)2, (int)lib.getArchiveFiles().size());
        Assert.assertEquals((String)"FAKE LIB FROM jsf.core.tests (1)", (String)lib.getLabel());
        Assert.assertTrue((boolean)lib.isImplementation());
        libs = jsfLibRegistry.getJSFLibrariesByName("TEST_PP_LIB_EMPTY");
        Assert.assertNotNull((Object)libs);
        Assert.assertEquals((int)1, (int)libs.size());
        lib = (JSFLibrary)libs.get(0);
        Assert.assertTrue((boolean)(lib instanceof PluginProvidedJSFLibrary));
        Assert.assertEquals((int)0, (int)lib.getArchiveFiles().size());
        Assert.assertEquals((String)"FAKE LIB FROM jsf.core.tests (2)", (String)lib.getLabel());
        Assert.assertFalse((boolean)lib.isImplementation());
    }
}

