/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceUtils.class);

    public static <T> T getService(BundleContext bundleContext, Class<T> clazz, String requiredProperty, String requiredPropertyValue) {
        T result;
        block9: {
            result = null;
            try {
                ServiceReference[] serviceReferences = bundleContext.getServiceReferences(null, String.format("(%s=*)", requiredProperty));
                if (serviceReferences == null) break block9;
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    Object potentialResult;
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    Object offeredPropertyValue = serviceReference.getProperty(requiredProperty);
                    if (offeredPropertyValue instanceof String) {
                        String offeredProperty = (String)offeredPropertyValue;
                        if (offeredProperty != null && requiredPropertyValue.equals(offeredProperty) && clazz.isInstance(potentialResult = bundleContext.getService(serviceReference))) {
                            result = clazz.cast(bundleContext.getService(serviceReference));
                            break;
                        }
                    } else if (offeredPropertyValue instanceof String[]) {
                        String[] offeredProperties = (String[])offeredPropertyValue;
                        if (offeredProperties != null && ServiceUtils.arrayContainsEntry(offeredProperties, requiredPropertyValue) && clazz.isInstance(potentialResult = bundleContext.getService(serviceReference))) {
                            result = clazz.cast(bundleContext.getService(serviceReference));
                            break;
                        }
                    } else {
                        LOGGER.warn(String.format("Matching service found from bundle %d but with a bad type for the '%s' property, String or String[] expected.", serviceReference.getBundle().getBundleId(), requiredProperty));
                    }
                    ++n2;
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Unexpected InvalidSyntaxException", e);
            }
        }
        return result;
    }

    private static <T> boolean arrayContainsEntry(T[] array, T entry) {
        if (entry == null || array == null) {
            return false;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T arrayEntry = TArray[n2];
            if (arrayEntry != null && arrayEntry.equals(entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

