/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.util.Properties;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.ConfigInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StartEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StopEngine;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.core.Signal;
import org.eclipse.virgo.nano.deployer.api.config.ConfigurationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;

final class StandardConfigInstallArtifact
extends AbstractInstallArtifact
implements ConfigInstallArtifact {
    private final StartEngine startEngine;
    private final RefreshEngine refreshEngine;
    private final StopEngine stopEngine;
    private final ConfigurationDeployer configurationDeployer;

    StandardConfigInstallArtifact(@NonNull ArtifactIdentity identity, @NonNull ArtifactStorage artifactStorage, @NonNull StartEngine startEngine, @NonNull RefreshEngine refreshEngine, @NonNull StopEngine stopEngine, @NonNull ArtifactStateMonitor artifactStateMonitor, String repositoryName, EventLogger eventLogger, ConfigurationDeployer configurationDeployer) throws DeploymentException {
        super(identity, artifactStorage, artifactStateMonitor, repositoryName, eventLogger);
        this.startEngine = startEngine;
        this.refreshEngine = refreshEngine;
        this.stopEngine = stopEngine;
        this.configurationDeployer = configurationDeployer;
    }

    @Override
    protected void doStop() throws DeploymentException {
        this.stopEngine.stop(this.getIdentity(), this.getArtifactFS());
    }

    @Override
    public boolean doRefresh() throws DeploymentException {
        this.refreshEngine.refresh(this.getIdentity(), this.getArtifactFS());
        return true;
    }

    @Override
    protected void doUninstall() throws DeploymentException {
    }

    @Override
    protected final void doStart(AbortableSignal signal) throws DeploymentException {
        try {
            this.startEngine.start(this.getIdentity(), this.getArtifactFS());
            StandardConfigInstallArtifact.signalSuccessfulCompletion((Signal)signal);
        }
        catch (DeploymentException e) {
            StandardConfigInstallArtifact.signalFailure((Signal)signal, e);
            throw e;
        }
        catch (RuntimeException e) {
            StandardConfigInstallArtifact.signalFailure((Signal)signal, e);
            throw e;
        }
    }

    @Override
    public Properties getProperties() throws IOException {
        return this.configurationDeployer.getConfiguration(this.getName());
    }
}

