/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.framework;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    public static final String PROPERTY_KERNEL_STARTUP_WAIT_LIMIT = "org.eclipse.virgo.kernel.startup.wait.limit";
    private static final Logger LOGGER;
    private static final int DEFAULT_STARTUP_WAIT_LIMIT = 180;
    private static volatile int maxSecondsWaitForService;
    private static volatile long maxMillisWaitForService;
    private static final Object monitor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("ServiceUtils.java", Class.forName("org.eclipse.virgo.kernel.osgi.framework.ServiceUtils"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readBundleStartupWaitLimit", "org.eclipse.virgo.kernel.osgi.framework.ServiceUtils", "org.osgi.framework.BundleContext:", "context:", "", "int"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readFrameworkProperty", "org.eclipse.virgo.kernel.osgi.framework.ServiceUtils", "java.lang.String:org.osgi.framework.BundleContext:", "propertyKey:context:", "", "java.lang.String"), 106);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "hasText", "org.eclipse.virgo.kernel.osgi.framework.ServiceUtils", "java.lang.String:", "string:", "", "boolean"), 110);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "sleepABitMore", "org.eclipse.virgo.kernel.osgi.framework.ServiceUtils", "", "", "java.lang.InterruptedException:", "long"), 114);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.framework.ServiceUtils");
        LOGGER = LoggerFactory.getLogger(ServiceUtils.class);
        maxSecondsWaitForService = 180;
        maxMillisWaitForService = 0L;
        monitor = new Object();
    }

    public ServiceUtils() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass) throws TimeoutException, InterruptedException {
        try {
            T service = null;
            long millisWaited = 0L;
            while (service == null && millisWaited <= ServiceUtils.getInitialisedWaitLimit(context)) {
                try {
                    OsgiServiceHolder<T> serviceHolder = OsgiFrameworkUtils.getService(context, serviceClass);
                    if (serviceHolder != null) {
                        service = serviceHolder.getService();
                        continue;
                    }
                    millisWaited += ServiceUtils.sleepABitMore();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (service == null) {
                throw new TimeoutException(serviceClass.getName());
            }
            return service;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getInitialisedWaitLimit(BundleContext context) {
        try {
            if (maxMillisWaitForService == 0L) {
                Object object = monitor;
                synchronized (object) {
                    if (maxMillisWaitForService == 0L) {
                        maxSecondsWaitForService = ServiceUtils.readBundleStartupWaitLimit(context);
                        maxMillisWaitForService = TimeUnit.SECONDS.toMillis(maxSecondsWaitForService);
                    }
                }
            }
            return maxMillisWaitForService;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static long getWaitLimitSeconds() {
        try {
            return maxSecondsWaitForService;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static int readBundleStartupWaitLimit(BundleContext context) {
        try {
            try {
                int n;
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                String waitLimitProperty = ServiceUtils.readFrameworkProperty(PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, context);
                if (!ServiceUtils.hasText(waitLimitProperty)) {
                    n = 180;
                } else {
                    try {
                        n = Integer.parseInt(waitLimitProperty);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Could not parse property {} with value '{}'. Using default limit {} seconds", new Object[]{PROPERTY_KERNEL_STARTUP_WAIT_LIMIT, waitLimitProperty, 180});
                        n = 180;
                    }
                }
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String readFrameworkProperty(String propertyKey, BundleContext context) {
        try {
            try {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                String string = context.getProperty(propertyKey);
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return string;
            }
            catch (Throwable throwable) {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean hasText(String string) {
        try {
            try {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                boolean bl = string != null && !string.trim().isEmpty();
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return bl;
            }
            catch (Throwable throwable) {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static long sleepABitMore() throws InterruptedException {
        try {
            try {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                long before = System.currentTimeMillis();
                Thread.sleep(100L);
                long l = System.currentTimeMillis() - before;
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return l;
            }
            catch (Throwable throwable) {
                ServiceUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

