/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.resolver;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.apache.bval.jsr303.resolver.CachingRelevant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private TraversableResolver delegate;
    private Map<CacheEntry, CacheEntry> cache = new HashMap<CacheEntry, CacheEntry>();

    public static boolean needsCaching(TraversableResolver resolver) {
        return !(resolver instanceof CachingRelevant) || ((CachingRelevant)resolver).needsCaching();
    }

    public CachingTraversableResolver(TraversableResolver delegate) {
        this.delegate = delegate;
    }

    public static TraversableResolver cacheFor(TraversableResolver traversableResolver) {
        if (CachingTraversableResolver.needsCaching(traversableResolver)) {
            return new CachingTraversableResolver(traversableResolver);
        }
        return traversableResolver;
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        CacheEntry currentLH = new CacheEntry(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        CacheEntry cachedLH = this.cache.get(currentLH);
        if (cachedLH == null) {
            currentLH.reachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.cache.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.reachable == null) {
            cachedLH.reachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.reachable;
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        CacheEntry currentLH = new CacheEntry(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        CacheEntry cachedLH = this.cache.get(currentLH);
        if (cachedLH == null) {
            currentLH.cascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.cache.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.cascadable == null) {
            cachedLH.cascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.cascadable;
    }

    @Override
    public boolean needsCaching() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry {
        private final Object object;
        private final Path.Node node;
        private final Class<?> type;
        private final Path path;
        private final ElementType elementType;
        private final int hashCode;
        private Boolean reachable;
        private Boolean cascadable;

        private CacheEntry(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            this.object = traversableObject;
            this.node = traversableProperty;
            this.type = rootBeanType;
            this.path = pathToTraversableObject;
            this.elementType = elementType;
            this.hashCode = this.buildHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheEntry that = (CacheEntry)o;
            return this.elementType == that.elementType && this.path.equals(that.path) && this.type.equals(that.type) && !(this.object == null ? that.object != null : !this.object.equals(that.object)) && this.node.equals(that.node);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int buildHashCode() {
            int result = this.object != null ? this.object.hashCode() : 0;
            result = 31 * result + this.node.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.elementType.hashCode();
            return result;
        }
    }
}

