/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantValue;
import org.apache.tomcat.util.bcel.classfile.FieldOrMethod;
import org.apache.tomcat.util.bcel.classfile.Utility;
import org.apache.tomcat.util.bcel.util.BCELComparator;

public final class Field
extends FieldOrMethod {
    private static final long serialVersionUID = 2646214544240375238L;
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            Field THIS = (Field)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    Field(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public final ConstantValue getConstantValue() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (this.attributes[i].getTag() != 1) continue;
            return (ConstantValue)this.attributes[i];
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        access = access.equals("") ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuffer buf = new StringBuffer(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (int i = 0; i < this.attributes_count; ++i) {
            Attribute a = this.attributes[i];
            if (a instanceof ConstantValue) continue;
            buf.append(" [").append(a.toString()).append("]");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

