/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WebBundleUrl {
    public static final String SCHEME = "webbundle";
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public final Object monitor = new Object();
    private final URL url;
    private final String location;
    private Map<String, String> options;

    public WebBundleUrl(String location, Map<String, String> options) throws MalformedURLException {
        this.url = this.createURL(location, options);
        this.location = location;
        this.options = options == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(options));
    }

    public WebBundleUrl(URL url) {
        String protocol = url.getProtocol();
        if (!SCHEME.equals(protocol)) {
            throw new IllegalArgumentException("URL '" + url + "' is not a valid WAR URL");
        }
        this.url = url;
        this.location = url.getPath();
    }

    public final String getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> getOptions() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.options == null) {
                this.options = WebBundleUrl.parseQueryString(this.url.getQuery());
            }
        }
        return this.options;
    }

    private String toPathString(String location, Map<?, ?> options) {
        StringBuilder sb = new StringBuilder();
        sb.append(location);
        WebBundleUrl.appendQueryStringIfNecessary(options, sb);
        return sb.toString();
    }

    public final String toString() {
        return this.url.toString();
    }

    public final URL toURL() {
        return this.url;
    }

    protected URLStreamHandler createURLStreamHandler() {
        return null;
    }

    private URL createURL(String location, Map<?, ?> options) throws MalformedURLException {
        return new URL(SCHEME, null, -1, this.toPathString(location, options), this.createURLStreamHandler());
    }

    private static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (query != null) {
            String[] parms;
            String[] stringArray = parms = query.split("&");
            int n = parms.length;
            int n2 = 0;
            while (n2 < n) {
                String parm = stringArray[n2];
                int equals = parm.indexOf("=");
                if (equals == -1) {
                    throw new IllegalArgumentException("Missing '=' in URL parameter '" + parm + "'");
                }
                options.put(WebBundleUrl.decode(parm.substring(0, equals)), WebBundleUrl.decode(parm.substring(equals + 1)));
                ++n2;
            }
        }
        return Collections.unmodifiableMap(options);
    }

    private static String decode(String parm) {
        try {
            return URLDecoder.decode(parm, DEFAULT_CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot decode '" + parm + "'.", e);
        }
    }

    private static void appendQueryStringIfNecessary(Map<?, ?> options, StringBuilder sb) {
        if (options != null && !options.isEmpty()) {
            sb.append("?");
            for (Map.Entry<?, ?> entry : options.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
    }
}

