/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.gemini.web.core.spi.WebApplicationHandle;
import org.eclipse.gemini.web.internal.EventManager;
import org.eclipse.gemini.web.internal.WebApplicationStartFailureRetryController;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardWebApplication
implements WebApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardWebApplication.class);
    private final BundleContext bundleContext;
    private final Bundle extender;
    private final WebApplicationHandle handle;
    private final ServletContainer container;
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private final EventManager eventManager;
    private boolean started = false;
    private final Object monitor = new Object();
    private final WebApplicationStartFailureRetryController retryController;

    public StandardWebApplication(BundleContext bundleContext, Bundle extender, WebApplicationHandle handle, ServletContainer container, EventManager eventManager, WebApplicationStartFailureRetryController retryController) {
        this.bundleContext = bundleContext;
        this.extender = extender;
        this.handle = handle;
        this.container = container;
        this.eventManager = eventManager;
        this.retryController = retryController;
    }

    @Override
    public ServletContext getServletContext() {
        return this.handle.getServletContext();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.handle.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        boolean localStarted;
        Object object = this.monitor;
        synchronized (object) {
            localStarted = this.started;
        }
        if (!localStarted) {
            String webContextPath = this.getContextPath();
            this.eventManager.sendDeploying(this.getBundle(), this.extender, webContextPath);
            try {
                this.container.startWebApplication(this.handle);
                this.publishServletContext();
                Object object2 = this.monitor;
                synchronized (object2) {
                    this.started = true;
                }
                this.eventManager.sendDeployed(this.getBundle(), this.extender, webContextPath);
            }
            catch (ServletContainerException ex) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to start web application at bundleContext path '" + this.handle.getServletContext().getContextPath() + "'", (Throwable)ex);
                }
                this.retryController.recordFailure(this);
                Set<Long> webContextPathBundleIds = this.getWebContextPathBundleIds(webContextPath);
                boolean collision = webContextPathBundleIds.size() > 1;
                this.eventManager.sendFailed(this.getBundle(), this.extender, webContextPath, ex, collision ? webContextPath : null, collision ? webContextPathBundleIds : null);
                throw new WebApplicationStartFailedException(ex);
            }
        }
    }

    private Set<Long> getWebContextPathBundleIds(String webContextPath) {
        HashSet<Long> bundleIds = new HashSet<Long>();
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (webContextPath.equals(WebContainerUtils.getContextPath(bundle))) {
                bundleIds.add(bundle.getBundleId());
            }
            ++n2;
        }
        return bundleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean localStarted;
        Object object = this.monitor;
        synchronized (object) {
            localStarted = this.started;
            this.started = false;
        }
        if (localStarted) {
            this.eventManager.sendUndeploying(this.getBundle(), this.extender, this.getContextPath());
            this.container.stopWebApplication(this.handle);
            this.tracker.unregisterAll();
            this.eventManager.sendUndeployed(this.getBundle(), this.extender, this.getContextPath());
        }
        this.retryController.retryFailures(this);
    }

    private void publishServletContext() {
        Dictionary<String, String> properties = this.constructServletContextProperties();
        this.tracker.track(this.bundleContext.registerService(ServletContext.class, (Object)this.getServletContext(), properties));
    }

    String getContextPath() {
        return this.handle.getServletContext().getContextPath();
    }

    Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    private Dictionary<String, String> constructServletContextProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        Bundle bundle = this.getBundle();
        WebContainerUtils.setServletContextBundleProperties(properties, bundle);
        ((Dictionary)properties).put("osgi.web.contextpath", this.getServletContext().getContextPath());
        return properties;
    }
}

