/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.completers;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter;
import org.eclipse.virgo.kernel.shell.internal.util.ArtifactRetriever;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;

final class ConfigCompleter
extends AbstractInstallArtifactCompleter {
    private static final String TYPE = "configuration";
    private static final String COMMAND_EXAMINE = "examine";
    private static final String STATE_ACTIVE = "ACTIVE";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;
    private final ArtifactRetriever<ManageableArtifact> artifactRetriever;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ConfigCompleter(RuntimeArtifactModelObjectNameCreator objectNameCreator) {
        super(TYPE, objectNameCreator);
        this.objectNameCreator = objectNameCreator;
        this.artifactRetriever = new ArtifactRetriever<ManageableArtifact>(TYPE, objectNameCreator, ManageableArtifact.class);
    }

    @Override
    protected void filter(Set<String> candidates, String subcommand, String ... tokens) {
        try {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            if (COMMAND_EXAMINE.equals(subcommand)) {
                if (tokens.length == 2) {
                    this.filterVersions(tokens[0], candidates);
                } else if (tokens.length == 1) {
                    this.filterNames(candidates);
                }
            }
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void filterVersions(String name, Set<String> candidates) {
        try {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            Iterator<String> i = candidates.iterator();
            while (i.hasNext()) {
                try {
                    ManageableArtifact artifact = this.artifactRetriever.getArtifact(name, new Version(i.next()));
                    if (STATE_ACTIVE.equals(artifact.getState())) continue;
                    i.remove();
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void filterNames(Set<String> candidates) {
        try {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            Iterator<String> i = candidates.iterator();
            while (i.hasNext()) {
                Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactVersionsQuery(TYPE, i.next()), null);
                boolean hasActive = false;
                for (ObjectName objectName : objectNames) {
                    try {
                        ManageableArtifact artifact = this.artifactRetriever.getArtifact(objectName);
                        if (!STATE_ACTIVE.equals(artifact.getState())) continue;
                        hasActive = true;
                        break;
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {}
                }
                if (hasActive) continue;
                i.remove();
            }
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ConfigCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigCompleter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.completers.ConfigCompleter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("84", "filter", "org.eclipse.virgo.kernel.shell.internal.completers.ConfigCompleter", "java.util.Set:java.lang.String:[Ljava.lang.String;:", "candidates:subcommand:tokens:", "", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterVersions", "org.eclipse.virgo.kernel.shell.internal.completers.ConfigCompleter", "java.lang.String:java.util.Set:", "name:candidates:", "", "void"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterNames", "org.eclipse.virgo.kernel.shell.internal.completers.ConfigCompleter", "java.util.Set:", "candidates:", "", "void"), 74);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.completers.ConfigCompleter");
    }
}

