/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management;

import java.util.List;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.eclipse.gemini.management.ObjectNameTranslator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

final class DefaultObjectNameTranslator
implements ObjectNameTranslator {
    private static final Logger LOGGER = Logger.getLogger(DefaultObjectNameTranslator.class.getCanonicalName());

    DefaultObjectNameTranslator() {
    }

    @Override
    public ObjectName translate(ObjectName objectName) {
        return objectName;
    }

    static ObjectNameTranslator initialiseObjectNameTranslator(BundleContext bundleContext) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Bundle bundle = bundleContext.getBundle();
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List requiredWires = wiring.getProvidedWires("osgi.wiring.host");
        for (BundleWire bundleWire : requiredWires) {
            Bundle fragment = bundleWire.getRequirerWiring().getBundle();
            String objectNameTranslator = (String)fragment.getHeaders().get("GeminiManagement-ObjectNameTranslator");
            if (objectNameTranslator == null) continue;
            Class objectNameTranslatorClass = bundle.loadClass(objectNameTranslator);
            if (ObjectNameTranslator.class.isAssignableFrom(objectNameTranslatorClass)) {
                try {
                    return (ObjectNameTranslator)objectNameTranslatorClass.getConstructor(BundleContext.class).newInstance(bundleContext);
                }
                catch (Exception e) {
                    LOGGER.warning(String.format("Unable to create ObjectNameTranslator from fragment %d '%s'", fragment.getBundleId(), e.getMessage()));
                    continue;
                }
            }
            LOGGER.warning(String.format("Unable to create ObjectNameTranslator as specified class '%s' is not an assignable to '%s'", objectNameTranslator, ObjectNameTranslator.class.getName()));
        }
        return new DefaultObjectNameTranslator();
    }
}

