/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.storage;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtil {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";

    public static String encrypt(String originalText) throws Exception {
        try {
            String password_salt = DigestUtil.appendSalt(originalText);
            byte[] sha_digest = DigestUtil.getDigest(password_salt.getBytes(), SHA1);
            return DigestUtil.asHex(sha_digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("Encryption Failed!");
        }
    }

    private static String appendSalt(String inputPassword) throws NoSuchAlgorithmException {
        byte[] salt = DigestUtil.getDigest(inputPassword.getBytes(), MD5);
        return String.valueOf(inputPassword) + DigestUtil.asHex(salt);
    }

    private static String asHex(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        int i = 0;
        while (i < buf.length) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
            ++i;
        }
        return new String(chars);
    }

    private static byte[] getDigest(byte[] inputData, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(inputData);
        return md.digest();
    }
}

