/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.io.internal.resolver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.springframework.osgi.io.internal.OsgiHeaderUtils;
import org.springframework.osgi.io.internal.resolver.DependencyResolver;
import org.springframework.osgi.io.internal.resolver.ImportedBundle;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PackageAdminResolver
implements DependencyResolver {
    private static final Log log = LogFactory.getLog((Class)PackageAdminResolver.class);
    private final BundleContext bundleContext;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    public PackageAdminResolver(BundleContext bundleContext) {
        Assert.notNull((Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public ImportedBundle[] getImportedBundles(Bundle bundle) {
        boolean trace = log.isTraceEnabled();
        PackageAdmin pa = this.getPackageAdmin();
        LinkedHashMap importedBundles = new LinkedHashMap(8);
        String[] entries = OsgiHeaderUtils.getRequireBundle(bundle);
        for (int i = 0; i < entries.length; ++i) {
            String versionRange;
            String[] parsed = OsgiHeaderUtils.parseRequiredBundleString(entries[i]);
            String symName = parsed[0].trim();
            Object[] foundBundles = pa.getBundles(symName, versionRange = parsed[1].trim());
            if (!ObjectUtils.isEmpty((Object[])foundBundles)) {
                Object requiredBundle = foundBundles[0];
                ExportedPackage[] exportedPackages = pa.getExportedPackages((Bundle)requiredBundle);
                if (exportedPackages == null) continue;
                this.addExportedPackages(importedBundles, (Bundle)requiredBundle, exportedPackages);
                continue;
            }
            if (!trace) continue;
            log.trace((Object)("Cannot find required bundle " + symName + "|" + versionRange));
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ExportedPackage[] epa;
            Bundle analyzedBundle = bundles[i];
            if (importedBundles.containsKey(analyzedBundle) || (epa = pa.getExportedPackages(analyzedBundle)) == null) continue;
            for (int j = 0; j < epa.length; ++j) {
                ExportedPackage exportedPackage = epa[j];
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (int k = 0; k < importingBundles.length; ++k) {
                    if (!bundle.equals(importingBundles[k])) continue;
                    this.addImportedBundle(importedBundles, exportedPackage);
                }
            }
        }
        ArrayList<ImportedBundle> importedBundlesList = new ArrayList<ImportedBundle>(importedBundles.size());
        Iterator iterator = importedBundles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Bundle importedBundle = (Bundle)entry.getKey();
            List packages = (List)entry.getValue();
            importedBundlesList.add(new ImportedBundle(importedBundle, packages.toArray(new String[packages.size()])));
        }
        return importedBundlesList.toArray(new ImportedBundle[importedBundlesList.size()]);
    }

    private void addImportedBundle(Map map, ExportedPackage expPackage) {
        Bundle bnd = expPackage.getExportingBundle();
        ArrayList<String> packages = (ArrayList<String>)map.get(bnd);
        if (packages == null) {
            packages = new ArrayList<String>(4);
            map.put(bnd, packages);
        }
        packages.add(new String(expPackage.getName()));
    }

    private void addExportedPackages(Map map, Bundle bundle, ExportedPackage[] pkgs) {
        ArrayList<String> packages = (ArrayList<String>)map.get(bundle);
        if (packages == null) {
            packages = new ArrayList<String>(pkgs.length);
            map.put(bundle, packages);
        }
        for (int i = 0; i < pkgs.length; ++i) {
            packages.add(pkgs[i].getName());
        }
    }

    private PackageAdmin getPackageAdmin() {
        return (PackageAdmin)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServiceReference ref = PackageAdminResolver.this.bundleContext.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = PackageAdminResolver.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
                if (ref == null) {
                    throw new IllegalStateException((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = PackageAdminResolver.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName() + " service is required");
                }
                return (PackageAdmin)PackageAdminResolver.this.bundleContext.getService(ref);
            }
        });
    }
}

